/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.BundleBase;
import com.intellij.GetPolicy;
import com.intellij.IntelliJResourceBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.text.OrdinalFormat;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aE\u0010\u000f\u001a\u00070\b\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\r\u0010\u0014\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\u00102\u0012\u0010\u0015\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0016\u0018\u00010\u0007H\u0007\u00a2\u0006\u0002\u0010\u0017\u001a@\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\r\u0010\u0014\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\u00102\u0012\u0010\u0015\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0016\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a*\u0010\u0019\u001a\u00020\b2\b\b\u0001\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u001cH\u0000\u001a;\u0010\u001d\u001a\u00070\b\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000b\u0010\u001a\u001a\u00070\b\u00a2\u0006\u0002\b\u00102\u0012\u0010\u0015\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0016\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\u001e\u001a\u0015\u0010\u001f\u001a\u00070\b\u00a2\u0006\u0002\b 2\u0006\u0010!\u001a\u00020\bH\u0002\u001a\u001f\u0010\"\u001a\u00070\b\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\bH\u0000\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\"\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "SHOW_DEFAULT_MESSAGES", "", "SUFFIXES", "", "", "[Ljava/lang/String;", "assertOnMissedKeys", "getPolicy", "Lcom/intellij/GetPolicy;", "translationConsumer", "Ljava/util/function/BiConsumer;", "messageOrDefault", "Lorg/jetbrains/annotations/Nls;", "bundle", "Ljava/util/ResourceBundle;", "key", "defaultValue", "params", "", "(Ljava/util/ResourceBundle;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "messageOrDefaultForJdkBundle", "postProcessResolvedValue", "value", "resourceFound", "Lcom/intellij/IntelliJResourceBundle;", "postprocessValue", "(Ljava/util/ResourceBundle;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "quotePattern", "Lcom/intellij/openapi/util/NlsSafe;", "message", "useDefaultValue", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nBundleBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundleBase.kt\ncom/intellij/BundleBaseKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,313:1\n13#2:314\n*S KotlinDebug\n*F\n+ 1 BundleBase.kt\ncom/intellij/BundleBaseKt\n*L\n25#1:314\n*E\n"})
public final class BundleBaseKt {
    private static boolean assertOnMissedKeys;
    @NotNull
    private static final String[] SUFFIXES;
    @Nullable
    private static volatile BiConsumer<String, String> translationConsumer;
    private static final boolean SHOW_DEFAULT_MESSAGES;
    @NotNull
    private static final GetPolicy getPolicy;

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BundleBase.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        return logger;
    }

    private static final String quotePattern(String message) {
        boolean inQuotes = false;
        StringBuilder sb = new StringBuilder(message.length() + 5);
        int n2 = message.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean needToQuote;
            char c2 = message.charAt(i2);
            boolean bl2 = needToQuote = c2 == '{' || c2 == '}';
            if (needToQuote != inQuotes) {
                inQuotes = needToQuote;
                sb.append('\'');
            }
            if (c2 == '\'') {
                sb.append("''");
                continue;
            }
            sb.append(c2);
        }
        if (inQuotes) {
            sb.append('\'');
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @NotNull
    public static final String postprocessValue(@NotNull ResourceBundle bundle, @NotNull String value, @Nullable Object[] params) {
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        Intrinsics.checkNotNullParameter(value, "value");
        String string2 = BundleBase.replaceMnemonicAmpersand(value);
        Intrinsics.checkNotNull(string2);
        String value2 = string2;
        Object[] objectArray = params;
        if (objectArray == null || objectArray.length == 0 || !StringsKt.contains$default((CharSequence)value2, '{', false, 2, null)) {
            return value2;
        }
        Locale locale = bundle.getLocale();
        try {
            MessageFormat format = locale == null ? new MessageFormat(value2) : new MessageFormat(value2, locale);
            OrdinalFormat.apply((MessageFormat)format);
            String string3 = format.format(params);
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            return string3;
        }
        catch (IllegalArgumentException e2) {
            return "!invalid format: `" + value2 + "`!";
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static final String messageOrDefault(@NotNull ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, @Nullable Object[] params) {
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        Intrinsics.checkNotNullParameter(key, "key");
        if (!(bundle instanceof IntelliJResourceBundle) || ((IntelliJResourceBundle)bundle).getParent() != null) {
            return BundleBaseKt.messageOrDefaultForJdkBundle(bundle, key, defaultValue, params);
        }
        return ((IntelliJResourceBundle)bundle).getMessage(key, defaultValue, params);
    }

    private static final String messageOrDefaultForJdkBundle(ResourceBundle bundle, String key, String defaultValue, Object[] params) {
        String result2;
        boolean resourceFound;
        block3: {
            String string2;
            resourceFound = true;
            try {
                string2 = bundle.getString(key);
            }
            catch (MissingResourceException e2) {
                resourceFound = false;
                String string3 = defaultValue;
                if (string3 == null) {
                    string3 = BundleBaseKt.useDefaultValue(bundle, key);
                }
                string2 = string3;
            }
            String value = string2;
            Intrinsics.checkNotNull(value);
            result2 = BundleBaseKt.postprocessValue(bundle, value, params);
            BiConsumer<String, String> biConsumer = translationConsumer;
            if (biConsumer == null) break block3;
            biConsumer.accept(key, result2);
        }
        return !resourceFound ? result2 : (getPolicy == GetPolicy.APPEND_KEY ? BundleBase.INSTANCE.appendLocalizationSuffix(result2, SHOW_DEFAULT_MESSAGES ? " (" + key + '=' + BundleBase.getDefaultMessage(bundle, key) + ')' : " (" + key + ')') : (SHOW_DEFAULT_MESSAGES ? BundleBase.INSTANCE.appendLocalizationSuffix(result2, " (" + BundleBase.getDefaultMessage(bundle, key) + ')') : (BundleBase.SHOW_LOCALIZED_MESSAGES ? BundleBase.INSTANCE.appendLocalizationSuffix(result2, "\ud83d\udd05") : result2)));
    }

    @NotNull
    public static final String useDefaultValue(@NotNull ResourceBundle bundle, @NlsSafe @NotNull String key) {
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        Intrinsics.checkNotNullParameter(key, "key");
        if (assertOnMissedKeys) {
            BundleBaseKt.getLOG().error('\'' + key + "' is not found (baseBundleName=" + bundle.getBaseBundleName() + ", bundle=" + bundle + ')');
        }
        return '!' + key + '!';
    }

    @NotNull
    public static final String postProcessResolvedValue(@NlsSafe @NotNull String value, @NotNull String key, boolean resourceFound, @NotNull IntelliJResourceBundle bundle) {
        String string2;
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        BiConsumer<String, String> biConsumer = translationConsumer;
        if (biConsumer != null) {
            biConsumer.accept(key, value);
        }
        if (!resourceFound) {
            string2 = value;
        } else if (getPolicy == GetPolicy.ONLY_KEY) {
            StringBuilder stringBuilder = new StringBuilder().append("|b|");
            String string3 = bundle.getBaseBundleName();
            Intrinsics.checkNotNullExpressionValue(string3, "getBaseBundleName(...)");
            string2 = stringBuilder.append(StringsKt.replace$default(string3, '/', '.', false, 4, null)).append("|k|").append(key).append('|').append(value).toString();
        } else {
            string2 = getPolicy == GetPolicy.APPEND_KEY ? BundleBase.INSTANCE.appendLocalizationSuffix(value, SHOW_DEFAULT_MESSAGES ? " (" + key + '=' + BundleBase.getDefaultMessage(bundle, key) + ')' : " (" + key + ')') : (SHOW_DEFAULT_MESSAGES ? BundleBase.INSTANCE.appendLocalizationSuffix(value, " (" + BundleBase.getDefaultMessage(bundle, key) + ')') : (BundleBase.SHOW_LOCALIZED_MESSAGES ? BundleBase.INSTANCE.appendLocalizationSuffix(value, "\ud83d\udd05") : value));
        }
        return string2;
    }

    public static final /* synthetic */ void access$setAssertOnMissedKeys$p(boolean bl2) {
        assertOnMissedKeys = bl2;
    }

    public static final /* synthetic */ String access$quotePattern(String message) {
        return BundleBaseKt.quotePattern(message);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return BundleBaseKt.getLOG();
    }

    public static final /* synthetic */ String[] access$getSUFFIXES$p() {
        return SUFFIXES;
    }

    public static final /* synthetic */ void access$setTranslationConsumer$p(BiConsumer biConsumer) {
        translationConsumer = biConsumer;
    }

    static {
        String[] stringArray = new String[]{"</body></html>", "</html>"};
        SUFFIXES = stringArray;
        SHOW_DEFAULT_MESSAGES = Boolean.getBoolean("idea.l10n.english");
        String it = System.getProperty("idea.l10n.keys");
        boolean bl2 = false;
        String string2 = it;
        getPolicy = Intrinsics.areEqual(string2, "only") ? GetPolicy.ONLY_KEY : (Intrinsics.areEqual(string2, "true") ? GetPolicy.APPEND_KEY : GetPolicy.VALUE);
    }
}

