/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.BundleBaseKt;
import com.intellij.openapi.util.SystemInfoRt;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u000b\u001a\u00070\u0004\u00a2\u0006\u0002\b\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0007J)\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0014\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J6\u0010\u001a\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0014\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u001cJK\u0010\u001d\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00042\r\u0010\u001e\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u001b2\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u001fJ:\u0010 \u001a\u00070\u0004\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"2\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014H\u0007\u00a2\u0006\u0002\u0010#J\u001e\u0010$\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u001b2\r\u0010\u0012\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u001bH\u0007J\u001e\u0010%\u001a\u00020\u000f2\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010'H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/BundleBase;", "", "()V", "L10N_MARKER", "", "MNEMONIC", "", "MNEMONIC_STRING", "Lcom/intellij/openapi/util/NlsSafe;", "SHOW_LOCALIZED_MESSAGES", "", "appendLocalizationSuffix", "result", "suffixToAppend", "assertOnMissedKeys", "", "doAssert", "format", "value", "params", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getDefaultMessage", "bundle", "Ljava/util/ResourceBundle;", "key", "message", "Lorg/jetbrains/annotations/Nls;", "(Ljava/util/ResourceBundle;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "messageOrDefault", "defaultValue", "(Ljava/util/ResourceBundle;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "partialMessage", "unassignedParams", "", "(Ljava/util/ResourceBundle;Ljava/lang/String;I[Ljava/lang/Object;)Ljava/lang/String;", "replaceMnemonicAmpersand", "setTranslationConsumer", "consumer", "Ljava/util/function/BiConsumer;", "intellij.platform.util"})
public final class BundleBase {
    @NotNull
    public static final BundleBase INSTANCE = new BundleBase();
    public static final char MNEMONIC = '\u001b';
    @NotNull
    public static final String MNEMONIC_STRING = "\u001b";
    @JvmField
    @ApiStatus.Internal
    public static final boolean SHOW_LOCALIZED_MESSAGES = Boolean.getBoolean("idea.l10n");
    @NotNull
    public static final String L10N_MARKER = "\ud83d\udd05";

    private BundleBase() {
    }

    @ApiStatus.Internal
    public final void assertOnMissedKeys(boolean doAssert) {
        BundleBaseKt.access$setAssertOnMissedKeys$p(doAssert);
    }

    @JvmStatic
    @NotNull
    public static final String partialMessage(@NotNull ResourceBundle bundle, @NotNull String key, int unassignedParams, @NotNull Object[] params) {
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(params, "params");
        if (!(unassignedParams > 0)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Object[] objectArray = Arrays.copyOf(params, params.length + unassignedParams);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        Object[] newParams = objectArray;
        String prefix = "#$$$TemplateParameter$$$#";
        String suffix = "#$$$/TemplateParameter$$$#";
        for (int i2 = 0; i2 < unassignedParams; ++i2) {
            newParams[i2 + params.length] = prefix + i2 + suffix;
        }
        Object[] objectArray2 = newParams;
        String message = BundleBase.message(bundle, key, Arrays.copyOf(objectArray2, objectArray2.length));
        return StringsKt.replace$default(StringsKt.replace$default(BundleBaseKt.access$quotePattern(message), prefix, "{", false, 4, null), suffix, "}", false, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(params, "params");
        return BundleBaseKt.messageOrDefault(bundle, key, null, params);
    }

    @JvmStatic
    @NotNull
    public static final String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(params, "params");
        if (bundle == null) {
            String string2 = defaultValue;
            Intrinsics.checkNotNull(string2);
            return string2;
        }
        return BundleBaseKt.messageOrDefault(bundle, key, defaultValue, params);
    }

    @JvmStatic
    @NotNull
    public static final String getDefaultMessage(@NotNull ResourceBundle bundle, @NotNull String key) {
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        Intrinsics.checkNotNullParameter(key, "key");
        try {
            Field field = ResourceBundle.class.getDeclaredField("parent");
            field.setAccessible(true);
            Object parentBundle = field.get(bundle);
            if (parentBundle instanceof ResourceBundle) {
                String string2 = ((ResourceBundle)parentBundle).getString(key);
                Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
                return string2;
            }
        }
        catch (IllegalAccessException e2) {
            BundleBaseKt.access$getLOG().warn("Cannot fetch default message with 'idea.l10n.english' enabled, by key '" + key + '\'');
        }
        return "undefined";
    }

    @ApiStatus.Internal
    @NotNull
    public final String appendLocalizationSuffix(@NotNull String result2, @NotNull String suffixToAppend) {
        Intrinsics.checkNotNullParameter(result2, "result");
        Intrinsics.checkNotNullParameter(suffixToAppend, "suffixToAppend");
        for (String suffix : BundleBaseKt.access$getSUFFIXES$p()) {
            if (!StringsKt.endsWith$default(result2, suffix, false, 2, null)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = result2.substring(0, result2.length() - suffix.length());
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            return stringBuilder.append(string2).append(L10N_MARKER).append(suffix).toString();
        }
        return result2 + suffixToAppend;
    }

    @JvmStatic
    @Contract(pure=true)
    @NotNull
    public static final String format(@NotNull String value, Object ... params) {
        String string2;
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(params, "params");
        if (!(params.length == 0) && StringsKt.contains$default((CharSequence)value, '{', false, 2, null)) {
            String string3 = MessageFormat.format(value, Arrays.copyOf(params, params.length));
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        } else {
            string2 = value;
        }
        return string2;
    }

    @JvmStatic
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final String replaceMnemonicAmpersand(@Nullable String value) {
        if (value == null || !StringsKt.contains$default((CharSequence)value, '&', false, 2, null) || StringsKt.contains$default((CharSequence)value, '\u001b', false, 2, null)) {
            return value;
        }
        StringBuilder builder = new StringBuilder();
        boolean macMnemonic = StringsKt.contains$default((CharSequence)value, "&&", false, 2, null);
        boolean mnemonicAdded = false;
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c2 = value.charAt(i2);
            if (c2 == '\\') {
                if (i2 < value.length() - 1 && value.charAt(i2 + 1) == '&') {
                    builder.append('&');
                    ++i2;
                    continue;
                }
                builder.append(c2);
                continue;
            }
            if (c2 == '&') {
                if (i2 < value.length() - 1 && value.charAt(i2 + 1) == '&') {
                    if (SystemInfoRt.isMac && !mnemonicAdded) {
                        mnemonicAdded = true;
                        builder.append('\u001b');
                    }
                    ++i2;
                    continue;
                }
                if (SystemInfoRt.isMac && macMnemonic || mnemonicAdded) continue;
                mnemonicAdded = true;
                builder.append('\u001b');
                continue;
            }
            builder.append(c2);
        }
        return builder.toString();
    }

    @JvmStatic
    @TestOnly
    public static final void setTranslationConsumer(@Nullable BiConsumer<String, String> consumer2) {
        BundleBaseKt.access$setTranslationConsumer$p(consumer2);
    }
}

