/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.timeTracking;

import com.intellij.icons.AllIcons;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskListener;
import com.intellij.tasks.TaskListenerAdapter;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.actions.GotoTaskAction;
import com.intellij.tasks.actions.SwitchTaskAction;
import com.intellij.tasks.timeTracking.SendTimeTrackingInformationDialog;
import com.intellij.tasks.timeTracking.TasksTimeTrackingBundle;
import com.intellij.tasks.timeTracking.TimeTrackingManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.table.TableView;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import icons.TasksCoreIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TasksToolWindowPanel
extends SimpleToolWindowPanel
implements Disposable {
    private final ListTableModel<LocalTask> myTableModel;
    private final TimeTrackingManager myTimeTrackingManager;
    private final Project myProject;
    private Timer myTimer;
    private final TableView<LocalTask> myTable;
    private final TaskManager myTaskManager;

    public TasksToolWindowPanel(Project project, boolean vertical) {
        super(vertical);
        this.myProject = project;
        this.myTimeTrackingManager = TimeTrackingManager.getInstance(project);
        this.myTaskManager = TaskManager.getManager((Project)project);
        this.myTable = new TableView(this.createListModel());
        this.myTableModel = this.myTable.getListTableModel();
        this.updateTable();
        this.setContent(ScrollPaneFactory.createScrollPane(this.myTable, (boolean)true));
        this.setToolbar(this.createToolbar());
        this.myTaskManager.addTaskListener((TaskListener)new TaskListenerAdapter(){

            public void taskDeactivated(@NotNull LocalTask task) {
                if (task == null) {
                    1.$$$reportNull$$$0(0);
                }
                TasksToolWindowPanel.this.myTable.repaint();
            }

            public void taskActivated(@NotNull LocalTask task) {
                if (task == null) {
                    1.$$$reportNull$$$0(1);
                }
                TasksToolWindowPanel.this.myTable.repaint();
            }

            public void taskAdded(@NotNull LocalTask task) {
                if (task == null) {
                    1.$$$reportNull$$$0(2);
                }
                TasksToolWindowPanel.this.updateTable();
            }

            public void taskRemoved(@NotNull LocalTask task) {
                if (task == null) {
                    1.$$$reportNull$$$0(3);
                }
                TasksToolWindowPanel.this.updateTable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "task";
                objectArray2[1] = "com/intellij/tasks/timeTracking/TasksToolWindowPanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "taskDeactivated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "taskActivated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "taskAdded";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "taskRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        this.myTimer = TimerUtil.createNamedTimer((String)"TasksToolRepaint", (int)60000, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasksToolWindowPanel.this.myTable.repaint();
            }
        });
        this.myTimer.start();
    }

    private static SimpleTextAttributes getAttributes(boolean isClosed, boolean isActive, boolean isSelected) {
        return new SimpleTextAttributes(isActive ? 1 : 0, isSelected ? UIUtil.getTableSelectionForeground() : (isClosed && !isActive ? UIUtil.getLabelDisabledForeground() : UIUtil.getTableForeground()));
    }

    private static String formatDuration(long milliseconds) {
        int second = 1000;
        int minute = 60000;
        int hour = 3600000;
        int day = 86400000;
        long days = milliseconds / 86400000L;
        Object daysString = days != 0L ? days + "d " : "";
        return (String)daysString + String.format("%d:%02d", milliseconds % 86400000L / 3600000L, milliseconds % 3600000L / 60000L);
    }

    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        AnAction action = ActionManager.getInstance().getAction("tasks.goto");
        assert (action instanceof GotoTaskAction);
        GotoTaskAction gotoTaskAction = (GotoTaskAction)action;
        group.add((AnAction)gotoTaskAction);
        group.add((AnAction)new DumbAwareAction(TaskBundle.messagePointer((String)"action.DumbAware.TasksToolWindowPanel.text.remove.task", (Object[])new Object[0]), TaskBundle.messagePointer((String)"action.DumbAware.TasksToolWindowPanel.description.remove.selected.task", (Object[])new Object[0]), IconUtil.getRemoveIcon()){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                for (LocalTask localTask : TasksToolWindowPanel.this.myTable.getSelectedObjects()) {
                    SwitchTaskAction.removeTask((Project)TasksToolWindowPanel.this.myProject, (LocalTask)localTask, (TaskManager)TasksToolWindowPanel.this.myTaskManager);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/tasks/timeTracking/TasksToolWindowPanel$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/tasks/timeTracking/TasksToolWindowPanel$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        });
        group.add((AnAction)new ToggleAction(TasksTimeTrackingBundle.message("action.show.closed.tasks.text", new Object[0]), TasksTimeTrackingBundle.message("action.show.closed.tasks.description", new Object[0]), AllIcons.Actions.Checked){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    4.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                return TasksToolWindowPanel.this.myTimeTrackingManager.getState().showClosedTasks;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    4.$$$reportNull$$$0(2);
                }
                TasksToolWindowPanel.this.myTimeTrackingManager.getState().showClosedTasks = state;
                TasksToolWindowPanel.this.updateTable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/tasks/timeTracking/TasksToolWindowPanel$4";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/tasks/timeTracking/TasksToolWindowPanel$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        });
        group.add((AnAction)new ModeToggleAction());
        group.add((AnAction)new StartStopAction());
        group.add(new AnAction(TasksTimeTrackingBundle.message("action.post.to.bugtracker.text", new Object[0]), TasksTimeTrackingBundle.message("action.post.work.item.to.bugtracker.description", new Object[0]), AllIcons.ToolbarDecorator.Export){

            public void actionPerformed(@NotNull AnActionEvent e) {
                LocalTask localTask;
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((localTask = (LocalTask)TasksToolWindowPanel.this.myTable.getSelectedObject()) == null) {
                    return;
                }
                new SendTimeTrackingInformationDialog(TasksToolWindowPanel.this.myProject, localTask).show();
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    5.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                LocalTask localTask;
                if (e == null) {
                    5.$$$reportNull$$$0(2);
                }
                if ((localTask = (LocalTask)TasksToolWindowPanel.this.myTable.getSelectedObject()) == null) {
                    e.getPresentation().setEnabled(false);
                } else {
                    TaskRepository repository = localTask.getRepository();
                    e.getPresentation().setEnabled(repository != null && repository.isSupported(4));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/tasks/timeTracking/TasksToolWindowPanel$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/tasks/timeTracking/TasksToolWindowPanel$5";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        group.add((AnAction)new ToggleAction(TasksTimeTrackingBundle.message("action.show.time.spent.from.last.post.text", new Object[0]), TasksTimeTrackingBundle.message("action.show.time.spent.from.last.post.work.item.description", new Object[0]), TasksCoreIcons.Clock){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    6.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                return TasksToolWindowPanel.this.myTimeTrackingManager.getState().showSpentTimeFromLastPost;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    6.$$$reportNull$$$0(2);
                }
                TasksToolWindowPanel.this.myTimeTrackingManager.getState().showSpentTimeFromLastPost = state;
                TasksToolWindowPanel.this.myTable.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/tasks/timeTracking/TasksToolWindowPanel$6";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/tasks/timeTracking/TasksToolWindowPanel$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        });
        ActionToolbar actionToolBar = ActionManager.getInstance().createActionToolbar("TasksToolWindow", (ActionGroup)group, this.myVertical);
        actionToolBar.setTargetComponent(this.myTable);
        return actionToolBar.getComponent();
    }

    private void updateTable() {
        UIUtil.invokeLaterIfNeeded(() -> this.myTableModel.setItems(ContainerUtil.filter((Collection)this.myTaskManager.getLocalTasks(), task -> task.isActive() || task.getTotalTimeSpent() != 0L && (this.myTimeTrackingManager.getState().showClosedTasks || !this.myTaskManager.isLocallyClosed(task)))));
    }

    private ListTableModel<LocalTask> createListModel() {
        ColumnInfo<LocalTask, String> task = new ColumnInfo<LocalTask, String>(TasksTimeTrackingBundle.message("column.name.task", new Object[0])){

            @Nullable
            public String valueOf(LocalTask task) {
                return task.getPresentableName();
            }

            @NotNull
            public TableCellRenderer getRenderer(final LocalTask task) {
                return new TableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        JPanel panel = new JPanel(new BorderLayout());
                        panel.setBackground(UIUtil.getTableBackground((boolean)isSelected));
                        SimpleColoredComponent component = new SimpleColoredComponent();
                        boolean isClosed = task.isClosed() || TasksToolWindowPanel.this.myTaskManager.isLocallyClosed(task);
                        boolean isActive = task.isActive();
                        boolean isRunning = TasksToolWindowPanel.this.myTimeTrackingManager.getState().autoMode ? isActive : isActive && task.isRunning();
                        component.append((String)value, TasksToolWindowPanel.getAttributes(isClosed, isActive, isSelected));
                        component.setIcon(isRunning ? LayeredIcon.create((Icon)task.getIcon(), (Icon)AllIcons.Nodes.RunnableMark) : (isClosed && !isActive ? IconLoader.getTransparentIcon((Icon)task.getIcon()) : task.getIcon()));
                        component.setOpaque(false);
                        panel.add((Component)component, "Center");
                        panel.setOpaque(true);
                        return panel;
                    }
                };
            }

            @NotNull
            public Comparator<LocalTask> getComparator() {
                Comparator comparator = (o1, o2) -> {
                    int i = Comparing.compare((Comparable)o2.getUpdated(), (Comparable)o1.getUpdated());
                    return i == 0 ? Comparing.compare((Comparable)o2.getCreated(), (Comparable)o1.getCreated()) : i;
                };
                if (comparator == null) {
                    7.$$$reportNull$$$0(0);
                }
                return comparator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/timeTracking/TasksToolWindowPanel$7", "getComparator"));
            }
        };
        ColumnInfo<LocalTask, String> spentTime = new ColumnInfo<LocalTask, String>(TasksTimeTrackingBundle.message("column.name.time.spent", new Object[0])){

            @NotNull
            public String valueOf(LocalTask task) {
                long timeSpent;
                long l = timeSpent = TasksToolWindowPanel.this.myTimeTrackingManager.getState().showSpentTimeFromLastPost ? task.getTimeSpentFromLastPost() : task.getTotalTimeSpent();
                if (task.isActive()) {
                    String string = TasksToolWindowPanel.formatDuration(timeSpent);
                    if (string == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String string = NlsMessages.formatDurationApproximate((long)timeSpent);
                if (string == null) {
                    8.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public TableCellRenderer getRenderer(final LocalTask task) {
                return new TableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        JPanel panel = new JPanel(new BorderLayout());
                        panel.setBackground(UIUtil.getTableBackground((boolean)isSelected));
                        SimpleColoredComponent component = new SimpleColoredComponent();
                        boolean isClosed = task.isClosed() || TasksToolWindowPanel.this.myTaskManager.isLocallyClosed(task);
                        boolean isActive = task.isActive();
                        component.append((String)value, TasksToolWindowPanel.getAttributes(isClosed, isActive, isSelected));
                        component.setOpaque(false);
                        panel.add((Component)component, "Center");
                        panel.setOpaque(true);
                        return panel;
                    }
                };
            }

            @NotNull
            public Comparator<LocalTask> getComparator() {
                Comparator comparator = (o1, o2) -> {
                    long timeSpent1 = TasksToolWindowPanel.this.myTimeTrackingManager.getState().showSpentTimeFromLastPost ? o1.getTimeSpentFromLastPost() : o1.getTotalTimeSpent();
                    long timeSpent2 = TasksToolWindowPanel.this.myTimeTrackingManager.getState().showSpentTimeFromLastPost ? o2.getTimeSpentFromLastPost() : o2.getTotalTimeSpent();
                    return Long.compare(timeSpent1, timeSpent2);
                };
                if (comparator == null) {
                    8.$$$reportNull$$$0(2);
                }
                return comparator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/tasks/timeTracking/TasksToolWindowPanel$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "valueOf";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComparator";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        return new ListTableModel(new ColumnInfo[]{task, spentTime});
    }

    public void dispose() {
        this.myTimer.stop();
        this.myTimer = null;
    }

    private class ModeToggleAction
    extends ToggleAction {
        ModeToggleAction() {
            super(TasksTimeTrackingBundle.message("action.auto.mode.text", new Object[0]), TasksTimeTrackingBundle.message("action.automatic.starting.stopping.timer.description", new Object[0]), AllIcons.Actions.Resume);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ModeToggleAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ModeToggleAction.$$$reportNull$$$0(1);
            }
            return TasksToolWindowPanel.this.myTimeTrackingManager.getState().autoMode;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ModeToggleAction.$$$reportNull$$$0(2);
            }
            TasksToolWindowPanel.this.myTimeTrackingManager.setAutoMode(state);
            TasksToolWindowPanel.this.updateTable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/timeTracking/TasksToolWindowPanel$ModeToggleAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/timeTracking/TasksToolWindowPanel$ModeToggleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class StartStopAction
    extends AnAction {
        private StartStopAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                StartStopAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                StartStopAction.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (TimeTrackingManager.getInstance((Project)project).getState().autoMode) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setIcon(TasksCoreIcons.StartTimer);
                e.getPresentation().setText(TasksTimeTrackingBundle.message("action.start.timer.text", new Object[0]));
                e.getPresentation().setDescription(TasksTimeTrackingBundle.message("action.start.timer.for.active.task.description", new Object[0]));
            } else {
                e.getPresentation().setEnabled(true);
                if (TaskManager.getManager((Project)project).getActiveTask().isRunning()) {
                    e.getPresentation().setIcon(TasksCoreIcons.StopTimer);
                    e.getPresentation().setText(TasksTimeTrackingBundle.message("action.stop.timer.text", new Object[0]));
                    e.getPresentation().setDescription(TasksTimeTrackingBundle.message("action.stop.timer.for.active.task.description", new Object[0]));
                } else {
                    e.getPresentation().setIcon(TasksCoreIcons.StartTimer);
                    e.getPresentation().setText(TasksTimeTrackingBundle.message("action.start.timer.text", new Object[0]));
                    e.getPresentation().setDescription(TasksTimeTrackingBundle.message("action.start.timer.for.active.task.description", new Object[0]));
                }
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            LocalTask activeTask;
            if (e == null) {
                StartStopAction.$$$reportNull$$$0(2);
            }
            if ((activeTask = TaskManager.getManager((Project)Objects.requireNonNull(e.getProject())).getActiveTask()).isRunning()) {
                activeTask.setRunning(false);
            } else {
                activeTask.setRunning(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/timeTracking/TasksToolWindowPanel$StartStopAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/timeTracking/TasksToolWindowPanel$StartStopAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

