/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.spi.connector.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportListener;
import org.eclipse.aether.spi.connector.transport.TransportTask;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.transfer.TransferCancelledException;

public abstract class AbstractTransporter
implements Transporter {
    private final AtomicBoolean closed = new AtomicBoolean();

    protected AbstractTransporter() {
    }

    @Override
    public void peek(PeekTask task2) throws Exception {
        this.failIfClosed(task2);
        this.implPeek(task2);
    }

    protected abstract void implPeek(PeekTask var1) throws Exception;

    @Override
    public void get(GetTask task2) throws Exception {
        this.failIfClosed(task2);
        this.implGet(task2);
    }

    protected abstract void implGet(GetTask var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void utilGet(GetTask task2, InputStream is, boolean close, long length, boolean resume) throws IOException, TransferCancelledException {
        OutputStream os = null;
        try {
            os = task2.newOutputStream(resume);
            task2.getListener().transportStarted(resume ? task2.getResumeOffset() : 0L, length);
            AbstractTransporter.copy(os, is, task2.getListener());
            os.close();
            os = null;
            if (close) {
                is.close();
                is = null;
            }
        }
        finally {
            block29: {
                block28: {
                    if (os == null) break block28;
                    os.close();
                }
                try {
                    if (close && is != null) {
                        is.close();
                    }
                    break block29;
                }
                catch (IOException iOException) {}
                break block29;
                catch (IOException iOException) {
                    try {
                        if (close && is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    catch (Throwable throwable) {
                        try {
                            if (close && is != null) {
                                is.close();
                            }
                        }
                        catch (IOException iOException3) {}
                        throw throwable;
                    }
                }
            }
        }
    }

    @Override
    public void put(PutTask task2) throws Exception {
        this.failIfClosed(task2);
        this.implPut(task2);
    }

    protected abstract void implPut(PutTask var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void utilPut(PutTask task2, OutputStream os, boolean close) throws IOException, TransferCancelledException {
        InputStream is = null;
        try {
            task2.getListener().transportStarted(0L, task2.getDataLength());
            is = task2.newInputStream();
            AbstractTransporter.copy(os, is, task2.getListener());
            if (close) {
                os.close();
            } else {
                os.flush();
            }
            os = null;
            is.close();
            is = null;
        }
        finally {
            block30: {
                block29: {
                    if (!close || os == null) break block29;
                    os.close();
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                    break block30;
                }
                catch (IOException iOException) {}
                break block30;
                catch (IOException iOException) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException iOException3) {}
                        throw throwable;
                    }
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.implClose();
        }
    }

    protected abstract void implClose();

    private void failIfClosed(TransportTask task2) {
        if (this.closed.get()) {
            throw new IllegalStateException("transporter closed, cannot execute task " + task2);
        }
    }

    private static void copy(OutputStream os, InputStream is, TransportListener listener) throws IOException, TransferCancelledException {
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        byte[] array = buffer.array();
        int read2 = is.read(array);
        while (read2 >= 0) {
            os.write(array, 0, read2);
            ((Buffer)buffer).rewind();
            ((Buffer)buffer).limit(read2);
            listener.transportProgressed(buffer);
            read2 = is.read(array);
        }
    }
}

