/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.repository;

import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;

public final class AuthenticationContext
implements Closeable {
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String NTLM_DOMAIN = "ntlm.domain";
    public static final String NTLM_WORKSTATION = "ntlm.workstation";
    public static final String PRIVATE_KEY_PATH = "privateKey.path";
    public static final String PRIVATE_KEY_PASSPHRASE = "privateKey.passphrase";
    public static final String HOST_KEY_ACCEPTANCE = "hostKey.acceptance";
    public static final String HOST_KEY_REMOTE = "hostKey.remote";
    public static final String HOST_KEY_LOCAL = "hostKey.local";
    public static final String SSL_CONTEXT = "ssl.context";
    public static final String SSL_HOSTNAME_VERIFIER = "ssl.hostnameVerifier";
    private final RepositorySystemSession session;
    private final RemoteRepository repository;
    private final Proxy proxy;
    private final Authentication auth;
    private final Map<String, Object> authData;
    private boolean fillingAuthData;

    public static AuthenticationContext forRepository(RepositorySystemSession session, RemoteRepository repository) {
        return AuthenticationContext.newInstance(session, repository, null, repository.getAuthentication());
    }

    public static AuthenticationContext forProxy(RepositorySystemSession session, RemoteRepository repository) {
        Proxy proxy;
        return AuthenticationContext.newInstance(session, repository, proxy, (proxy = repository.getProxy()) != null ? proxy.getAuthentication() : null);
    }

    private static AuthenticationContext newInstance(RepositorySystemSession session, RemoteRepository repository, Proxy proxy, Authentication auth) {
        if (auth == null) {
            return null;
        }
        return new AuthenticationContext(session, repository, proxy, auth);
    }

    private AuthenticationContext(RepositorySystemSession session, RemoteRepository repository, Proxy proxy, Authentication auth) {
        this.session = Objects.requireNonNull(session, "repository system session cannot be null");
        this.repository = repository;
        this.proxy = proxy;
        this.auth = auth;
        this.authData = new HashMap<String, Object>();
    }

    public RepositorySystemSession getSession() {
        return this.session;
    }

    public RemoteRepository getRepository() {
        return this.repository;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String get(String key) {
        return this.get(key, null, String.class);
    }

    public <T> T get(String key, Class<T> type) {
        return this.get(key, null, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(String key, Map<String, String> data, Class<T> type) {
        Object value;
        Objects.requireNonNull(key, "authentication key cannot be null");
        if (key.length() == 0) {
            throw new IllegalArgumentException("authentication key cannot be empty");
        }
        Map<String, Object> map2 = this.authData;
        synchronized (map2) {
            value = this.authData.get(key);
            if (value == null && !this.authData.containsKey(key) && !this.fillingAuthData) {
                if (this.auth != null) {
                    try {
                        this.fillingAuthData = true;
                        this.auth.fill(this, key, data);
                    }
                    finally {
                        this.fillingAuthData = false;
                    }
                    value = this.authData.get(key);
                }
                if (value == null) {
                    this.authData.put(key, value);
                }
            }
        }
        return this.convert(value, type);
    }

    private <T> T convert(Object value, Class<T> type) {
        if (!type.isInstance(value)) {
            if (String.class.equals(type)) {
                if (value instanceof File) {
                    value = ((File)value).getPath();
                } else if (value instanceof char[]) {
                    value = new String((char[])value);
                }
            } else if (File.class.equals(type)) {
                if (value instanceof String) {
                    value = new File((String)value);
                }
            } else if (char[].class.equals(type) && value instanceof String) {
                value = ((String)value).toCharArray();
            }
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Object value) {
        Objects.requireNonNull(key, "authentication key cannot be null");
        if (key.length() == 0) {
            throw new IllegalArgumentException("authentication key cannot be empty");
        }
        Map<String, Object> map2 = this.authData;
        synchronized (map2) {
            Object oldValue = this.authData.put(key, value);
            if (oldValue instanceof char[]) {
                Arrays.fill((char[])oldValue, '\u0000');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<String, Object> map2 = this.authData;
        synchronized (map2) {
            for (Object value : this.authData.values()) {
                if (!(value instanceof char[])) continue;
                Arrays.fill((char[])value, '\u0000');
            }
            this.authData.clear();
        }
    }

    public static void close(AuthenticationContext context) {
        if (context != null) {
            context.close();
        }
    }
}

