/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dependencyAnalysis.python;

import com.intellij.dependencyAnalysis.core.model.DependencyDeclaration;
import com.intellij.dependencyAnalysis.python.PyBuildFileParserKt;
import com.intellij.dependencyAnalysis.python.PyBuildParser;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlTable;
import org.toml.lang.psi.TomlValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004*\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/dependencyAnalysis/python/PyProjectTomlFileParser;", "Lcom/intellij/dependencyAnalysis/python/PyBuildParser;", "()V", "parseDependencies", "", "Lcom/intellij/dependencyAnalysis/core/model/DependencyDeclaration;", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/PsiFile;", "parseLockFile", "", "", "getProperties", "Lorg/toml/lang/psi/TomlKeyValue;", "properties", "intellij.dependencyAnalysis.python"})
@SourceDebugExtension(value={"SMAP\nPyBuildFileParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyBuildFileParser.kt\ncom/intellij/dependencyAnalysis/python/PyProjectTomlFileParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,151:1\n1#2:152\n1#2:175\n1#2:197\n1#2:216\n1194#3,2:153\n1222#3,4:155\n1360#3:162\n1446#3,2:163\n1448#3,3:178\n1194#3,2:181\n1222#3,4:183\n1603#3,9:187\n1855#3:196\n1856#3:198\n1612#3:199\n1194#3,2:200\n1222#3,4:202\n1603#3,9:206\n1855#3:215\n1856#3:217\n1612#3:218\n3792#4:159\n4307#4,2:160\n11383#4,9:165\n13309#4:174\n13310#4:176\n11392#4:177\n*S KotlinDebug\n*F\n+ 1 PyBuildFileParser.kt\ncom/intellij/dependencyAnalysis/python/PyProjectTomlFileParser\n*L\n121#1:175\n129#1:197\n135#1:216\n114#1:153,2\n114#1:155,4\n120#1:162\n120#1:163,2\n120#1:178,3\n127#1:181,2\n127#1:183,4\n129#1:187,9\n129#1:196\n129#1:198\n129#1:199\n134#1:200,2\n134#1:202,4\n135#1:206,9\n135#1:215\n135#1:217\n135#1:218\n118#1:159\n118#1:160,2\n121#1:165,9\n121#1:174\n121#1:176\n121#1:177\n*E\n"})
public final class PyProjectTomlFileParser
implements PyBuildParser {
    /*
     * WARNING - void declaration
     */
    private final Map<String, DependencyDeclaration> parseLockFile(Module module) {
        void $this$associateByTo$iv$iv;
        Object it = PoetryKt.getPoetryLock((Module)module);
        boolean bl = false;
        PsiFile psiFile2 = it != null ? PsiManager.getInstance((Project)module.getProject()).findFile(it) : null;
        if (psiFile2 == null) {
            return MapsKt.emptyMap();
        }
        PsiFile lockFile = psiFile2;
        Iterable $this$associateBy$iv = PyBuildFileParserKt.extractKeys((PsiElement)lockFile, (Function1)new Function1<List<? extends TomlKeyValue>, DependencyDeclaration>(lockFile){
            final /* synthetic */ PsiFile $lockFile;
            {
                this.$lockFile = $lockFile;
                super(1);
            }

            @Nullable
            public final DependencyDeclaration invoke(@NotNull List<? extends TomlKeyValue> pkg) {
                DependencyDeclaration dependencyDeclaration;
                Intrinsics.checkNotNullParameter(pkg, (String)"pkg");
                String name = null;
                String version = null;
                TomlValue psiElement = null;
                Iterable $this$forEach$iv = pkg;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TomlValue value;
                    TomlKeyValue it = (TomlKeyValue)element$iv;
                    boolean bl = false;
                    String string = it.getKey().getText();
                    if (Intrinsics.areEqual((Object)string, (Object)"name")) {
                        value = it.getValue();
                        if (value == null) continue;
                        String string2 = value.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                        name = StringsKt.replace$default((String)string2, (String)"\"", (String)"", (boolean)false, (int)4, null);
                        psiElement = value;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)string, (Object)"version") || (value = it.getValue()) == null) continue;
                    String string3 = value.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                    version = StringsKt.replace$default((String)string3, (String)"\"", (String)"", (boolean)false, (int)4, null);
                }
                if (name != null && version != null) {
                    PsiElement psiElement2 = (PsiElement)psiElement;
                    dependencyDeclaration = new DependencyDeclaration(name, version, new DependencyDeclaration.PsiDeclaration((PsiElement)psiElement, (TextRange)(psiElement2 != null ? psiElement2.getTextRange() : null)), this.$lockFile);
                } else {
                    dependencyDeclaration = null;
                }
                return dependencyDeclaration;
            }
        });
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        it = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it2;
            DependencyDeclaration dependencyDeclaration = (DependencyDeclaration)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl2 = false;
            map2.put(it2.getArtifactId() + it2.getVersion(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TomlKeyValue> getProperties(PsiFile $this$getProperties, List<String> properties) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        PsiElement[] psiElementArray = $this$getProperties.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object[] $this$filter$iv = psiElementArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement element = (PsiElement)element$iv$iv;
            boolean bl = false;
            TomlTable tomlTable = element instanceof TomlTable ? (TomlTable)element : null;
            if (!CollectionsKt.contains((Iterable)properties, tomlTable != null && (tomlTable = tomlTable.getHeader()) != null && (tomlTable = tomlTable.getKey()) != null ? tomlTable.getText() : null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl = false;
            PsiElement[] psiElementArray2 = it.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"getChildren(...)");
            Object[] $this$mapNotNull$iv = psiElementArray2;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                TomlKeyValue it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv2 = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl2 = false;
                PsiElement line = (PsiElement)element$iv$iv2;
                boolean bl3 = false;
                if ((line instanceof TomlKeyValue ? (TomlKeyValue)line : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DependencyDeclaration> parseDependencies(@NotNull Module module, @NotNull PsiFile file) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        boolean bl;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterator it;
        Map map2;
        Object object;
        void $this$associateByTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Sdk sdk = PySdkExtKt.getPythonSdk((Module)module);
        if (sdk == null) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            sdk = PyBuildFileParserKt.getPythonSdk(project);
            if (sdk == null) {
                return CollectionsKt.emptyList();
            }
        }
        Sdk sdk2 = sdk;
        Map<String, DependencyDeclaration> lockFileDependencies = this.parseLockFile(module);
        List list = PyPackageManagers.getInstance().forSdk(sdk2).refreshAndGetPackages(false);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"refreshAndGetPackages(...)");
        Iterable $this$associateBy$iv2 = list;
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv2;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            object = (PyPackage)element$iv$iv;
            map2 = destination$iv$iv;
            boolean bl2 = false;
            map2.put(it.getName(), element$iv$iv);
        }
        Map allPackages = destination$iv$iv;
        Object $i$f$associateBy22 = new String[]{"tool.poetry.dependencies", "tool.poetry.dev-dependencies"};
        $i$f$associateBy22 = this.getProperties(file, CollectionsKt.listOf((Object[])$i$f$associateBy22));
        boolean $i$f$mapNotNull = false;
        $this$associateByTo$iv$iv2 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            DependencyDeclaration dependencyDeclaration;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            bl = false;
            TomlKeyValue keyValue = (TomlKeyValue)element$iv$iv;
            boolean bl3 = false;
            String name = keyValue.getKey().getText();
            if ((PyPackage)allPackages.get(name) == null) {
                dependencyDeclaration = null;
            } else {
                PyPackage pyPackage;
                TomlValue tomlValue = keyValue.getValue();
                Intrinsics.checkNotNull((Object)tomlValue, (String)"null cannot be cast to non-null type com.intellij.psi.PsiElement");
                PsiElement psiElement = ((PsiElement)tomlValue).getParent();
                dependencyDeclaration = new DependencyDeclaration(name, pyPackage.getVersion(), new DependencyDeclaration.PsiDeclaration(psiElement, psiElement.getTextRange()), file);
            }
            if (dependencyDeclaration == null) continue;
            DependencyDeclaration it$iv$iv = dependencyDeclaration;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it2;
            DependencyDeclaration element$iv$iv$iv = (DependencyDeclaration)element$iv$iv;
            map2 = destination$iv$iv2;
            boolean bl5 = false;
            map2.put(it2.getArtifactId() + it2.getVersion(), element$iv$iv);
        }
        Map declarationFromToml = destination$iv$iv2;
        $this$mapNotNull$iv = allPackages.values();
        $i$f$mapNotNull = false;
        Iterable capacity$iv22 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            String key;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            bl = false;
            PyPackage it3 = (PyPackage)element$iv$iv;
            boolean bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)(it3.getName() + it3.getVersion()).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            DependencyDeclaration dependencyDeclaration = (DependencyDeclaration)declarationFromToml.get(key);
            if (dependencyDeclaration == null) {
                dependencyDeclaration = lockFileDependencies.get(key);
            }
            if (dependencyDeclaration == null) continue;
            DependencyDeclaration it$iv$iv = dependencyDeclaration;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

