/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dependencyAnalysis.jvm;

import com.intellij.dependencyAnalysis.core.model.Dependency;
import com.intellij.dependencyAnalysis.core.model.DependencyManager;
import com.intellij.dependencyAnalysis.core.model.ProjectAnalyzer;
import com.intellij.dependencyAnalysis.jvm.CollectInformationFromJar;
import com.intellij.dependencyAnalysis.jvm.CollectInformationFromPackageSearch;
import com.intellij.dependencyAnalysis.jvm.DependencyTreeFactory;
import com.intellij.dependencyAnalysis.jvm.JvmProjectAnalyzer;
import com.intellij.dependencyAnalysis.jvm.LibraryUtilsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.packagesearch.api.PackageSearchApiClient;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0080@\u00a2\u0006\u0002\u0010\u000e\u001a\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u000bH\u0002\u001a\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\b*\u00020\u000bH\u0002\u001a\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u000b*\u00020\u000bH\u0002\u001a\u0012\u0010\u0017\u001a\u00020\u0013*\u00020\u000bH\u0080@\u00a2\u0006\u0002\u0010\u0018\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"GRADLE_FILE_NAME", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MAVEN_FILE_NAME", "MODULE_VERSION_EMPTY", "extractModuleDependencies", "", "Lcom/intellij/dependencyAnalysis/core/model/Dependency;", "module", "Lcom/intellij/openapi/module/Module;", "packageSearch", "Lorg/jetbrains/idea/packagesearch/api/PackageSearchApiClient;", "(Lcom/intellij/openapi/module/Module;Lorg/jetbrains/idea/packagesearch/api/PackageSearchApiClient;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "typeConfigFile", "Lcom/intellij/dependencyAnalysis/core/model/DependencyManager;", "fileName", "containsLibraryInModuleMain", "", "getLibraryFromMainModule", "Lcom/intellij/openapi/roots/libraries/Library;", "getModuleMain", "isModuleTest", "(Lcom/intellij/openapi/module/Module;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.dependencyAnalysis.jvm"})
@SourceDebugExtension(value={"SMAP\nJvmProjectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmProjectAnalyzer.kt\ncom/intellij/dependencyAnalysis/jvm/JvmProjectAnalyzerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,408:1\n1#2:409\n*E\n"})
public final class JvmProjectAnalyzerKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String GRADLE_FILE_NAME = "build.gradle";
    @NotNull
    public static final String MAVEN_FILE_NAME = "pom.xml";
    @NotNull
    public static final String MODULE_VERSION_EMPTY = "unspecified";

    private static final Module getModuleMain(Module $this$getModuleMain) {
        Module module;
        block1: {
            Project project = $this$getModuleMain.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Module[] moduleArray = ProjectUtil.getModules((Project)project);
            int n = moduleArray.length;
            for (int i = 0; i < n; ++i) {
                Module module2;
                Module it = module2 = moduleArray[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)($this$getModuleMain.getName() + ".main"))) continue;
                module = module2;
                break block1;
            }
            module = null;
        }
        return module;
    }

    private static final boolean containsLibraryInModuleMain(Module $this$containsLibraryInModuleMain) {
        return JvmProjectAnalyzerKt.getModuleMain($this$containsLibraryInModuleMain) != null;
    }

    private static final List<Library> getLibraryFromMainModule(Module $this$getLibraryFromMainModule) {
        List list;
        List list2 = LibraryUtilsKt.getLibrary($this$getLibraryFromMainModule);
        if (list2.isEmpty()) {
            boolean bl = false;
            Module mainModule = JvmProjectAnalyzerKt.getModuleMain($this$getLibraryFromMainModule);
            list = mainModule;
            if (list == null || (list = LibraryUtilsKt.getLibrary((Module)list)) == null) {
                list = CollectionsKt.emptyList();
            }
        } else {
            list = list2;
        }
        return list;
    }

    @Nullable
    public static final Object isModuleTest(@NotNull Module $this$isModuleTest, @NotNull Continuation<? super Boolean> $completion) {
        String string = $this$isModuleTest.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"test", (boolean)false, (int)2, null)) {
            return Boxing.boxBoolean((boolean)true);
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)$this$isModuleTest.getProject()).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex projectRootManager = projectFileIndex;
        VirtualFile virtualFile = ProjectUtil.guessModuleDir((Module)$this$isModuleTest);
        if (virtualFile != null) {
            return CoroutinesKt.readActionUndispatched((Function0)((Function0)new Function0<Boolean>(projectRootManager, virtualFile){
                final /* synthetic */ ProjectFileIndex $projectRootManager;
                final /* synthetic */ VirtualFile $virtualFile;
                {
                    this.$projectRootManager = $projectRootManager;
                    this.$virtualFile = $virtualFile;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return this.$projectRootManager.isInTestSourceContent(this.$virtualFile);
                }
            }), $completion);
        }
        return Boxing.boxBoolean((boolean)false);
    }

    @Nullable
    public static final Object extractModuleDependencies(@NotNull Module module, @Nullable PackageSearchApiClient packageSearch, @NotNull Continuation<? super List<Dependency>> $completion) {
        LOG.debug("Extract Java dependencies from the module: " + module.getName());
        List<Library> moduleLibraries = ProjectAnalyzer.Companion.isBatchMode().get() ? LibraryUtilsKt.getLibrary(module) : JvmProjectAnalyzerKt.getLibraryFromMainModule(module);
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new DependencyTreeFactory<Library>(new CollectInformationFromPackageSearch(new CollectInformationFromJar(project), packageSearch)).decorate(module, moduleLibraries, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final DependencyManager typeConfigFile(@Nullable String fileName) {
        block6: {
            block5: {
                var1_1 = fileName;
                if (var1_1 == null) break block5;
                switch (var1_1.hashCode()) {
                    case -2062421629: {
                        if (var1_1.equals("build.gradle.kts")) break;
                        ** break;
                    }
                    case -1995398201: {
                        if (var1_1.equals("build.gradle")) break;
                        ** break;
                    }
                    case -398814089: {
                        if (!var1_1.equals("pom.xml")) ** break;
                        v0 = DependencyManager.Maven;
                        break block6;
                    }
                }
                v0 = DependencyManager.Gradle;
                break block6;
            }
            v1 = fileName;
            v0 = (v1 != null ? StringsKt.endsWith$default((String)v1, (String)".iml", (boolean)false, (int)2, null) : false) != false ? DependencyManager.Java : DependencyManager.Unknown;
        }
        return v0;
    }

    public static final /* synthetic */ boolean access$containsLibraryInModuleMain(Module $receiver) {
        return JvmProjectAnalyzerKt.containsLibraryInModuleMain($receiver);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(JvmProjectAnalyzer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

