/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dependencyAnalysis.js;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.intellij.dependencyAnalysis.core.model.Algorithm;
import com.intellij.dependencyAnalysis.core.model.Checksum;
import com.intellij.dependencyAnalysis.core.model.Dependency;
import com.intellij.dependencyAnalysis.core.model.DependencyManager;
import com.intellij.dependencyAnalysis.core.model.PackageDependency;
import com.intellij.dependencyAnalysis.js.UtilsKt;
import com.jetbrains.themis.License;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a<\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0080@\u00a2\u0006\u0002\u0010\n\u001a\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0005H\u0000\u00a8\u0006\u000f"}, d2={"createNpmDependency", "Lcom/intellij/dependencyAnalysis/core/model/Dependency;", "dependency", "Lcom/intellij/dependencyAnalysis/core/model/PackageDependency;", "moduleName", "", "projectPath", "licenses", "", "Lcom/jetbrains/themis/License;", "(Lcom/intellij/dependencyAnalysis/core/model/PackageDependency;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseChecksumsFromLockFile", "", "Lcom/intellij/dependencyAnalysis/core/model/Checksum;", "text", "intellij.dependencyAnalysis.js"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/intellij/dependencyAnalysis/js/UtilsKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n135#2,9:45\n215#2:54\n216#2:57\n144#2:58\n1#3:55\n1#3:56\n1179#4,2:59\n1253#4,4:61\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/intellij/dependencyAnalysis/js/UtilsKt\n*L\n35#1:45,9\n35#1:54\n35#1:57\n35#1:58\n35#1:56\n42#1:59,2\n42#1:61,4\n*E\n"})
public final class UtilsKt {
    @Nullable
    public static final Object createNpmDependency(@NotNull PackageDependency dependency, @NotNull String moduleName, @Nullable String projectPath, @Nullable List<License> licenses, @NotNull Continuation<? super Dependency> $completion) {
        return Dependency.Companion.fromPackageDependency(dependency, DependencyManager.npm, "https://www.npmjs.com/package/" + dependency.getName(), moduleName, licenses, projectPath, $completion);
    }

    public static /* synthetic */ Object createNpmDependency$default(PackageDependency packageDependency, String string, String string2, List list, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            list = null;
        }
        return UtilsKt.createNpmDependency(packageDependency, string, string2, list, (Continuation<? super Dependency>)continuation);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Checksum> parseChecksumsFromLockFile(@NotNull String text2) {
        void $this$associateTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0002\u0000\u0005\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J$\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001R\"\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"com/intellij/dependencyAnalysis/js/UtilsKt$parseChecksumsFromLockFile$MainJSON", "", "packages", "", "", "com/intellij/dependencyAnalysis/js/UtilsKt$parseChecksumsFromLockFile$PackageInfo", "(Ljava/util/Map;)V", "getPackages", "()Ljava/util/Map;", "component1", "copy", "(Ljava/util/Map;)Lcom/intellij/dependencyAnalysis/js/UtilsKt$parseChecksumsFromLockFile$MainJSON;", "equals", "", "other", "hashCode", "", "toString", "intellij.dependencyAnalysis.js"})
        public final class MainJSON {
            @SerializedName(value="packages")
            @NotNull
            private final Map<String, PackageInfo> packages;

            public MainJSON(@NotNull Map<String, PackageInfo> packages2) {
                @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J2\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"com/intellij/dependencyAnalysis/js/UtilsKt$parseChecksumsFromLockFile$PackageInfo", "", "name", "", "version", "integrity", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getIntegrity", "()Ljava/lang/String;", "getName", "getVersion", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lcom/intellij/dependencyAnalysis/js/UtilsKt$parseChecksumsFromLockFile$PackageInfo;", "equals", "", "other", "hashCode", "", "toString", "intellij.dependencyAnalysis.js"})
                public final class PackageInfo {
                    @Nullable
                    private final String name;
                    @Nullable
                    private final String version;
                    @Nullable
                    private final String integrity;

                    public PackageInfo(@Nullable String name, @Nullable String version, @Nullable String integrity) {
                        this.name = name;
                        this.version = version;
                        this.integrity = integrity;
                    }

                    @Nullable
                    public final String getName() {
                        return this.name;
                    }

                    @Nullable
                    public final String getVersion() {
                        return this.version;
                    }

                    @Nullable
                    public final String getIntegrity() {
                        return this.integrity;
                    }

                    @Nullable
                    public final String component1() {
                        return this.name;
                    }

                    @Nullable
                    public final String component2() {
                        return this.version;
                    }

                    @Nullable
                    public final String component3() {
                        return this.integrity;
                    }

                    @NotNull
                    public final PackageInfo copy(@Nullable String name, @Nullable String version, @Nullable String integrity) {
                        return new PackageInfo(name, version, integrity);
                    }

                    public static /* synthetic */ PackageInfo copy$default(PackageInfo packageInfo, String string, String string2, String string3, int n, Object object) {
                        if ((n & 1) != 0) {
                            string = packageInfo.name;
                        }
                        if ((n & 2) != 0) {
                            string2 = packageInfo.version;
                        }
                        if ((n & 4) != 0) {
                            string3 = packageInfo.integrity;
                        }
                        return packageInfo.copy(string, string2, string3);
                    }

                    @NotNull
                    public String toString() {
                        return "PackageInfo(name=" + this.name + ", version=" + this.version + ", integrity=" + this.integrity + ")";
                    }

                    public int hashCode() {
                        int result = this.name == null ? 0 : this.name.hashCode();
                        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
                        result = result * 31 + (this.integrity == null ? 0 : this.integrity.hashCode());
                        return result;
                    }

                    public boolean equals(@Nullable Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof PackageInfo)) {
                            return false;
                        }
                        PackageInfo packageInfo = (PackageInfo)other;
                        if (!Intrinsics.areEqual((Object)this.name, (Object)packageInfo.name)) {
                            return false;
                        }
                        if (!Intrinsics.areEqual((Object)this.version, (Object)packageInfo.version)) {
                            return false;
                        }
                        return Intrinsics.areEqual((Object)this.integrity, (Object)packageInfo.integrity);
                    }
                }
                Intrinsics.checkNotNullParameter(packages2, (String)"packages");
                this.packages = packages2;
            }

            @NotNull
            public final Map<String, PackageInfo> getPackages() {
                return this.packages;
            }

            @NotNull
            public final Map<String, PackageInfo> component1() {
                return this.packages;
            }

            @NotNull
            public final MainJSON copy(@NotNull Map<String, PackageInfo> packages2) {
                Intrinsics.checkNotNullParameter(packages2, (String)"packages");
                return new MainJSON(packages2);
            }

            public static /* synthetic */ MainJSON copy$default(MainJSON mainJSON, Map map2, int n, Object object) {
                if ((n & 1) != 0) {
                    map2 = mainJSON.packages;
                }
                return mainJSON.copy(map2);
            }

            @NotNull
            public String toString() {
                return "MainJSON(packages=" + this.packages + ")";
            }

            public int hashCode() {
                return ((Object)this.packages).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MainJSON)) {
                    return false;
                }
                MainJSON mainJSON = (MainJSON)other;
                return Intrinsics.areEqual(this.packages, mainJSON.packages);
            }
        }
        MainJSON jsonObject = (MainJSON)new Gson().fromJson(text2, MainJSON.class);
        Map<String, PackageInfo> $this$mapNotNull$iv = jsonObject.getPackages();
        boolean $i$f$mapNotNull = false;
        Map<String, PackageInfo> map2 = $this$mapNotNull$iv;
        Iterable<Pair> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair pair;
            String string;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String k = (String)entry.getKey();
            PackageInfo v = (PackageInfo)entry.getValue();
            String it = string = k;
            boolean bl3 = false;
            String string2 = ((CharSequence)it).length() > 0 ? string : null;
            if (string2 == null || (string2 = StringsKt.substringAfterLast$default((String)string2, (String)"node_modules/", null, (int)2, null)) == null) {
                pair = null;
            } else {
                String name = string2;
                if (v.getVersion() == null) {
                    pair = null;
                } else {
                    String string3 = v.getIntegrity();
                    if (string3 == null || (string3 = StringsKt.substringAfter$default((String)string3, (String)"sha512-", null, (int)2, null)) == null || (string3 = StringsKt.substringBefore$default((String)string3, (String)"==", null, (int)2, null)) == null) {
                        pair = null;
                    } else {
                        String version;
                        String hash = string3;
                        String id = name + version;
                        Checksum checksum = new Checksum(Algorithm.SHA512, hash);
                        pair = TuplesKt.to((Object)id, (Object)checksum);
                    }
                }
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map3 = destination$iv$iv2;
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond());
            map3.put(pair.getFirst(), pair.getSecond());
        }
        Map checksums = destination$iv$iv2;
        return checksums;
    }
}

