/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.registry;

import com.intellij.docker.DockerMainCoroutineScopeHolder;
import com.intellij.docker.agent.registry.model.DockerRegistry;
import com.intellij.docker.agent.util.WebAddress;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerRegistryConfiguration;
import com.intellij.docker.registry.DockerRegistryManager;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.view.registry.DockerDummyRegistryProvider;
import com.intellij.docker.view.registry.DockerHubRegistryProvider;
import com.intellij.docker.view.registry.DockerRegistryProvider;
import com.intellij.docker.view.registry.node.DockerNamespaceNode;
import com.intellij.docker.view.registry.node.DockerRegistryRoot;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.text.StringKt;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b'\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\u0012J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H&J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\tH$J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0017J\u001a\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00170\u00192\u0006\u0010\u0011\u001a\u00020\tJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u0004J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\tJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006$"}, d2={"Lcom/intellij/docker/view/registry/DockerRegistryProvider;", "", "()V", "id", "", "getId", "()Ljava/lang/String;", "myCache", "Ljava/util/IdentityHashMap;", "Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "Lcom/intellij/docker/view/registry/node/DockerRegistryRoot;", "myLock", "Ljava/lang/Object;", "registryName", "getRegistryName", "checkCredentials", "", "registry", "(Lcom/intellij/docker/registry/DockerRegistryConfiguration;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createConfigurator", "Lcom/intellij/docker/view/registry/DockerRegistryProvider$Configurator;", "doGetRegistryRoot", "getAllRegistryNodes", "", "getNamespacesFor", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/docker/view/registry/node/DockerNamespaceNode;", "getRegistryByAddress", "address", "getRegistryRoot", "isApplicableTo", "", "refresh", "removeRegistryRoot", "Companion", "Configurator", "intellij.clouds.docker"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nDockerRegistryProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRegistryProvider.kt\ncom/intellij/docker/view/registry/DockerRegistryProvider\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,227:1\n372#2,7:228\n288#3,2:235\n*S KotlinDebug\n*F\n+ 1 DockerRegistryProvider.kt\ncom/intellij/docker/view/registry/DockerRegistryProvider\n*L\n169#1:228,7\n181#1:235,2\n*E\n"})
public abstract class DockerRegistryProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdentityHashMap<DockerRegistryConfiguration, DockerRegistryRoot> myCache = new IdentityHashMap();
    @NotNull
    private final Object myLock = new Object();
    @JvmField
    @NotNull
    public static final ExtensionPointName<DockerRegistryProvider> EP_NAME = ExtensionPointName.Companion.create("com.intellij.docker.registry.provider");

    @NotNull
    public abstract String getRegistryName();

    @NotNull
    public abstract String getId();

    @Nullable
    public abstract Configurator createConfigurator();

    public boolean isApplicableTo(@NotNull DockerRegistryConfiguration registry) {
        Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
        return Intrinsics.areEqual((Object)registry.getRegistryProviderId(), (Object)this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<DockerRegistryRoot> getAllRegistryNodes() {
        List list2;
        Object object = this.myLock;
        synchronized (object) {
            boolean bl = false;
            Collection<DockerRegistryRoot> collection = this.myCache.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            list2 = CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)collection));
        }
        return list2;
    }

    @Nullable
    public Object checkCredentials(@NotNull DockerRegistryConfiguration registry, @NotNull Continuation<? super Unit> $completion) {
        return DockerRegistryProvider.checkCredentials$suspendImpl(this, registry, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object checkCredentials$suspendImpl(DockerRegistryProvider var0, DockerRegistryConfiguration var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof checkCredentials.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DockerRegistryProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DockerRegistryProvider.checkCredentials$suspendImpl(this.this$0, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $this.doGetRegistryRoot((DockerRegistryConfiguration)registry);
                if (v0 == null) {
                    return Unit.INSTANCE;
                }
                node = v0;
                v1 = registry.getUsername();
                if (v1 == null) {
                    v1 = "";
                }
                if ((v2 = registry.getPasswordSafe()) == null) {
                    v2 = "";
                }
                $continuation.L$0 = node;
                $continuation.label = 1;
                v3 = node.checkCredentials(new DockerRegistry.Userdata(v1, v2), (Continuation<? super Unit>)$continuation);
                ** if (v3 != var7_5) goto lbl28
lbl27:
                // 1 sources

                return var7_5;
lbl28:
                // 1 sources

                ** GOTO lbl41
            }
            case 1: {
                node = (DockerRegistryRoot)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
                }
                catch (Throwable var4_7) {
                    throw var4_7;
                }
                finally {
                    node.disconnect();
                }
lbl41:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void removeRegistryRoot(@NotNull DockerRegistryConfiguration registry) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
            DockerRegistryRoot dockerRegistryRoot = this.myCache.remove((Object)registry);
            if (dockerRegistryRoot == null) break block0;
            dockerRegistryRoot.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final DockerRegistryRoot getRegistryRoot(@NotNull DockerRegistryConfiguration registry) {
        DockerRegistryRoot dockerRegistryRoot;
        Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
        Object object = this.myLock;
        synchronized (object) {
            Object object2;
            boolean bl = false;
            Map $this$getOrPut$iv = this.myCache;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get((Object)registry);
            if (value$iv == null) {
                DockerRegistryRoot dockerRegistryRoot2;
                boolean bl2 = false;
                try {
                    dockerRegistryRoot2 = this.doGetRegistryRoot(registry);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    dockerRegistryRoot2 = null;
                }
                DockerRegistryRoot answer$iv = dockerRegistryRoot2;
                $this$getOrPut$iv.put(registry, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            dockerRegistryRoot = (DockerRegistryRoot)object2;
        }
        return dockerRegistryRoot;
    }

    @Nullable
    public final DockerRegistryConfiguration getRegistryByAddress(@NotNull String address) {
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            List<DockerRegistryConfiguration> list2 = DockerRegistryManager.getInstance().getRegistries();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getRegistries(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DockerRegistryConfiguration registry = (DockerRegistryConfiguration)((Object)element$iv);
                boolean bl = false;
                String string = registry.getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAddress(...)");
                if (!(new WebAddress(string).equalsWithoutProtocol(address) && Intrinsics.areEqual((Object)registry.getRegistryProviderId(), (Object)this.getId()))) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refresh(@NotNull DockerRegistryConfiguration registry) {
        Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
        Object object = this.myLock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            DockerRegistryRoot dockerRegistryRoot = this.myCache.get((Object)registry);
            if (dockerRegistryRoot != null) {
                dockerRegistryRoot.refresh();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    @NotNull
    public final CompletableFuture<List<DockerNamespaceNode>> getNamespacesFor(@NotNull DockerRegistryConfiguration registry) {
        Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
        return DockerMainCoroutineScopeHolder.future$default(DockerMainCoroutineScopeHolder.Companion.getInstance(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super List<? extends DockerNamespaceNode>>, Object>(this, registry, null){
            int label;
            final /* synthetic */ DockerRegistryProvider this$0;
            final /* synthetic */ DockerRegistryConfiguration $registry;
            {
                this.this$0 = $receiver;
                this.$registry = $registry;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = this.this$0.getRegistryRoot(this.$registry);
                        if (v0 == null) ** GOTO lbl16
                        this.label = 1;
                        v1 = v0.getNamespaceNodes((Continuation<? super List<DockerNamespaceNode>>)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        if ((v0 = (List)v1) != null) ** GOTO lbl17
lbl16:
                        // 2 sources

                        v0 = CollectionsKt.emptyList();
lbl17:
                        // 2 sources

                        return v0;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<DockerNamespaceNode>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    @Nullable
    protected abstract DockerRegistryRoot doGetRegistryRoot(@NotNull DockerRegistryConfiguration var1);

    @JvmStatic
    @NotNull
    public static final DockerRegistryProvider getDefaultProvider() {
        return Companion.getDefaultProvider();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\bR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/view/registry/DockerRegistryProvider$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/docker/view/registry/DockerRegistryProvider;", "getDefaultProvider", "getFirstRegistryByAddress", "Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "address", "", "getProvider", "registry", "getRegistryRoot", "Lcom/intellij/docker/view/registry/node/DockerRegistryRoot;", "removeRegistryRoot", "", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerRegistryProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRegistryProvider.kt\ncom/intellij/docker/view/registry/DockerRegistryProvider$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,227:1\n1#2:228\n288#3,2:229\n1855#3,2:231\n*S KotlinDebug\n*F\n+ 1 DockerRegistryProvider.kt\ncom/intellij/docker/view/registry/DockerRegistryProvider$Companion\n*L\n210#1:229,2\n216#1:231,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DockerRegistryProvider getDefaultProvider() {
            Object v0;
            block1: {
                Iterable iterable = EP_NAME.getExtensionList();
                for (Object t : iterable) {
                    DockerRegistryProvider it = (DockerRegistryProvider)t;
                    boolean bl = false;
                    if (!(it instanceof DockerHubRegistryProvider)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            Intrinsics.checkNotNull(v0);
            return v0;
        }

        @NotNull
        public final DockerRegistryProvider getProvider(@NotNull DockerRegistryConfiguration registry) {
            DockerRegistryProvider dockerRegistryProvider;
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
                Iterable $this$firstOrNull$iv = EP_NAME.getExtensionList();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DockerRegistryProvider it = (DockerRegistryProvider)element$iv;
                    boolean bl = false;
                    if (!it.isApplicableTo(registry)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            if ((dockerRegistryProvider = (DockerRegistryProvider)v0) == null) {
                dockerRegistryProvider = new DockerDummyRegistryProvider();
            }
            return dockerRegistryProvider;
        }

        public final void removeRegistryRoot(@NotNull DockerRegistryConfiguration registry) {
            Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
            Iterable $this$forEach$iv = EP_NAME.getExtensionList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DockerRegistryProvider it = (DockerRegistryProvider)element$iv;
                boolean bl = false;
                it.removeRegistryRoot(registry);
            }
        }

        @Nullable
        public final DockerRegistryRoot getRegistryRoot(@NotNull DockerRegistryConfiguration registry) {
            Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
            return this.getProvider(registry).getRegistryRoot(registry);
        }

        @Nullable
        public final DockerRegistryConfiguration getFirstRegistryByAddress(@NotNull String address) {
            DockerRegistryConfiguration dockerRegistryConfiguration;
            block1: {
                Intrinsics.checkNotNullParameter((Object)address, (String)"address");
                for (DockerRegistryProvider it : (Iterable)EP_NAME.getExtensionList()) {
                    boolean bl = false;
                    DockerRegistryConfiguration dockerRegistryConfiguration2 = it.getRegistryByAddress(address);
                    if (dockerRegistryConfiguration2 == null) continue;
                    dockerRegistryConfiguration = dockerRegistryConfiguration2;
                    break block1;
                }
                dockerRegistryConfiguration = null;
            }
            return dockerRegistryConfiguration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\rJ\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\b\u0010\u000b\u001a\u00020\fH&R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/intellij/docker/view/registry/DockerRegistryProvider$Configurator;", "Lcom/intellij/openapi/Disposable;", "defaultAddress", "", "getDefaultAddress", "()Ljava/lang/String;", "applyDataToRegistry", "", "registry", "Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "applyRegistryToData", "createOptionsPanel", "Ljavax/swing/JComponent;", "Default", "intellij.clouds.docker"})
    public static interface Configurator
    extends Disposable {
        @Nullable
        public String getDefaultAddress();

        @NotNull
        public JComponent createOptionsPanel();

        public void applyDataToRegistry(@NotNull DockerRegistryConfiguration var1);

        public void applyRegistryToData(@NotNull DockerRegistryConfiguration var1);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B4\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\r\b\u0002\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001aJ\u0015\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0010\u00a2\u0006\u0002\b\"R\u001a\u0010\n\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0016\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\f\"\u0004\b\u0015\u0010\u000eR\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\f\"\u0004\b\u0018\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/intellij/docker/view/registry/DockerRegistryProvider$Configurator$Default;", "Lcom/intellij/docker/view/registry/DockerRegistryProvider$Configurator;", "isAddressEditable", "", "isUsernameVisible", "passwordLabel", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "defaultAddress", "(ZZLjava/lang/String;Ljava/lang/String;)V", "address", "getAddress", "()Ljava/lang/String;", "setAddress", "(Ljava/lang/String;)V", "getDefaultAddress", "myPanel", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lcom/intellij/openapi/ui/DialogPanel;", "password", "getPassword", "setPassword", "username", "getUsername", "setUsername", "applyDataToRegistry", "", "registry", "Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "applyRegistryToData", "createOptionsPanel", "Ljavax/swing/JComponent;", "dispose", "validate", "validate$intellij_clouds_docker", "Companion", "intellij.clouds.docker"})
        public static class Default
        implements Configurator {
            @NotNull
            public static final Companion Companion = new Companion(null);
            private final boolean isAddressEditable;
            private final boolean isUsernameVisible;
            @NotNull
            private final String passwordLabel;
            @Nullable
            private final String defaultAddress;
            @NotNull
            private String password;
            @NotNull
            private String address;
            @NotNull
            private String username;
            @NotNull
            private final SynchronizedClearableLazy<DialogPanel> myPanel;

            public Default(boolean isAddressEditable, boolean isUsernameVisible, @NotNull String passwordLabel, @Nullable String defaultAddress) {
                Intrinsics.checkNotNullParameter((Object)passwordLabel, (String)"passwordLabel");
                this.isAddressEditable = isAddressEditable;
                this.isUsernameVisible = isUsernameVisible;
                this.passwordLabel = passwordLabel;
                this.defaultAddress = defaultAddress;
                this.password = "";
                this.address = "";
                this.username = "";
                this.myPanel = new SynchronizedClearableLazy((Function0)new Function0<DialogPanel>(this){
                    final /* synthetic */ Default this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final DialogPanel invoke() {
                        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this.this$0){
                            final /* synthetic */ Default this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Panel $this$panel) {
                                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                                    final /* synthetic */ Default this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Row $this$row) {
                                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                        Cell cell = $this$row.textField();
                                        String string = DockerBundle.message("DockerRegistryConfigurable.address.text", new Object[0]);
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                        DockerUiUtilsKt.bindText((JTextField)Cell.label$default((Cell)cell, (String)string, null, (int)2, null).enabled(Default.access$isAddressEditable$p(this.this$0)).align(Align.FILL).getComponent(), (KMutableProperty0<String>)((KMutableProperty0)new MutablePropertyReference0Impl(this.this$0){

                                            @Nullable
                                            public Object get() {
                                                return ((Default)this.receiver).getAddress();
                                            }

                                            public void set(@Nullable Object value) {
                                                ((Default)this.receiver).setAddress((String)value);
                                            }
                                        }), (Disposable)this.this$0);
                                    }
                                }), (int)1, null).layout(RowLayout.PARENT_GRID);
                                if (Default.access$isUsernameVisible$p(this.this$0)) {
                                    Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                                        final /* synthetic */ Default this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull Row $this$row) {
                                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                            Cell cell = $this$row.textField();
                                            String string = DockerBundle.message("DockerRegistryConfigurable.username.text", new Object[0]);
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                            DockerUiUtilsKt.bindText((JTextField)Cell.label$default((Cell)cell, (String)string, null, (int)2, null).align(Align.FILL).getComponent(), (KMutableProperty0<String>)((KMutableProperty0)new MutablePropertyReference0Impl(this.this$0){

                                                @Nullable
                                                public Object get() {
                                                    return ((Default)this.receiver).getUsername();
                                                }

                                                public void set(@Nullable Object value) {
                                                    ((Default)this.receiver).setUsername((String)value);
                                                }
                                            }), (Disposable)this.this$0);
                                        }
                                    }), (int)1, null).layout(RowLayout.PARENT_GRID);
                                }
                                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                                    final /* synthetic */ Default this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Row $this$row) {
                                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                        DockerUiUtilsKt.bindText((JBPasswordField)Cell.label$default((Cell)$this$row.passwordField(), (String)Default.access$getPasswordLabel$p(this.this$0), null, (int)2, null).align(Align.FILL).getComponent(), (KMutableProperty0<String>)((KMutableProperty0)new MutablePropertyReference0Impl(this.this$0){

                                            @Nullable
                                            public Object get() {
                                                return ((Default)this.receiver).getPassword();
                                            }

                                            public void set(@Nullable Object value) {
                                                ((Default)this.receiver).setPassword((String)value);
                                            }
                                        }), (Disposable)this.this$0);
                                    }
                                }), (int)1, null).layout(RowLayout.PARENT_GRID);
                            }
                        }));
                    }
                });
            }

            public /* synthetic */ Default(boolean bl, boolean bl2, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = true;
                }
                if ((n & 2) != 0) {
                    bl2 = true;
                }
                if ((n & 4) != 0) {
                    String string3 = DockerBundle.message("DockerRegistryConfigurable.password.text", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    string = string3;
                }
                if ((n & 8) != 0) {
                    string2 = null;
                }
                this(bl, bl2, string, string2);
            }

            @Override
            @Nullable
            public String getDefaultAddress() {
                return this.defaultAddress;
            }

            @NotNull
            protected final String getPassword() {
                return this.password;
            }

            protected final void setPassword(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.password = string;
            }

            @NotNull
            protected final String getAddress() {
                return this.address;
            }

            protected final void setAddress(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.address = string;
            }

            @NotNull
            protected final String getUsername() {
                return this.username;
            }

            protected final void setUsername(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.username = string;
            }

            public void validate$intellij_clouds_docker(@NotNull DockerRegistryConfiguration registry) throws RuntimeConfigurationException {
                Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
                Companion.defaultUsernameValidation(registry.getUsername());
                Default.defaultPasswordValidation(registry.getPassword());
            }

            @Override
            public final void applyRegistryToData(@NotNull DockerRegistryConfiguration registry) {
                String string;
                String string2;
                Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
                String string3 = registry.getPasswordSafe();
                if (string3 == null) {
                    string3 = this.password = "";
                }
                if ((string2 = StringKt.nullize((String)registry.getAddress(), (boolean)true)) == null && (string2 = this.getDefaultAddress()) == null) {
                    string2 = this.address = "";
                }
                if ((string = registry.getUsername()) == null) {
                    string = "";
                }
                this.username = string;
            }

            @Override
            public final void applyDataToRegistry(@NotNull DockerRegistryConfiguration registry) {
                Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
                registry.setAddress(this.address);
                registry.setUsername(this.username);
                registry.setPasswordSafe(this.password);
            }

            public final void dispose() {
                this.myPanel.drop();
            }

            @Override
            @NotNull
            public final JComponent createOptionsPanel() {
                return (JComponent)this.myPanel.getValue();
            }

            public Default() {
                this(false, false, null, null, 15, null);
            }

            @JvmStatic
            protected static final void defaultPasswordValidation(@Nullable String password) throws RuntimeConfigurationException {
                Companion.defaultPasswordValidation(password);
            }

            public static final /* synthetic */ boolean access$isAddressEditable$p(Default $this) {
                return $this.isAddressEditable;
            }

            public static final /* synthetic */ boolean access$isUsernameVisible$p(Default $this) {
                return $this.isUsernameVisible;
            }

            public static final /* synthetic */ String access$getPasswordLabel$p(Default $this) {
                return $this.passwordLabel;
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0005J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0004\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/view/registry/DockerRegistryProvider$Configurator$Default$Companion;", "", "()V", "defaultPasswordValidation", "", "password", "", "defaultUsernameValidation", "username", "intellij.clouds.docker"})
            public static final class Companion {
                private Companion() {
                }

                protected final void defaultUsernameValidation(@Nullable String username) throws RuntimeConfigurationException {
                    CharSequence charSequence = username;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                        throw new RuntimeConfigurationException(DockerBundle.message("DockerRegistryConfigurable.error.username.required", new Object[0]));
                    }
                }

                @JvmStatic
                protected final void defaultPasswordValidation(@Nullable String password) throws RuntimeConfigurationException {
                    CharSequence charSequence = password;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                        throw new RuntimeConfigurationException(DockerBundle.message("DockerRegistryConfigurable.error.password.required", new Object[0]));
                    }
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

