/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.utils;

import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.util.TarCompressionUtil;
import com.intellij.docker.remoteRunRuntime.WrappedConflictException;
import com.intellij.docker.remoteRunRuntime.WrappedInternalServerErrorException;
import com.intellij.docker.remoteRunRuntime.WrappedNotFoundException;
import com.intellij.docker.remoteRunRuntime.WrappedNotModifiedException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableConsumer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteDockerRuntimeUtil {
    private static final Logger LOG = Logger.getInstance(RemoteDockerRuntimeUtil.class);

    public static void download(@NotNull DockerAgentContainer application, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Map<String, String> remoteToLocalPathName, @Nullable String machineName, @Nullable Predicate<String> remotePathFilter) throws IOException, ServerRuntimeException {
        if (application == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(0);
        }
        if (resourcePath == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(1);
        }
        if (targetFile == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(2);
        }
        RemoteDockerRuntimeUtil.download(application, resourcePath, targetFile, remoteToLocalPathName == null ? null : remoteToLocalPathName::get, machineName, remotePathFilter);
    }

    public static void download(@NotNull DockerAgentContainer application, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Function<String, String> remoteToLocalMapping, @Nullable String machineName, @Nullable Predicate<String> remotePathFilter) throws IOException, ServerRuntimeException {
        if (application == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(3);
        }
        if (resourcePath == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(4);
        }
        if (targetFile == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(5);
        }
        RemoteDockerRuntimeUtil.download(application, resourcePath, machineName, (ThrowableConsumer<? super File, ? extends IOException>)((ThrowableConsumer)tarFile2 -> RemoteDockerRuntimeUtil.extractTar(tarFile2, resourcePath, targetFile, remoteToLocalMapping, remotePathFilter)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void download(@NotNull DockerAgentContainer application, @NotNull String resourcePath, @Nullable String machineName, @NotNull ThrowableConsumer<? super File, ? extends IOException> extractor) throws IOException, ServerRuntimeException {
        if (application == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(6);
        }
        if (resourcePath == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(7);
        }
        if (extractor == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(8);
        }
        File tarFile2 = FileUtil.createTempFile((String)String.valueOf(application.getContainerId().hashCode()), (String)".download.tar");
        try {
            try (FileOutputStream tarOutputStream = new FileOutputStream(tarFile2);){
                LOG.debug("Downloading '", new Object[]{resourcePath, "' resource from Docker container '", application.getContainerId(), "' created at Docker machine ", "'", machineName, "' to '", tarFile2.getAbsolutePath(), "'"});
                try (InputStream requestInputStream = RemoteDockerRuntimeUtil.executeAgentTask(application.copyArchiveFromContainer(resourcePath));){
                    long size = IOUtils.copyLarge((InputStream)requestInputStream, (OutputStream)tarOutputStream);
                    LOG.debug("Downloaded ", new Object[]{size, " bytes from container '", application.getContainerId(), "' to '", tarFile2.getAbsolutePath(), "'"});
                }
            }
            extractor.consume((Object)tarFile2);
            if (tarFile2.delete()) return;
        }
        catch (Throwable throwable) {
            if (tarFile2.delete()) throw throwable;
            LOG.debug("Failed to delete temporary tar file '", new Object[]{tarFile2.getPath(), "'"});
            throw throwable;
        }
        LOG.debug("Failed to delete temporary tar file '", new Object[]{tarFile2.getPath(), "'"});
    }

    public static <T> T executeAgentTask(CompletableFuture<T> future) throws ServerRuntimeException {
        return RemoteDockerRuntimeUtil.executeAgentTask(() -> {
            try {
                return future.join();
            }
            catch (CompletionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ServerRuntimeException) {
                    throw (ServerRuntimeException)cause;
                }
                if (cause instanceof CancellationException) {
                    throw new ServerRuntimeException((String)ObjectUtils.notNull((Object)cause.getMessage(), (Object)"Operation cancelled"));
                }
                throw new ServerRuntimeException((Throwable)e);
            }
        });
    }

    public static <T> T executeAgentTask(@NotNull ThrowableComputable<T, ? extends ServerRuntimeException> computable) throws ServerRuntimeException {
        if (computable == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(9);
        }
        try {
            return (T)computable.compute();
        }
        catch (ServerRuntimeException e) {
            String message = StringUtil.notNullize((String)e.getMessage());
            if (message.contains("NotFoundException")) {
                throw new WrappedNotFoundException(message);
            }
            if (message.contains("InternalServerErrorException")) {
                throw new WrappedInternalServerErrorException(message);
            }
            if (message.contains("NotModifiedException")) {
                throw new WrappedNotModifiedException(message);
            }
            if (message.contains("ConflictException")) {
                throw new WrappedConflictException(message);
            }
            throw e;
        }
    }

    public static void extractTar(@NotNull File tarFile2, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Function<String, String> remoteToLocalMapping, @Nullable Predicate<String> remotePathFilter) throws IOException {
        if (tarFile2 == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(10);
        }
        if (resourcePath == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(11);
        }
        if (targetFile == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(12);
        }
        LOG.debug("Extracting '", new Object[]{tarFile2.getAbsoluteFile(), "' to '", targetFile.getPath(), "'"});
        RemoteDockerRuntimeUtil.extractTar((InputStream)new BufferedInputStream(new FileInputStream(tarFile2)), resourcePath, targetFile, remoteToLocalMapping, remotePathFilter);
    }

    public static void extractTar(@NotNull InputStream inputStream, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Map<String, String> remoteToLocalPathName, @Nullable Predicate<String> remotePathFilter) throws IOException {
        if (inputStream == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(13);
        }
        if (resourcePath == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(14);
        }
        if (targetFile == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(15);
        }
        RemoteDockerRuntimeUtil.extractTar(inputStream, resourcePath, targetFile, remoteToLocalPathName == null ? null : remoteToLocalPathName::get, remotePathFilter);
    }

    private static void extractTar(@NotNull InputStream inputStream, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Function<String, String> remoteToLocalMapping, @Nullable Predicate<String> remotePathFilter) throws IOException {
        if (inputStream == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(16);
        }
        if (resourcePath == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(17);
        }
        if (targetFile == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(18);
        }
        try (TarArchiveInputStream tarInputStream = new TarArchiveInputStream(TarCompressionUtil.decompressStream(inputStream));){
            TarArchiveEntry tarEntry = tarInputStream.getNextTarEntry();
            while (tarEntry != null) {
                if ((tarEntry.isFile() || tarEntry.isDirectory()) && StringUtil.isNotEmpty((String)tarEntry.getName())) {
                    boolean isStubbed;
                    String remoteParentPathName = PathUtil.getParentPath((String)resourcePath);
                    String remotePathName = FileUtil.toCanonicalPath((String)String.join((CharSequence)"/", remoteParentPathName, tarEntry.getName()), (char)'/');
                    boolean bl = isStubbed = remotePathFilter != null && !remotePathFilter.test(remotePathName);
                    if (remoteToLocalMapping == null) {
                        localPathName = RemoteDockerRuntimeUtil.replacePathPrefix(tarEntry.getName(), targetFile.getName());
                        RemoteDockerRuntimeUtil.copyTarEntry(tarInputStream, tarEntry, targetFile.getParentFile(), localPathName, isStubbed);
                    } else {
                        localPathName = (String)remoteToLocalMapping.fun((Object)remotePathName);
                        if (localPathName != null) {
                            RemoteDockerRuntimeUtil.copyTarEntry(tarInputStream, tarEntry, targetFile, localPathName, isStubbed);
                        } else {
                            LOG.debug("Remote file '" + remotePathName + "' skipped");
                        }
                    }
                }
                tarEntry = tarInputStream.getNextTarEntry();
            }
        }
    }

    @NotNull
    public static String replacePathPrefix(@NotNull String path, @NotNull String newPrefix) {
        int index;
        if (path == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(19);
        }
        if (newPrefix == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(20);
        }
        if ((index = path.indexOf(47)) == -1) {
            index = path.length();
        }
        String string = newPrefix + path.substring(index);
        if (string == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static void copyTarEntry(@NotNull TarArchiveInputStream tarInputStream, @NotNull TarArchiveEntry tarEntry, @NotNull File targetDir, @NotNull String localPathName, boolean isStubbed) throws IOException {
        if (tarInputStream == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(22);
        }
        if (tarEntry == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(23);
        }
        if (targetDir == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(24);
        }
        if (localPathName == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(25);
        }
        if (SystemInfo.isWindows && localPathName.contains("\\")) {
            LOG.info("Extraction path '" + localPathName + "' contains backslashes, which will be treated as path separators");
        }
        File targetFile = new File(targetDir, localPathName);
        if (tarEntry.isFile()) {
            if (!FileUtil.createParentDirs((File)targetFile)) {
                LOG.warn("Failed to create parent directories for file '" + targetFile + "' it will be skipped");
                return;
            }
            if (isStubbed) {
                FileUtil.createIfDoesntExist((File)targetFile);
                return;
            }
            try (FileOutputStream entryOutputStream = new FileOutputStream(targetFile);){
                IOUtils.copyLarge((InputStream)tarInputStream, (OutputStream)entryOutputStream);
            }
        } else if (tarEntry.isDirectory()) {
            FileUtil.createDirectory((File)targetFile);
        } else {
            LOG.warn("Failed to copy entry of unknown type '" + targetFile + "', it will be skipped");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 2: 
            case 5: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tarFile";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPrefix";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/utils/RemoteDockerRuntimeUtil";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tarInputStream";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tarEntry";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPathName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/utils/RemoteDockerRuntimeUtil";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "replacePathPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeAgentTask";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "extractTar";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "replacePathPrefix";
                break;
            }
            case 21: {
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "copyTarEntry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21 -> new IllegalStateException(string);
        };
    }
}

