/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.utils;

import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.progress.DockerResponseItemTtyHandler;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J&\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/ui/utils/DockerRedirectToTerminal;", "Ljava/util/function/Consumer;", "Ljava/util/concurrent/BlockingQueue;", "", "ttySink", "Lcom/intellij/docker/agent/progress/TtySink;", "(Lcom/intellij/docker/agent/progress/TtySink;)V", "accept", "", "t", "onPullChannelAvailable", "", "Lcom/intellij/docker/agent/progress/DockerResponseItem$AuxDetail;", "channel", "redirectToTerminalLater", "Ljava/util/concurrent/CompletableFuture;", "channelPromise", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerRedirectToTerminal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRedirectToTerminal.kt\ncom/intellij/docker/ui/utils/DockerRedirectToTerminal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
public final class DockerRedirectToTerminal
implements Consumer<BlockingQueue<byte[]>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TtySink ttySink;
    @NotNull
    private static final Logger LOG;

    public DockerRedirectToTerminal(@NotNull TtySink ttySink) {
        Intrinsics.checkNotNullParameter((Object)ttySink, (String)"ttySink");
        this.ttySink = ttySink;
    }

    @Override
    public void accept(@NotNull BlockingQueue<byte[]> t) {
        Intrinsics.checkNotNullParameter(t, (String)"t");
        this.onPullChannelAvailable(t);
    }

    @NotNull
    public final CompletableFuture<List<DockerResponseItem.AuxDetail>> redirectToTerminalLater(@NotNull CompletableFuture<BlockingQueue<byte[]>> channelPromise) {
        Intrinsics.checkNotNullParameter(channelPromise, (String)"channelPromise");
        CompletionStage completionStage = ((CompletableFuture)channelPromise.thenApplyAsync(arg_0 -> DockerRedirectToTerminal.redirectToTerminalLater$lambda$0((Function1)new Function1<BlockingQueue<byte[]>, List<? extends DockerResponseItem.AuxDetail>>((Object)this){

            @NotNull
            public final List<DockerResponseItem.AuxDetail> invoke(@NotNull BlockingQueue<byte[]> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return DockerRedirectToTerminal.access$onPullChannelAvailable((DockerRedirectToTerminal)this.receiver, p0);
            }
        }, arg_0), (Executor)AppExecutorUtil.getAppExecutorService())).exceptionally(arg_0 -> DockerRedirectToTerminal.redirectToTerminalLater$lambda$1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"exceptionally(...)");
        return completionStage;
    }

    private final List<DockerResponseItem.AuxDetail> onPullChannelAvailable(BlockingQueue<byte[]> channel) {
        List auxDetails = new ArrayList();
        DockerResponseItemTtyHandler handler2 = new DockerResponseItemTtyHandler(this.ttySink);
        LOG.trace("poll: about to start");
        while (true) {
            try {
                byte[] next2 = channel.poll(3L, TimeUnit.SECONDS);
                if (next2 == null) {
                    LOG.trace("poll: nothing polled for 3 seconds");
                    continue;
                }
                if (next2.length == 0) {
                    LOG.trace("poll: closing signal received");
                    break;
                }
                DockerResponseItem.Impl nextItem = DockerResponseItem.Impl.Companion.fromByteArray(next2);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("packet: " + Base64.getEncoder().encode(next2));
                    LOG.trace("decode: " + nextItem);
                }
                handler2.handleItem(nextItem);
                if (nextItem.getAux() != null) {
                    DockerResponseItem.AuxDetail p0;
                    boolean bl = false;
                    auxDetails.add(p0);
                }
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
        }
        LOG.trace("poll: finished");
        return CollectionsKt.toList((Iterable)auxDetails);
    }

    private static final List redirectToTerminalLater$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final List redirectToTerminalLater$lambda$1(DockerRedirectToTerminal this$0, Throwable failure) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LOG.warn(failure);
        TtySink ttySink = this$0.ttySink;
        Object[] objectArray = new Object[]{failure.getMessage()};
        String string = DockerBundle.message("DockerPullToTerminal.error.operation.failed", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ttySink.coloredTtyPrintln(string, TtySink.Colors.RED);
        return null;
    }

    public static final /* synthetic */ List access$onPullChannelAvailable(DockerRedirectToTerminal $this, BlockingQueue channel) {
        return $this.onPullChannelAvailable(channel);
    }

    static {
        Logger logger2 = Logger.getInstance(DockerRedirectToTerminal.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/ui/utils/DockerRedirectToTerminal$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

