/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target.prepare;

import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.run.target.configuration.wizard.DockerTargetIntrospectable;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.ui.utils.DockerRedirectToTerminal;
import com.intellij.execution.target.LanguageRuntimeConfiguration;
import com.intellij.execution.target.LanguageRuntimeConfigurationKt;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b \u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H$J\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0014\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\nH$J\u0012\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/docker/remote/run/target/prepare/PrepareImageOperation;", "", "docker", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "ttySink", "Lcom/intellij/docker/agent/progress/TtySink;", "(Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;Lcom/intellij/docker/agent/progress/TtySink;)V", "getDocker", "()Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "introspect", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/docker/agent/DockerAgentImage;", "image", "languageRuntime", "Lcom/intellij/execution/target/LanguageRuntimeConfiguration;", "onChannelFinished", "auxDetails", "", "Lcom/intellij/docker/agent/progress/DockerResponseItem$AuxDetail;", "perform", "prepareChannel", "Ljava/util/concurrent/BlockingQueue;", "", "println", "", "text", "", "intellij.clouds.docker.remoteRun"})
public abstract class PrepareImageOperation {
    @NotNull
    private final RemoteDockerRuntime docker;
    @NotNull
    private final TtySink ttySink;

    public PrepareImageOperation(@NotNull RemoteDockerRuntime docker, @NotNull TtySink ttySink) {
        Intrinsics.checkNotNullParameter((Object)docker, (String)"docker");
        Intrinsics.checkNotNullParameter((Object)ttySink, (String)"ttySink");
        this.docker = docker;
        this.ttySink = ttySink;
    }

    @NotNull
    protected final RemoteDockerRuntime getDocker() {
        return this.docker;
    }

    @NotNull
    public final CompletableFuture<DockerAgentImage> perform(@Nullable LanguageRuntimeConfiguration languageRuntime) {
        CompletableFuture<BlockingQueue<byte[]>> channelPromise = this.prepareChannel();
        CompletableFuture<List<DockerResponseItem.AuxDetail>> auxDetailsPromise = new DockerRedirectToTerminal(this.ttySink).redirectToTerminalLater(channelPromise);
        CompletionStage completionStage = ((CompletableFuture)auxDetailsPromise.thenApply(arg_0 -> PrepareImageOperation.perform$lambda$0((Function1)new Function1<List<? extends DockerResponseItem.AuxDetail>, DockerAgentImage>(this){
            final /* synthetic */ PrepareImageOperation this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final DockerAgentImage invoke(List<? extends DockerResponseItem.AuxDetail> auxDetails) {
                try {
                    Intrinsics.checkNotNull(auxDetails);
                    DockerAgentImage image = this.this$0.onChannelFinished(auxDetails);
                    if (image == null) {
                        String string = DockerBundle.message("PrepareImageOperation.unable.to.find.an.image.for.introspection", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.this$0.println(string);
                    }
                    return image;
                }
                catch (ServerRuntimeException e) {
                    Object[] objectArray = new Object[]{e.getMessage()};
                    String string = DockerBundle.message("PrepareImageOperation.failed.to.find.image.for.introspection", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.this$0.println(string);
                    return null;
                }
            }
        }, arg_0))).thenCompose(arg_0 -> PrepareImageOperation.perform$lambda$1((Function1)new Function1<DockerAgentImage, CompletionStage<DockerAgentImage>>(this, languageRuntime){
            final /* synthetic */ PrepareImageOperation this$0;
            final /* synthetic */ LanguageRuntimeConfiguration $languageRuntime;
            {
                this.this$0 = $receiver;
                this.$languageRuntime = $languageRuntime;
                super(1);
            }

            public final CompletionStage<DockerAgentImage> invoke(@Nullable DockerAgentImage image) {
                return PrepareImageOperation.access$introspect(this.this$0, image, this.$languageRuntime);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
        return completionStage;
    }

    protected final void println(@Nls @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.ttySink.ttyPrintln(text2);
    }

    private final CompletableFuture<DockerAgentImage> introspect(DockerAgentImage image, LanguageRuntimeConfiguration languageRuntime) {
        CompletableFuture<DockerAgentImage> withoutIntrospection = CompletableFuture.completedFuture(image);
        if (image == null) {
            Intrinsics.checkNotNull(withoutIntrospection);
            return withoutIntrospection;
        }
        LanguageRuntimeConfiguration languageRuntimeConfiguration = languageRuntime;
        if (languageRuntimeConfiguration == null || (languageRuntimeConfiguration = LanguageRuntimeConfigurationKt.getRuntimeType((LanguageRuntimeConfiguration)languageRuntimeConfiguration)) == null || (languageRuntimeConfiguration = languageRuntimeConfiguration.createIntrospector(languageRuntime)) == null) {
            Intrinsics.checkNotNull(withoutIntrospection);
            return withoutIntrospection;
        }
        LanguageRuntimeConfiguration introspector = languageRuntimeConfiguration;
        DockerTargetIntrospectable introspectable = new DockerTargetIntrospectable(this.docker, image, this.ttySink);
        CompletionStage completionStage = ((CompletableFuture)introspector.introspect((LanguageRuntimeType.Introspectable)introspectable).thenApply(arg_0 -> PrepareImageOperation.introspect$lambda$2((Function1)new Function1<LanguageRuntimeConfiguration, DockerAgentImage>(image){
            final /* synthetic */ DockerAgentImage $image;
            {
                this.$image = $image;
                super(1);
            }

            public final DockerAgentImage invoke(LanguageRuntimeConfiguration it) {
                return this.$image;
            }
        }, arg_0))).whenComplete((arg_0, arg_1) -> PrepareImageOperation.introspect$lambda$3((Function2)new Function2<Object, Throwable, Unit>(this, introspectable){
            final /* synthetic */ PrepareImageOperation this$0;
            final /* synthetic */ DockerTargetIntrospectable $introspectable;
            {
                this.this$0 = $receiver;
                this.$introspectable = $introspectable;
                super(2);
            }

            public final void invoke(@Nullable Object object, @Nullable Throwable err) {
                if (err == null) {
                    String string = DockerBundle.message("PrepareImageOperation.introspection.completed", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.this$0.println(string);
                } else {
                    Object[] objectArray = new Object[]{err.getMessage()};
                    String string = DockerBundle.message("PrepareImageOperation.introspection.completed.with.error", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.this$0.println(string);
                }
                this.$introspectable.shutdown();
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"whenComplete(...)");
        return completionStage;
    }

    @NotNull
    protected abstract CompletableFuture<BlockingQueue<byte[]>> prepareChannel();

    @Nullable
    protected abstract DockerAgentImage onChannelFinished(@NotNull List<? extends DockerResponseItem.AuxDetail> var1) throws ServerRuntimeException;

    private static final DockerAgentImage perform$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DockerAgentImage)$tmp0.invoke(p0);
    }

    private static final CompletionStage perform$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final DockerAgentImage introspect$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DockerAgentImage)$tmp0.invoke(p0);
    }

    private static final void introspect$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ CompletableFuture access$introspect(PrepareImageOperation $this, DockerAgentImage image, LanguageRuntimeConfiguration languageRuntime) {
        return $this.introspect(image, languageRuntime);
    }
}

