/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target;

import com.github.dockerjava.api.model.Bind;
import com.intellij.docker.agent.impl.DockerCliUtil;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.run.target.PathInsideBindMount;
import com.intellij.execution.Platform;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001a \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u001a \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0000\u001a\u0016\u0010\u0012\u001a\u0004\u0018\u00010\r*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"UNIX_FILE_SEPARATOR", "", "joinUnixPaths", "", "basePath", "relativePath", "parseDockerVolumeBindingFromDockerRunCliOptions", "", "Lcom/intellij/docker/agent/settings/DockerVolumeBinding;", "runCliOptions", "contextFolder", "Ljava/io/File;", "tryToResolveLocalPathInBindMounts", "Lcom/intellij/docker/remote/run/target/PathInsideBindMount;", "localPath", "Ljava/nio/file/Path;", "bindings", "", "tryToResolveAgainst", "binding", "intellij.clouds.docker.remoteRun"})
@JvmName(name="DockerBindVolumes")
@SourceDebugExtension(value={"SMAP\nDockerBindVolumes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerBindVolumes.kt\ncom/intellij/docker/remote/run/target/DockerBindVolumes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,40:1\n1549#2:41\n1620#2,3:42\n1#3:45\n*S KotlinDebug\n*F\n+ 1 DockerBindVolumes.kt\ncom/intellij/docker/remote/run/target/DockerBindVolumes\n*L\n16#1:41\n16#1:42,3\n*E\n"})
public final class DockerBindVolumes {
    private static final char UNIX_FILE_SEPARATOR = Platform.UNIX.fileSeparator;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<DockerVolumeBinding> parseDockerVolumeBindingFromDockerRunCliOptions(@NotNull String runCliOptions, @Nullable File contextFolder) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)runCliOptions, (String)"runCliOptions");
        Iterable $this$map$iv = DockerCliUtil.parseMountsFromDockerRunCliOptions(runCliOptions, contextFolder);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Bind bind = (Bind)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DockerVolumeBindingImpl(it.getVolume().getPath(), it.getPath(), false));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final PathInsideBindMount tryToResolveLocalPathInBindMounts(@NotNull Path localPath, @NotNull Collection<? extends DockerVolumeBinding> bindings) {
        PathInsideBindMount pathInsideBindMount;
        block1: {
            Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
            Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
            for (DockerVolumeBinding it : (Iterable)bindings) {
                boolean bl = false;
                PathInsideBindMount pathInsideBindMount2 = DockerBindVolumes.tryToResolveAgainst(localPath, it);
                if (pathInsideBindMount2 == null) continue;
                pathInsideBindMount = pathInsideBindMount2;
                break block1;
            }
            pathInsideBindMount = null;
        }
        return pathInsideBindMount;
    }

    private static final PathInsideBindMount tryToResolveAgainst(Path $this$tryToResolveAgainst, DockerVolumeBinding binding) {
        Path path;
        String string = binding.getHostPath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            path = Paths.get(it, new String[0]);
        } else {
            path = null;
        }
        if (path == null) {
            return null;
        }
        Path hostPath = path;
        if ($this$tryToResolveAgainst.startsWith(hostPath)) {
            String childLocalRelativePath = ((Object)hostPath.relativize($this$tryToResolveAgainst)).toString();
            String string2 = FileUtil.toSystemDependentName((String)childLocalRelativePath, (char)UNIX_FILE_SEPARATOR);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
            String childContainerRelativePath = string2;
            String string3 = binding.getContainerPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getContainerPath(...)");
            String childContainerPath = DockerBindVolumes.joinUnixPaths(string3, childContainerRelativePath);
            return new PathInsideBindMount(childContainerPath, binding);
        }
        return null;
    }

    private static final String joinUnixPaths(String basePath, String relativePath) {
        return Intrinsics.areEqual((Object)basePath, (Object)"/") ? basePath + relativePath : StringsKt.removeSuffix((String)basePath, (CharSequence)"/") + UNIX_FILE_SEPARATOR + relativePath;
    }
}

