/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.google.common.net.HostAndPort;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerExecProcess
extends RemoteProcess {
    @NotNull
    private static final Logger LOG = Logger.getInstance(DockerExecProcess.class);
    @NotNull
    private final RemoteDockerApplicationRuntime myApplicationRuntime;
    @NotNull
    private final OutputStream myOutputStream;
    @NotNull
    private final InputStream myInputStream;
    @NotNull
    private final InputStream myErrorStream;
    @NotNull
    private final CountDownLatch myCompleted;
    @NotNull
    private final AtomicInteger myExitCode;
    @NotNull
    private final String myDockerHost;
    private final boolean myRemoveContainer;

    public DockerExecProcess(@NotNull RemoteDockerApplicationRuntime applicationRuntime, @NotNull String dockerHost, boolean removeContainer) {
        if (applicationRuntime == null) {
            DockerExecProcess.$$$reportNull$$$0(0);
        }
        if (dockerHost == null) {
            DockerExecProcess.$$$reportNull$$$0(1);
        }
        this.myCompleted = new CountDownLatch(1);
        this.myExitCode = new AtomicInteger();
        this.myApplicationRuntime = applicationRuntime;
        this.myDockerHost = dockerHost;
        this.myRemoveContainer = removeContainer;
        this.myOutputStream = applicationRuntime.getStdin();
        this.myInputStream = applicationRuntime.getStdout();
        this.myErrorStream = applicationRuntime.getStderr();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.myApplicationRuntime.wait4terminal();
            }
            finally {
                this.onTerminalClosed();
            }
        });
    }

    public void onTerminalClosed() {
        try {
            if (this.retrieveContainerExitCode()) {
                this.removeContainerLater();
            }
        }
        finally {
            this.myCompleted.countDown();
        }
    }

    private void removeContainerLater() {
        if (this.myRemoveContainer) {
            ApplicationManager.getApplication().executeOnPooledThread(this.myApplicationRuntime::removeContainer);
        }
    }

    @NotNull
    public OutputStream getOutputStream() {
        OutputStream outputStream = this.myOutputStream;
        if (outputStream == null) {
            DockerExecProcess.$$$reportNull$$$0(2);
        }
        return outputStream;
    }

    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = this.myInputStream;
        if (inputStream == null) {
            DockerExecProcess.$$$reportNull$$$0(3);
        }
        return inputStream;
    }

    @NotNull
    public InputStream getErrorStream() {
        InputStream inputStream = this.myErrorStream;
        if (inputStream == null) {
            DockerExecProcess.$$$reportNull$$$0(4);
        }
        return inputStream;
    }

    public int waitFor() throws InterruptedException {
        this.myCompleted.await();
        return this.myExitCode.get();
    }

    public int exitValue() {
        if (this.myCompleted.getCount() != 0L) {
            throw new IllegalThreadStateException();
        }
        return this.myExitCode.get();
    }

    public void destroy() {
        this.stopContainerLater();
    }

    public boolean killProcessTree() {
        this.killContainerLater();
        return true;
    }

    public boolean isDisconnected() {
        return this.myCompleted.getCount() == 0L;
    }

    private boolean retrieveContainerExitCode() {
        try {
            int exitCode2 = this.myApplicationRuntime.executeAgentTask(this.myApplicationRuntime.getAgentContainer().waitForExit());
            this.myExitCode.set(exitCode2);
            if (exitCode2 < 0) {
                LOG.debug("Failed to retrieve exit code from " + this.myApplicationRuntime.getContainerId());
            } else if (this.myApplicationRuntime.inspect().isRunning()) {
                LOG.debug("Container " + this.myApplicationRuntime.getContainerId() + " has unexpected \"running\" state");
            }
            return exitCode2 >= 0;
        }
        catch (ServerRuntimeException e) {
            LOG.info(e.getMessage());
            return false;
        }
    }

    private void stopContainerLater() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.myApplicationRuntime.executeAgentTask(this.myApplicationRuntime.getAgentContainer().stopContainer());
            }
            catch (ServerRuntimeException e) {
                LOG.info(e.getMessage());
            }
            finally {
                if (this.myRemoveContainer) {
                    this.myApplicationRuntime.removeContainer();
                }
            }
        });
    }

    private void killContainerLater() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.myApplicationRuntime.executeAgentTask(this.myApplicationRuntime.getAgentContainer().killContainer());
            }
            catch (ServerRuntimeException e) {
                LOG.info(e.getMessage());
            }
            finally {
                if (this.myRemoveContainer) {
                    this.myApplicationRuntime.removeContainer();
                }
            }
        });
    }

    @NotNull
    public RemoteDockerApplicationRuntime getApplicationRuntime() {
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = this.myApplicationRuntime;
        if (remoteDockerApplicationRuntime == null) {
            DockerExecProcess.$$$reportNull$$$0(5);
        }
        return remoteDockerApplicationRuntime;
    }

    @NotNull
    public String getDockerHost() {
        String string = this.myDockerHost;
        if (string == null) {
            DockerExecProcess.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        return HostAndPort.fromParts((String)this.myDockerHost, (int)remotePort);
    }

    public void setWindowSize(int columns, int rows) {
        this.myApplicationRuntime.setWindowSize(columns, rows);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationRuntime";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerHost";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/runtime/DockerExecProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/runtime/DockerExecProcess";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorStream";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationRuntime";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    public static final class Factory {
        @NotNull
        public static DockerExecProcess startProcess(@NotNull RemoteDockerRuntime dockerRuntime2, @NotNull DockerAgentDeploymentConfig config2) throws ServerRuntimeException, RemoteSdkException, IOException {
            if (dockerRuntime2 == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (config2 == null) {
                Factory.$$$reportNull$$$0(1);
            }
            RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.createWithPullImage(dockerRuntime2, config2);
            applicationRuntime.startAndAttach();
            return Factory.newProcess(applicationRuntime, false);
        }

        @NotNull
        public static DockerExecProcess startProcessWithRemove(@NotNull RemoteDockerRuntime dockerRuntime2, @NotNull DockerAgentDeploymentConfig config2) throws ServerRuntimeException, RemoteSdkException, IOException {
            if (dockerRuntime2 == null) {
                Factory.$$$reportNull$$$0(2);
            }
            if (config2 == null) {
                Factory.$$$reportNull$$$0(3);
            }
            RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.createWithPullImage(dockerRuntime2, config2);
            return Factory.startProcessWithRemove(applicationRuntime);
        }

        @NotNull
        public static DockerExecProcess startProcessWithRemove(@NotNull RemoteDockerApplicationRuntime applicationRuntime) throws ServerRuntimeException, RemoteSdkException {
            if (applicationRuntime == null) {
                Factory.$$$reportNull$$$0(4);
            }
            try {
                applicationRuntime.startAndAttach();
                return Factory.newProcess(applicationRuntime, true);
            }
            catch (ServerRuntimeException e) {
                ApplicationManager.getApplication().executeOnPooledThread(applicationRuntime::removeContainer);
                throw e;
            }
        }

        @NotNull
        public static DockerExecProcess newProcess(@NotNull RemoteDockerApplicationRuntime applicationRuntime, boolean removeContainer) throws RemoteSdkException {
            if (applicationRuntime == null) {
                Factory.$$$reportNull$$$0(5);
            }
            DockerCloudConfiguration account = applicationRuntime.getDockerRuntime().getAccount();
            String dockerHost = DockerUtil.getDockerHost(account);
            return new DockerExecProcess(applicationRuntime, dockerHost, removeContainer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dockerRuntime";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "applicationRuntime";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/remote/run/runtime/DockerExecProcess$Factory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startProcess";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startProcessWithRemove";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "newProcess";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

