/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.compose;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.docker.cli.DockerComposeCli;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
public final class DockerComposeProjectService {
    private static final Logger LOG = Logger.getInstance(DockerComposeProjectService.class);
    private static final String DEFAULT_DOCKER_COMPOSE_VERSION = "1.11.2";
    private final LoadingCache<String, String> myDockerComposeVersionsCache = Caffeine.newBuilder().refreshAfterWrite(30L, TimeUnit.SECONDS).build(key -> {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        try {
            return DockerComposeCli.getVersion(indicator);
        }
        catch (Exception e) {
            DockerComposeProjectService.logDockerComposeVersionException(key, e);
            return DEFAULT_DOCKER_COMPOSE_VERSION;
        }
    });

    @NotNull
    public String getDockerComposeVersion() {
        String dockerComposeExePath = DockerComposeCliUtil.createDockerComposeCommandline().getExePath();
        if (!StringUtil.isEmpty((String)dockerComposeExePath)) {
            String string;
            try {
                string = (String)this.myDockerComposeVersionsCache.get((Object)dockerComposeExePath);
            }
            catch (Exception e) {
                DockerComposeProjectService.logDockerComposeVersionException(dockerComposeExePath, e);
            }
            if (string == null) {
                DockerComposeProjectService.$$$reportNull$$$0(0);
            }
            return string;
        }
        return DEFAULT_DOCKER_COMPOSE_VERSION;
    }

    private static void logDockerComposeVersionException(@NotNull String executable, @NotNull Exception e) {
        if (executable == null) {
            DockerComposeProjectService.$$$reportNull$$$0(1);
        }
        if (e == null) {
            DockerComposeProjectService.$$$reportNull$$$0(2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to get Docker Compose version using \"" + executable + "\" executable", (Throwable)e);
        } else {
            LOG.info("Unable to get Docker Compose version using \"" + executable + "\" executable. " + e.getMessage());
        }
    }

    @NotNull
    public static DockerComposeProjectService getInstance() {
        DockerComposeProjectService dockerComposeProjectService = (DockerComposeProjectService)ApplicationManager.getApplication().getService(DockerComposeProjectService.class);
        if (dockerComposeProjectService == null) {
            DockerComposeProjectService.$$$reportNull$$$0(3);
        }
        return dockerComposeProjectService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/compose/DockerComposeProjectService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerComposeVersion";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/compose/DockerComposeProjectService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logDockerComposeVersionException";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

