/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.kubernetes;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000fH\u0002\u001a\b\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0012\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u001a\u0012\u0010\u0015\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\b\u0010\u0016\u001a\u00020\tH\u0002\u001a\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"IDE_CODES_FOR_PROMOTION", "", "", "KUBERNETES_FILES", "KUBERNETES_PLUGIN_ID", "KUBERNETES_PLUGIN_NAME", "KUBERNETES_SUGGESTION_ADD_MENU_DISMISSED_KEY", "KUBERNETES_SUGGESTION_DISMISSED_KEY", "computeKubernetesYaml", "", "file", "Lcom/intellij/psi/PsiFile;", "detectKubernetesResource", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "dismissPluginSuggestion", "", "isKubernetesDocument", "document", "Lorg/jetbrains/yaml/psi/YAMLDocument;", "isKubernetesYaml", "isPluginSuggestionDismissed", "getKeyValueByKeyIgnoreSpaces", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "keyText", "intellij.clouds.docker.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesSuggestionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesSuggestionProvider.kt\ncom/intellij/docker/kubernetes/KubernetesSuggestionProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n288#2,2:143\n*S KotlinDebug\n*F\n+ 1 KubernetesSuggestionProvider.kt\ncom/intellij/docker/kubernetes/KubernetesSuggestionProviderKt\n*L\n141#1:143,2\n*E\n"})
public final class KubernetesSuggestionProviderKt {
    @NotNull
    public static final String KUBERNETES_PLUGIN_ID = "com.intellij.kubernetes";
    @NotNull
    private static final String KUBERNETES_PLUGIN_NAME = "Kubernetes";
    @NotNull
    private static final String KUBERNETES_FILES = "Kubernetes";
    @NotNull
    private static final String KUBERNETES_SUGGESTION_DISMISSED_KEY = "promo.kubernetes.suggestion.dismissed";
    @NotNull
    public static final String KUBERNETES_SUGGESTION_ADD_MENU_DISMISSED_KEY = "promo.kubernetes.suggestion.dummy.node.dismissed";
    @NotNull
    private static final Set<String> IDE_CODES_FOR_PROMOTION;

    private static final void dismissPluginSuggestion() {
        PropertiesComponent.getInstance().setValue(KUBERNETES_SUGGESTION_DISMISSED_KEY, true);
    }

    private static final boolean isPluginSuggestionDismissed() {
        return PropertiesComponent.getInstance().isTrueValue(KUBERNETES_SUGGESTION_DISMISSED_KEY);
    }

    private static final boolean detectKubernetesResource(Project project, VirtualFile file2) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        return KubernetesSuggestionProviderKt.isKubernetesYaml(psiFile);
    }

    private static final boolean isKubernetesYaml(PsiFile file2) {
        if (!(file2 instanceof YAMLFile)) {
            return false;
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file2), () -> KubernetesSuggestionProviderKt.isKubernetesYaml$lambda$0(file2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean computeKubernetesYaml(PsiFile file2) {
        if (!(file2 instanceof YAMLFile)) return false;
        List list2 = ((YAMLFile)file2).getDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDocuments(...)");
        if (!KubernetesSuggestionProviderKt.isKubernetesDocument((YAMLDocument)CollectionsKt.firstOrNull((List)list2))) return false;
        return true;
    }

    private static final boolean isKubernetesDocument(YAMLDocument document) {
        YAMLDocument yAMLDocument = document;
        YAMLValue yAMLValue = yAMLDocument != null ? yAMLDocument.getTopLevelValue() : null;
        YAMLMapping yAMLMapping = yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null;
        if (yAMLMapping == null) {
            return false;
        }
        YAMLMapping topMapping = yAMLMapping;
        YAMLKeyValue kindKeyVal = KubernetesSuggestionProviderKt.getKeyValueByKeyIgnoreSpaces(topMapping, "kind");
        YAMLKeyValue apiVersionKeyVal = KubernetesSuggestionProviderKt.getKeyValueByKeyIgnoreSpaces(topMapping, "apiVersion");
        return kindKeyVal != null && apiVersionKeyVal != null;
    }

    private static final YAMLKeyValue getKeyValueByKeyIgnoreSpaces(YAMLMapping $this$getKeyValueByKeyIgnoreSpaces, String keyText) {
        Object v2;
        block1: {
            Collection collection = $this$getKeyValueByKeyIgnoreSpaces.getKeyValues();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeyValues(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                YAMLKeyValue it = (YAMLKeyValue)element$iv;
                boolean bl = false;
                String string = it.getKeyText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeyText(...)");
                if (!(keyText.compareTo(((Object)StringsKt.trim((CharSequence)string)).toString()) == 0)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private static final CachedValueProvider.Result isKubernetesYaml$lambda$0(PsiFile $file) {
        Object[] objectArray = new Object[]{$file};
        return new CachedValueProvider.Result((Object)KubernetesSuggestionProviderKt.computeKubernetesYaml($file), objectArray);
    }

    public static final /* synthetic */ boolean access$isPluginSuggestionDismissed() {
        return KubernetesSuggestionProviderKt.isPluginSuggestionDismissed();
    }

    public static final /* synthetic */ Set access$getIDE_CODES_FOR_PROMOTION$p() {
        return IDE_CODES_FOR_PROMOTION;
    }

    public static final /* synthetic */ boolean access$detectKubernetesResource(Project project, VirtualFile file2) {
        return KubernetesSuggestionProviderKt.detectKubernetesResource(project, file2);
    }

    public static final /* synthetic */ void access$dismissPluginSuggestion() {
        KubernetesSuggestionProviderKt.dismissPluginSuggestion();
    }

    static {
        Object[] objectArray = new String[]{"WS", "RM", "PY", "PS", "GO", "CL", "RD", "IU", "IC", "PC", "AS"};
        IDE_CODES_FOR_PROMOTION = SetsKt.setOf((Object[])objectArray);
    }
}

