/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.docker.dockerFile.inspections.DockerFileInspectorBase;
import com.intellij.docker.dockerFile.parser.psi.DockerFileAnyValue;
import com.intellij.docker.dockerFile.parser.psi.DockerFileArgDeclaration;
import com.intellij.docker.dockerFile.parser.psi.DockerFileEnvRegularDeclaration;
import com.intellij.docker.dockerFile.parser.psi.DockerFileLabelCommand;
import com.intellij.docker.dockerFile.parser.psi.DockerFileLabelDef;
import com.intellij.docker.dockerFile.parser.psi.DockerFileRegularValue;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerFileAssignmentsInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DockerFileAssignmentsInspection.$$$reportNull$$$0(0);
        }
        if (holder.getFile() instanceof DockerPsiFile) {
            return new AssignmentsInspector(holder, isOnTheFly);
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            DockerFileAssignmentsInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/dockerFile/inspections/DockerFileAssignmentsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/dockerFile/inspections/DockerFileAssignmentsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class AssignmentsInspector
    extends DockerFileInspectorBase {
        AssignmentsInspector(@NotNull ProblemsHolder problemsHolder, boolean isOnTheFly) {
            if (problemsHolder == null) {
                AssignmentsInspector.$$$reportNull$$$0(0);
            }
            super(problemsHolder, isOnTheFly);
        }

        @Override
        public void visitArgDeclaration(@NotNull DockerFileArgDeclaration argDeclaration) {
            DockerFileAnyValue optionalValue;
            if (argDeclaration == null) {
                AssignmentsInspector.$$$reportNull$$$0(1);
            }
            if ((optionalValue = argDeclaration.getAnyValue()) == null) {
                return;
            }
            List<PsiWhiteSpace> rightSideSpaces = AssignmentsInspector.collectSpacesBefore((PsiElement)optionalValue);
            List<PsiWhiteSpace> leftSideSpaces = AssignmentsInspector.collectSpacesAfter(argDeclaration.getDeclaredName());
            if (rightSideSpaces.isEmpty() || leftSideSpaces.isEmpty()) {
                this.requireNoSpaces(leftSideSpaces);
                this.requireNoSpaces(rightSideSpaces);
            } else {
                ArrayList<PsiWhiteSpace> all = new ArrayList<PsiWhiteSpace>();
                all.addAll(leftSideSpaces);
                all.addAll(rightSideSpaces);
                this.requireNoSpaces(all);
            }
        }

        @Override
        public void visitEnvRegularDeclaration(@NotNull DockerFileEnvRegularDeclaration declaration) {
            DockerFileRegularValue value;
            if (declaration == null) {
                AssignmentsInspector.$$$reportNull$$$0(2);
            }
            if ((value = declaration.getRegularValue()) == null) {
                return;
            }
            List<PsiWhiteSpace> leftSideSpaces = AssignmentsInspector.collectSpacesAfter(declaration.getDeclaredName());
            List<PsiWhiteSpace> rightSideSpaces = AssignmentsInspector.collectSpacesBefore((PsiElement)value);
            if (leftSideSpaces.isEmpty()) {
                this.requireNoSpaces(rightSideSpaces);
            }
        }

        @Override
        public void visitLabelDef(@NotNull DockerFileLabelDef labelDef) {
            if (labelDef == null) {
                AssignmentsInspector.$$$reportNull$$$0(3);
            }
            if (!AssignmentsInspector.isFirstDefInCommand(labelDef)) {
                return;
            }
            List<PsiWhiteSpace> leftSideSpaces = AssignmentsInspector.collectSpacesBefore(labelDef.getAssign());
            List<PsiWhiteSpace> rightSideSpaces = AssignmentsInspector.collectSpacesAfter(labelDef.getAssign());
            if (leftSideSpaces.isEmpty()) {
                this.requireNoSpaces(rightSideSpaces);
            }
        }

        private static boolean isFirstDefInCommand(@NotNull DockerFileLabelDef labelDef) {
            DockerFileLabelCommand command;
            if (labelDef == null) {
                AssignmentsInspector.$$$reportNull$$$0(4);
            }
            return (command = (DockerFileLabelCommand)PsiTreeUtil.getParentOfType((PsiElement)labelDef, DockerFileLabelCommand.class)) != null && command.getLabelDefList().indexOf(labelDef) == 0;
        }

        private void requireNoSpaces(@NotNull List<PsiWhiteSpace> spaces) {
            if (spaces == null) {
                AssignmentsInspector.$$$reportNull$$$0(5);
            }
            if (ContainerUtil.exists(spaces, ws -> ws.getTextLength() > 0)) {
                this.registerProblem(spaces, DockerBundle.message("DockerFileAssignmentsInspection.error.spacing.not.allowed", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new RemoveSpacesQuickFix(spaces));
            }
        }

        @NotNull
        private static List<PsiWhiteSpace> collectSpacesAfter(@NotNull PsiElement anchor) {
            if (anchor == null) {
                AssignmentsInspector.$$$reportNull$$$0(6);
            }
            SmartList result2 = new SmartList();
            PsiElement next2 = anchor.getNextSibling();
            while (next2 instanceof PsiWhiteSpace) {
                result2.add((Object)((PsiWhiteSpace)next2));
                next2 = next2.getNextSibling();
            }
            SmartList smartList = result2;
            if (smartList == null) {
                AssignmentsInspector.$$$reportNull$$$0(7);
            }
            return smartList;
        }

        @NotNull
        private static List<PsiWhiteSpace> collectSpacesBefore(PsiElement anchor) {
            SmartList result2 = new SmartList();
            PsiElement next2 = anchor.getPrevSibling();
            while (next2 instanceof PsiWhiteSpace) {
                result2.add(0, (Object)((PsiWhiteSpace)next2));
                next2 = next2.getPrevSibling();
            }
            SmartList smartList = result2;
            if (smartList == null) {
                AssignmentsInspector.$$$reportNull$$$0(8);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemsHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argDeclaration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "labelDef";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "spaces";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/dockerFile/inspections/DockerFileAssignmentsInspection$AssignmentsInspector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/dockerFile/inspections/DockerFileAssignmentsInspection$AssignmentsInspector";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectSpacesAfter";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectSpacesBefore";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitArgDeclaration";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitEnvRegularDeclaration";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLabelDef";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isFirstDefInCommand";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "requireNoSpaces";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSpacesAfter";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    private static class RemoveSpacesQuickFix
    implements LocalQuickFix {
        private final List<PsiWhiteSpace> mySpaces;

        private RemoveSpacesQuickFix(List<PsiWhiteSpace> spaces) {
            this.mySpaces = spaces;
        }

        @NotNull
        public String getName() {
            String string = DockerBundle.message("DockerFileAssignmentsInspection.remove.spaces", new Object[0]);
            if (string == null) {
                RemoveSpacesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                RemoveSpacesQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                RemoveSpacesQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                RemoveSpacesQuickFix.$$$reportNull$$$0(3);
            }
            this.mySpaces.forEach(PsiElement::delete);
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target2) {
            if (target2 == null) {
                RemoveSpacesQuickFix.$$$reportNull$$$0(4);
            }
            return new RemoveSpacesQuickFix(ContainerUtil.map(this.mySpaces, e -> (PsiWhiteSpace)PsiTreeUtil.findSameElementInCopy((PsiElement)e, (PsiFile)target2)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/dockerFile/inspections/DockerFileAssignmentsInspection$RemoveSpacesQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/dockerFile/inspections/DockerFileAssignmentsInspection$RemoveSpacesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileModifierForPreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

