/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.docker.dockerFile.inspections.DockerFileInspectorBase;
import com.intellij.docker.dockerFile.parser.psi.DockerFileAddOrCopyCommand;
import com.intellij.docker.dockerFile.parser.psi.DockerFileArgCommand;
import com.intellij.docker.dockerFile.parser.psi.DockerFileArgDeclaration;
import com.intellij.docker.dockerFile.parser.psi.DockerFileFileOrUrl;
import com.intellij.docker.dockerFile.parser.psi.DockerFileFromCommand;
import com.intellij.docker.dockerFile.parser.psi.DockerFileParametersInJsonForm;
import com.intellij.docker.dockerFile.parser.psi.DockerFileStopSignalCommand;
import com.intellij.docker.dockerFile.parser.psi.DockerFileStringLiteral;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class DockerFileArgumentCountInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DockerFileArgumentCountInspection.$$$reportNull$$$0(0);
        }
        if (holder.getFile() instanceof DockerPsiFile) {
            return new ArgumentCountInspector(holder, isOnTheFly);
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            DockerFileArgumentCountInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/dockerFile/inspections/DockerFileArgumentCountInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/dockerFile/inspections/DockerFileArgumentCountInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class ArgumentCountInspector
    extends DockerFileInspectorBase {
        ArgumentCountInspector(@NotNull ProblemsHolder problemsHolder, boolean isOnTheFly) {
            if (problemsHolder == null) {
                ArgumentCountInspector.$$$reportNull$$$0(0);
            }
            super(problemsHolder, isOnTheFly);
        }

        @Override
        public void visitFromCommand(@NotNull DockerFileFromCommand cmd) {
            if (cmd == null) {
                ArgumentCountInspector.$$$reportNull$$$0(1);
            }
            if (PsiTreeUtil.hasErrorElements((PsiElement)cmd)) {
                return;
            }
            this.requireAtMaxOneWord(cmd.getNameChainList());
        }

        @Override
        public void visitAddOrCopyCommand(@NotNull DockerFileAddOrCopyCommand cmd) {
            if (cmd == null) {
                ArgumentCountInspector.$$$reportNull$$$0(2);
            }
            if (PsiTreeUtil.hasErrorElements((PsiElement)cmd)) {
                return;
            }
            if (cmd.getHeredoc() != null) {
                return;
            }
            DockerFileParametersInJsonForm jsonForm = cmd.getParametersInJsonForm();
            if (jsonForm != null) {
                List<DockerFileStringLiteral> literals = jsonForm.getStringLiteralList();
                PsiElement leftBracket = jsonForm.getFirstChild();
                this.requireAtLeastN(2, literals, leftBracket, false);
            } else {
                List<DockerFileFileOrUrl> uris = cmd.getFileOrUrlList();
                PsiElement keyword = Optional.ofNullable(cmd.getAddKeyword()).orElse(cmd.getCopyKeyword());
                this.requireAtLeastN(2, uris, keyword, true);
            }
        }

        @Override
        public void visitArgCommand(@NotNull DockerFileArgCommand cmd) {
            if (cmd == null) {
                ArgumentCountInspector.$$$reportNull$$$0(3);
            }
            if (PsiTreeUtil.hasErrorElements((PsiElement)cmd)) {
                return;
            }
            List valueTokens = Optional.ofNullable(cmd.getArgDeclaration()).map(DockerFileArgDeclaration::getAnyValue).map(v -> PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)v, PsiElement.class)).orElse(Collections.emptyList());
            this.requireAtMaxOneWord(valueTokens);
        }

        @Override
        public void visitStopSignalCommand(@NotNull DockerFileStopSignalCommand cmd) {
            if (cmd == null) {
                ArgumentCountInspector.$$$reportNull$$$0(4);
            }
            if (PsiTreeUtil.hasErrorElements((PsiElement)cmd)) {
                return;
            }
            LinkedList<PsiElement> tokensAfterKeyword = new LinkedList<PsiElement>();
            PsiElement last = PsiTreeUtil.getDeepestLast((PsiElement)cmd);
            PsiElement next2 = PsiTreeUtil.nextLeaf((PsiElement)cmd.getKeyword());
            while (next2 != null) {
                tokensAfterKeyword.add(next2);
                if (next2 == last) break;
                next2 = PsiTreeUtil.nextLeaf((PsiElement)next2);
            }
            this.requireAtMaxOneWord(tokensAfterKeyword);
        }

        private void requireAtMaxOneWord(List<? extends PsiElement> tokens) {
            List<List<PsiElement>> words = ArgumentCountInspector.separateWords(tokens);
            if (words.size() > 1) {
                List<PsiElement> firstBad = words.get(1);
                this.registerProblem(firstBad, DockerBundle.message("DockerFileArgumentCountInspection.error.exactly.one.argument.required", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }

        private void requireAtLeastN(int expectedAtLeast, List<? extends PsiElement> args, PsiElement highlightWhenNoArgs, boolean forceAtEOL) {
            PsiElement lastGood;
            if (args.size() >= expectedAtLeast) {
                return;
            }
            PsiElement psiElement = lastGood = args.isEmpty() ? highlightWhenNoArgs : args.get(args.size() - 1);
            if (lastGood == null) {
                return;
            }
            this.reportNotEnoughArguments(lastGood, expectedAtLeast, forceAtEOL);
        }

        private void reportNotEnoughArguments(@NotNull PsiElement lastGood, int expectedAtLeast, boolean forceAtEOL) {
            if (lastGood == null) {
                ArgumentCountInspector.$$$reportNull$$$0(5);
            }
            @Nls String message = DockerBundle.message("DockerFileArgumentCountInspection.error.at.least.N.arguments.required", expectedAtLeast);
            if (forceAtEOL) {
                ProblemDescriptor error = this.myHolder.getManager().createProblemDescriptor(lastGood, message, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, true);
                this.myHolder.registerProblem(error);
                return;
            }
            PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)lastGood);
            this.myHolder.registerProblem(nextLeaf == null || nextLeaf instanceof PsiWhiteSpace && nextLeaf.getText().contains("\n") ? lastGood : nextLeaf, message, new LocalQuickFix[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemsHolder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cmd";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lastGood";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/dockerFile/inspections/DockerFileArgumentCountInspection$ArgumentCountInspector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFromCommand";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAddOrCopyCommand";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArgCommand";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitStopSignalCommand";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reportNotEnoughArguments";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

