/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile;

import com.intellij.docker.dockerFile.DockerFileType;
import com.intellij.docker.dockerFile.DockerFileTypeDetector;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/dockerFile/DockerFileTypeDetector;", "Lcom/intellij/openapi/fileTypes/FileTypeRegistry$FileTypeDetector;", "()V", "DOCKER_KEYWORDS", "", "", "getDOCKER_KEYWORDS", "()Ljava/util/Set;", "DOCKER_KEYWORDS$delegate", "Lkotlin/Lazy;", "LINE_BREAK", "Ljava/util/regex/Pattern;", "detect", "Lcom/intellij/openapi/fileTypes/FileType;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "firstBytes", "Lcom/intellij/openapi/util/io/ByteSequence;", "firstCharsIfText", "", "intellij.clouds.docker.file"})
@SourceDebugExtension(value={"SMAP\nDockerFileTypeDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerFileTypeDetector.kt\ncom/intellij/docker/dockerFile/DockerFileTypeDetector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,56:1\n1224#2,2:57\n*S KotlinDebug\n*F\n+ 1 DockerFileTypeDetector.kt\ncom/intellij/docker/dockerFile/DockerFileTypeDetector\n*L\n50#1:57,2\n*E\n"})
public final class DockerFileTypeDetector
implements FileTypeRegistry.FileTypeDetector {
    @NotNull
    private final Pattern LINE_BREAK;
    @NotNull
    private final Lazy DOCKER_KEYWORDS$delegate;

    public DockerFileTypeDetector() {
        Pattern pattern = Pattern.compile("\\R");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.LINE_BREAK = pattern;
        this.DOCKER_KEYWORDS$delegate = LazyKt.lazy((Function0)DOCKER_KEYWORDS.2.INSTANCE);
    }

    private final Set<String> getDOCKER_KEYWORDS() {
        Lazy lazy = this.DOCKER_KEYWORDS$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Set)object;
    }

    @Nullable
    public FileType detect(@NotNull VirtualFile file2, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)firstBytes, (String)"firstBytes");
            if (DockerFileType.DOCKER_FILE_TYPE.isMyFileType(file2)) {
                return DockerFileType.DOCKER_FILE_TYPE;
            }
            CharSequence charSequence = file2.getExtension();
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                return null;
            }
            if (Intrinsics.areEqual((Object)file2.getName(), (Object)"LICENSE")) {
                return null;
            }
            if (Intrinsics.areEqual((Object)file2.getFileSystem().getProtocol(), (Object)"jrt")) {
                return null;
            }
            CharSequence charSequence2 = firstCharsIfText;
            if (charSequence2 == null || (charSequence2 = charSequence2.subSequence(0, Math.min(firstCharsIfText.length(), this.getDesiredContentPrefixLength()))) == null) {
                return null;
            }
            CharSequence content2 = charSequence2;
            if (StringsKt.isBlank((CharSequence)content2)) {
                return null;
            }
            Iterator linesIterator2 = this.LINE_BREAK.splitAsStream(content2).filter(arg_0 -> DockerFileTypeDetector.detect$lambda$0(detect.linesIterator.1.INSTANCE, arg_0)).iterator();
            if (!linesIterator2.hasNext()) {
                return null;
            }
            Intrinsics.checkNotNull(linesIterator2);
            Sequence $this$all$iv = SequencesKt.asSequence(linesIterator2);
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                Set<String> set = this.getDOCKER_KEYWORDS();
                Intrinsics.checkNotNull((Object)it);
                if (set.contains(StringsKt.substringBefore$default((String)it, (String)" ", null, (int)2, null))) continue;
                bl = false;
                break block8;
            }
            bl = true;
        }
        return bl ? (FileType)DockerFileType.DOCKER_FILE_TYPE : null;
    }

    private static final boolean detect$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

