/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile;

import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.docker.dockerFile.parser.psi.DockerFileFromCommand;
import com.intellij.docker.dockerFile.parser.psi.DockerFileRunCommand;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiCommand;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J.\u0010\n\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u001e\u0010\u0011\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u0012\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u001a\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/docker/dockerFile/DockerFileFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "()V", "buildCommentBlocks", "", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "dockerFile", "Lcom/intellij/docker/dockerFile/DockerPsiFile;", "buildLanguageFoldRegions", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "buildRunCommands", "buildStageBlocks", "findFirstNonTrivialCommentText", "", "comment", "Lcom/intellij/psi/PsiComment;", "range", "Lcom/intellij/openapi/util/TextRange;", "getLanguagePlaceholderText", "node", "Lcom/intellij/lang/ASTNode;", "isRegionCollapsedByDefault", "rangeBetween", "start", "end", "Companion", "intellij.clouds.docker.file"})
@SourceDebugExtension(value={"SMAP\nDockerFileFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerFileFoldingBuilder.kt\ncom/intellij/docker/dockerFile/DockerFileFoldingBuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n4098#2,11:126\n4098#2,11:139\n1855#3,2:137\n800#3,11:150\n1855#3,2:161\n*S KotlinDebug\n*F\n+ 1 DockerFileFoldingBuilder.kt\ncom/intellij/docker/dockerFile/DockerFileFoldingBuilder\n*L\n52#1:126,11\n60#1:139,11\n54#1:137,2\n61#1:150,11\n65#1:161,2\n*E\n"})
public final class DockerFileFoldingBuilder
extends CustomFoldingBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_PLACEHOLDER_LEN = 80;
    @NotNull
    private static final String ELLIPSIS = " ...";

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        DockerPsiFile dockerPsiFile = root instanceof DockerPsiFile ? (DockerPsiFile)root : null;
        if (dockerPsiFile == null) {
            return;
        }
        DockerPsiFile dockerFile = dockerPsiFile;
        if (dockerFile.isContentsLoaded()) {
            this.buildCommentBlocks(descriptors, dockerFile);
            this.buildRunCommands(descriptors, dockerFile);
            this.buildStageBlocks(descriptors, dockerFile);
        }
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return false;
    }

    private final void buildCommentBlocks(List<FoldingDescriptor> descriptors, DockerPsiFile dockerFile) {
        PsiComment blockStart = null;
        for (PsiElement next2 = dockerFile.getFirstChild(); next2 != null; next2 = next2.getNextSibling()) {
            PsiElement psiElement = next2;
            if (psiElement instanceof DockerPsiCommand) {
                blockStart = null;
                continue;
            }
            if (!(psiElement instanceof PsiComment)) continue;
            String string = ((PsiComment)next2).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (!StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)"##", (boolean)false, (int)2, null)) continue;
            if (blockStart == null) {
                blockStart = (PsiComment)next2;
                continue;
            }
            descriptors.add(new FoldingDescriptor((PsiElement)dockerFile, this.rangeBetween((PsiElement)blockStart, next2)));
            blockStart = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildRunCommands(List<FoldingDescriptor> descriptors, DockerPsiFile dockerFile) {
        void $this$filterIsInstanceTo$iv$iv;
        PsiElement[] psiElementArray = dockerFile.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object[] $this$filterIsInstance$iv = psiElementArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof DockerFileRunCommand)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List commands = (List)destination$iv$iv;
        Iterable $this$forEach$iv = commands;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DockerFileRunCommand it = (DockerFileRunCommand)element$iv;
            boolean bl = false;
            descriptors.add(new FoldingDescriptor((PsiElement)dockerFile, it.getTextRange()));
        }
    }

    private final void buildStageBlocks(List<FoldingDescriptor> descriptors, DockerPsiFile dockerFile) {
        block6: {
            Object $this$filterIsInstanceTo$iv$iv;
            PsiElement[] psiElementArray = dockerFile.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object $this$filterIsInstance$iv = psiElementArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DockerPsiCommand)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List commands = (List)destination$iv$iv;
            $this$filterIsInstance$iv = commands;
            $i$f$filterIsInstance = false;
            $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                if (!(element$iv$iv instanceof DockerFileFromCommand)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            if (((List)destination$iv$iv).size() <= 1) {
                return;
            }
            DockerPsiCommand blockStart = null;
            DockerPsiCommand lastCommand = null;
            Iterable $this$forEach$iv = commands;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DockerPsiCommand next2 = (DockerPsiCommand)element$iv;
                boolean bl = false;
                if (next2 instanceof DockerFileFromCommand) {
                    if (blockStart != null) {
                        descriptors.add(new FoldingDescriptor((PsiElement)dockerFile, this.rangeBetween(blockStart, lastCommand)));
                    }
                    blockStart = next2;
                }
                lastCommand = next2;
            }
            DockerFileFromCommand dockerFileFromCommand = (DockerFileFromCommand)blockStart;
            if (dockerFileFromCommand == null) break block6;
            DockerFileFromCommand it = dockerFileFromCommand;
            boolean bl = false;
            descriptors.add(new FoldingDescriptor((PsiElement)dockerFile, this.rangeBetween(it, lastCommand)));
        }
    }

    private final TextRange rangeBetween(PsiElement start2, PsiElement end) {
        int n = start2.getTextRange().getStartOffset();
        PsiElement psiElement = end;
        if (psiElement == null) {
            psiElement = start2;
        }
        return new TextRange(n, psiElement.getTextRange().getEndOffset());
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        PsiElement psiElement = node.getPsi();
        DockerPsiFile dockerPsiFile = psiElement instanceof DockerPsiFile ? (DockerPsiFile)psiElement : null;
        if (dockerPsiFile == null) {
            return ELLIPSIS;
        }
        DockerPsiFile psiFile = dockerPsiFile;
        PsiComment firstCommentInBlock = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)((PsiFile)psiFile), (int)range.getStartOffset(), PsiComment.class, (boolean)false);
        if (firstCommentInBlock != null) {
            return DockerFileFoldingBuilder.Companion.limitLength(com.intellij.docker.dockerFile.DockerFileFoldingBuilder$Companion.ensurePrefix$default(DockerFileFoldingBuilder.Companion, this.findFirstNonTrivialCommentText(firstCommentInBlock, range), "#", null, 2, null)) + ELLIPSIS;
        }
        DockerFileFromCommand fromCommand = (DockerFileFromCommand)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)((PsiFile)psiFile), (int)range.getStartOffset(), DockerFileFromCommand.class, (boolean)false);
        if (fromCommand != null) {
            String string = fromCommand.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return DockerFileFoldingBuilder.Companion.limitLength(string) + ELLIPSIS;
        }
        DockerFileRunCommand runCommand = (DockerFileRunCommand)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)((PsiFile)psiFile), (int)range.getStartOffset(), DockerFileRunCommand.class, (boolean)false);
        if (runCommand != null) {
            String string = runCommand.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence charSequence = StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)DockerFileFoldingBuilder.Companion.limitLength(string))).toString(), (String)"\\\n", (String)"", (boolean)false, (int)4, null);
            Regex regex = new Regex("\\s+");
            String string2 = " ";
            return regex.replace(charSequence, string2) + ELLIPSIS;
        }
        return ELLIPSIS;
    }

    private final String findFirstNonTrivialCommentText(PsiComment comment, TextRange range) {
        PsiComment current = comment;
        while (current != null && PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)current)) < range.getEndOffset()) {
            String string = current.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            char[] cArray = new char[]{' ', '#'};
            String text2 = StringsKt.trim((String)string, (char[])cArray);
            if (!StringsKt.isBlank((CharSequence)text2)) {
                return text2;
            }
            current = (PsiComment)PsiTreeUtil.getNextSiblingOfType((PsiElement)((PsiElement)current), PsiComment.class);
        }
        String string = comment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0004H\u0002J\f\u0010\n\u001a\u00020\u0004*\u00020\u0004H\u0002J\u0014\u0010\n\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/dockerFile/DockerFileFoldingBuilder$Companion;", "", "()V", "ELLIPSIS", "", "MAX_PLACEHOLDER_LEN", "", "ensurePrefix", "prefix", "padding", "limitLength", "max", "intellij.clouds.docker.file"})
    public static final class Companion {
        private Companion() {
        }

        private final String limitLength(String $this$limitLength) {
            return this.limitLength($this$limitLength, 80);
        }

        private final String limitLength(String $this$limitLength, int max) {
            String string = $this$limitLength.substring(0, RangesKt.coerceAtMost((int)max, (int)$this$limitLength.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }

        private final String ensurePrefix(String $this$ensurePrefix, String prefix, String padding) {
            return StringsKt.startsWith$default((String)$this$ensurePrefix, (String)prefix, (boolean)false, (int)2, null) ? $this$ensurePrefix : prefix + padding + $this$ensurePrefix;
        }

        static /* synthetic */ String ensurePrefix$default(Companion companion, String string, String string2, String string3, int n, Object object) {
            if ((n & 2) != 0) {
                string3 = " ";
            }
            return companion.ensurePrefix(string, string2, string3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

