/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.text.StringKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u0004\u0018\u00010\u000b\u00a8\u0006\f"}, d2={"checkComposeFile", "", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "checkEnvFile", "checkProjectName", "checkTimeout", "toValidationInfo", "Lcom/intellij/openapi/ui/ValidationInfo;", "", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerComposeDeploymentValidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerComposeDeploymentValidation.kt\ncom/intellij/docker/deploymentSource/DockerComposeDeploymentValidationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
public final class DockerComposeDeploymentValidationKt {
    @Nullable
    public static final ValidationInfo toValidationInfo(@Nullable Throwable $this$toValidationInfo) {
        ValidationInfo validationInfo;
        Object object = $this$toValidationInfo;
        if (object != null && (object = ((Throwable)object).getMessage()) != null) {
            Object it = object;
            boolean bl = false;
            validationInfo = new ValidationInfo(DockerUiUtilsKt.asNlsSafe((String)it));
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    public static final void checkEnvFile(@NotNull DockerDeploymentConfiguration config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        String string = config2.getEnvFilePath();
        if (string == null || (string = StringKt.nullize((String)string, (boolean)true)) == null) {
            return;
        }
        String path = string;
        File file2 = new File(path);
        if (!file2.exists()) {
            Object[] objectArray = new Object[]{file2.getAbsolutePath()};
            throw new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.env.file.does.not.exist", objectArray));
        }
        if (file2.isDirectory()) {
            Object[] objectArray = new Object[]{file2.getAbsolutePath()};
            throw new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.env.file.not.valid", objectArray));
        }
    }

    public static final void checkTimeout(@NotNull DockerDeploymentConfiguration config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        String timeout = config2.getUpTimeout();
        if (StringsKt.isBlank((CharSequence)timeout)) {
            return;
        }
        if (StringsKt.toIntOrNull((String)timeout) == null) {
            Object[] objectArray = new Object[]{timeout};
            throw new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.up.timeout.dialog.message.not.valid.integer", objectArray));
        }
        if (Integer.parseInt(timeout) < 0) {
            throw new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.up.timeout.dialog.message.timeout.cannot.be.less", new Object[0]));
        }
        if (Integer.parseInt(timeout) > 1000) {
            throw new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.up.timeout.dialog.message.timeout.cannot.be.greater", new Object[0]));
        }
    }

    public static final void checkProjectName(@NotNull DockerDeploymentConfiguration config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        String projectName = config2.getComposeProjectName();
        if (StringsKt.isBlank((CharSequence)projectName)) {
            return;
        }
        if (!new Regex("([a-zA-Z_\\-0-9])+").matches((CharSequence)projectName)) {
            Object[] objectArray = new Object[]{projectName};
            throw new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentEditor.dialog.message.not.valid.project.name", objectArray));
        }
    }

    public static final void checkComposeFile(@NotNull Project project, @NotNull DockerDeploymentConfiguration config2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        File composeFile = DockerDeploymentConfigurationUtilsKt.getSourceFile(project, config2);
        if (composeFile == null) {
            throw new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentSourceType.error.path.required", new Object[0]));
        }
        if (!composeFile.exists() || !composeFile.isFile()) {
            Object[] objectArray = new Object[]{composeFile};
            throw new RuntimeConfigurationException(DockerBundle.message("DockerComposeDeploymentSourceType.error.file.does.not.exist", objectArray));
        }
    }
}

