/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.deployment.DockerRunConfig;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u000f2\u00020\u0001:\u0004\u000e\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H&\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "", "()V", "getPaths", "", "", "project", "Lcom/intellij/openapi/project/Project;", "dockerRunConfig", "Lcom/intellij/docker/deployment/DockerRunConfig;", "replacePath", "", "oldPath", "newPath", "BindMounts", "Companion", "MainSourceFile", "SecondaryComposeFiles", "intellij.clouds.docker"})
public abstract class DockerRunConfigurationPathHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ExtensionPointName<DockerRunConfigurationPathHandler> EP_NAME = ExtensionPointName.Companion.create("com.intellij.docker.runConfiguration.pathHandler");

    @NotNull
    public abstract List<String> getPaths(@NotNull Project var1, @NotNull DockerRunConfig var2);

    public abstract void replacePath(@NotNull Project var1, @NotNull DockerRunConfig var2, @NotNull String var3, @NotNull String var4);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler$BindMounts;", "Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "()V", "getPaths", "", "", "project", "Lcom/intellij/openapi/project/Project;", "dockerRunConfig", "Lcom/intellij/docker/deployment/DockerRunConfig;", "replacePath", "", "oldPath", "newPath", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerRunConfigurationPathHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunConfigurationPathHandler.kt\ncom/intellij/docker/deployment/DockerRunConfigurationPathHandler$BindMounts\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1603#2,9:110\n1855#2:119\n1856#2:121\n1612#2:122\n1#3:120\n*S KotlinDebug\n*F\n+ 1 DockerRunConfigurationPathHandler.kt\ncom/intellij/docker/deployment/DockerRunConfigurationPathHandler$BindMounts\n*L\n94#1:110,9\n94#1:119\n94#1:121\n94#1:122\n94#1:120\n*E\n"})
    public static final class BindMounts
    extends DockerRunConfigurationPathHandler {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<String> getPaths(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            List list2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
            List $this$getPaths_u24lambda_u241 = list2 = (List)new ArrayList();
            boolean bl = false;
            Iterable iterable = dockerRunConfig.getDeployment().getVolumeBindings();
            List list3 = $this$getPaths_u24lambda_u241;
            boolean $i$f$mapNotNull = false;
            void var9_9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                DockerVolumeBindingImpl it = (DockerVolumeBindingImpl)element$iv$iv;
                boolean bl3 = false;
                if (it.getHostPath() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list3.addAll((List)destination$iv$iv);
            Companion.iterateCliVolumes(dockerRunConfig.getDeployment(), (Function2<? super String, ? super Boolean, Unit>)((Function2)new Function2<String, Boolean, Unit>((List<String>)$this$getPaths_u24lambda_u241){
                final /* synthetic */ List<String> $this_apply;
                {
                    this.$this_apply = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull String param, boolean isVolume) {
                    Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                    if (isVolume && StringsKt.contains$default((CharSequence)param, (CharSequence)":", (boolean)false, (int)2, null)) {
                        UtilKt.addIfNotNull(this.$this_apply, (Object)StringsKt.substringBefore$default((String)param, (String)":", null, (int)2, null));
                    }
                }
            }));
            return list2;
        }

        @Override
        public void replacePath(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig, @NotNull String oldPath, @NotNull String newPath) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
            Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
            Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
            if (((CharSequence)newPath).length() > 0) {
                Companion.replaceMountedPath(dockerRunConfig.getDeployment(), oldPath, newPath);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J$\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000e0\u0011J\u001a\u0010\u0013\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "findDockerFile", "Ljava/io/File;", "Lcom/intellij/openapi/project/Project;", "path", "", "iterateCliVolumes", "", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "handler", "Lkotlin/Function2;", "", "replaceMountedPath", "oldPath", "newPath", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerRunConfigurationPathHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunConfigurationPathHandler.kt\ncom/intellij/docker/deployment/DockerRunConfigurationPathHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1855#2,2:110\n*S KotlinDebug\n*F\n+ 1 DockerRunConfigurationPathHandler.kt\ncom/intellij/docker/deployment/DockerRunConfigurationPathHandler$Companion\n*L\n24#1:110,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<DockerRunConfigurationPathHandler> getEP_NAME() {
            return EP_NAME;
        }

        public final void replaceMountedPath(@NotNull DockerDeploymentConfiguration $this$replaceMountedPath, @NotNull String oldPath, @NotNull String newPath) {
            Intrinsics.checkNotNullParameter((Object)$this$replaceMountedPath, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
            Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
            Iterable $this$forEach$iv = $this$replaceMountedPath.getVolumeBindings();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DockerVolumeBindingImpl it = (DockerVolumeBindingImpl)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getHostPath(), (Object)oldPath)) continue;
                it.setHostPath(newPath);
            }
            List newCli = new ArrayList();
            Ref.BooleanRef changed = new Ref.BooleanRef();
            this.iterateCliVolumes($this$replaceMountedPath, (Function2<? super String, ? super Boolean, Unit>)((Function2)new Function2<String, Boolean, Unit>(oldPath, (List<String>)newCli, newPath, changed){
                final /* synthetic */ String $oldPath;
                final /* synthetic */ List<String> $newCli;
                final /* synthetic */ String $newPath;
                final /* synthetic */ Ref.BooleanRef $changed;
                {
                    this.$oldPath = $oldPath;
                    this.$newCli = $newCli;
                    this.$newPath = $newPath;
                    this.$changed = $changed;
                    super(2);
                }

                public final void invoke(@NotNull String param, boolean isVolume) {
                    Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                    if (isVolume && StringsKt.startsWith$default((String)param, (String)this.$oldPath, (boolean)false, (int)2, null)) {
                        this.$newCli.add(StringsKt.replace$default((String)param, (String)this.$oldPath, (String)this.$newPath, (boolean)false, (int)4, null));
                        this.$changed.element = true;
                    } else {
                        this.$newCli.add(param);
                    }
                }
            }));
            if (changed.element) {
                $this$replaceMountedPath.setRunCliOptions(CollectionsKt.joinToString$default((Iterable)newCli, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
        }

        public final void iterateCliVolumes(@NotNull DockerDeploymentConfiguration $this$iterateCliVolumes, @NotNull Function2<? super String, ? super Boolean, Unit> handler2) {
            Intrinsics.checkNotNullParameter((Object)$this$iterateCliVolumes, (String)"<this>");
            Intrinsics.checkNotNullParameter(handler2, (String)"handler");
            String string = $this$iterateCliVolumes.getRunCliOptions();
            if (string == null) {
                return;
            }
            String cliOptions = string;
            boolean nextIsVolume = false;
            for (Object e : ParametersListUtil.parse((String)cliOptions)) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                String next2 = (String)e;
                handler2.invoke((Object)next2, (Object)nextIsVolume);
                nextIsVolume = Intrinsics.areEqual((Object)next2, (Object)"-v") || Intrinsics.areEqual((Object)next2, (Object)"--volume");
            }
        }

        private final File findDockerFile(Project $this$findDockerFile, String path) {
            return DockerDeploymentConfigurationUtilsKt.getSourceFile($this$findDockerFile, path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler$MainSourceFile;", "Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "()V", "getPaths", "", "", "project", "Lcom/intellij/openapi/project/Project;", "dockerRunConfig", "Lcom/intellij/docker/deployment/DockerRunConfig;", "replacePath", "", "oldPath", "newPath", "intellij.clouds.docker"})
    public static final class MainSourceFile
    extends DockerRunConfigurationPathHandler {
        @Override
        @NotNull
        public List<String> getPaths(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
            File file2 = Companion.findDockerFile(project, dockerRunConfig.getDeployment().getSourceFilePath());
            return CollectionsKt.listOfNotNull((Object)(file2 != null ? file2.getAbsolutePath() : null));
        }

        @Override
        public void replacePath(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig, @NotNull String oldPath, @NotNull String newPath) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
                Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
                Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
                if (!(!StringsKt.isBlank((CharSequence)newPath))) break block1;
                DockerDeploymentConfigurationUtilsKt.setSourceFile(project, dockerRunConfig.getDeployment(), new File(newPath));
                String string = DockerComposeDeploymentSourceType.getInstance().suggestConfigurationName(dockerRunConfig.getDeployment());
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    dockerRunConfig.getRunConfiguration().setName(it);
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler$SecondaryComposeFiles;", "Lcom/intellij/docker/deployment/DockerRunConfigurationPathHandler;", "()V", "getPaths", "", "", "project", "Lcom/intellij/openapi/project/Project;", "dockerRunConfig", "Lcom/intellij/docker/deployment/DockerRunConfig;", "replacePath", "", "oldPath", "newPath", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerRunConfigurationPathHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunConfigurationPathHandler.kt\ncom/intellij/docker/deployment/DockerRunConfigurationPathHandler$SecondaryComposeFiles\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1603#2,9:110\n1855#2:119\n1856#2:121\n1612#2:122\n1603#2,9:123\n1855#2:132\n1856#2:134\n1612#2:135\n1#3:120\n1#3:133\n*S KotlinDebug\n*F\n+ 1 DockerRunConfigurationPathHandler.kt\ncom/intellij/docker/deployment/DockerRunConfigurationPathHandler$SecondaryComposeFiles\n*L\n74#1:110,9\n74#1:119\n74#1:121\n74#1:122\n84#1:123,9\n84#1:132\n84#1:134\n84#1:135\n74#1:120\n84#1:133\n*E\n"})
    public static final class SecondaryComposeFiles
    extends DockerRunConfigurationPathHandler {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<String> getPaths(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
            Iterable $this$mapNotNull$iv = dockerRunConfig.getDeployment().getSecondarySourceFiles();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                File file2 = Companion.findDockerFile(project, it);
                if ((file2 != null ? file2.getAbsolutePath() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void replacePath(@NotNull Project project, @NotNull DockerRunConfig dockerRunConfig, @NotNull String oldPath, @NotNull String newPath) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dockerRunConfig, (String)"dockerRunConfig");
            Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
            Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
            if (StringsKt.isBlank((CharSequence)newPath)) {
                return;
            }
            DockerDeploymentConfiguration deployment = dockerRunConfig.getDeployment();
            List newFilesList = new ArrayList();
            UtilKt.addIfNotNull((List)newFilesList, (Object)DockerDeploymentConfigurationUtilsKt.getSourceFile(project, deployment));
            Iterable iterable = deployment.getSecondarySourceFiles();
            List list2 = newFilesList;
            boolean $i$f$mapNotNull = false;
            void var9_10 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                File it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if ((Intrinsics.areEqual((Object)it, (Object)oldPath) ? new File(newPath) : DockerDeploymentConfigurationUtilsKt.getSourceFile(project, it)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2.addAll((List)destination$iv$iv);
            DockerDeploymentConfigurationUtilsKt.setManySourceFiles(project, deployment, newFilesList);
        }
    }
}

