/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.docker.composeFile.ComposeFileUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtilRt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/composeFile/ComposeGeneratedFilesFilter;", "Lcom/intellij/openapi/roots/GeneratedSourcesFilter;", "()V", "isGeneratedSource", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "removeExtension", "", "fileName", "intellij.clouds.docker.compose"})
public final class ComposeGeneratedFilesFilter
extends GeneratedSourcesFilter {
    public boolean isGeneratedSource(@NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (file2.isDirectory() || !file2.isValid()) {
            return false;
        }
        String string = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)this.removeExtension(string), (String)"generated.override", (boolean)false, (int)2, null)) {
            return false;
        }
        Object object = ReadAction.compute(() -> ComposeGeneratedFilesFilter.isGeneratedSource$lambda$0(project, file2));
        YAMLFile yAMLFile = object instanceof YAMLFile ? (YAMLFile)object : null;
        if (yAMLFile == null) {
            return false;
        }
        YAMLFile psiFile = yAMLFile;
        return ComposeFileUtil.isDockerComposeYamlFile(psiFile);
    }

    private final String removeExtension(String fileName) {
        String string;
        String extension = PathUtilRt.getFileExtension((String)fileName);
        if (extension != null) {
            String string2 = fileName.substring(0, fileName.length() - (extension.length() + 1));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = fileName;
        }
        return string;
    }

    private static final PsiFile isGeneratedSource$lambda$0(Project $project, VirtualFile $file) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        return PsiManager.getInstance((Project)$project).findFile($file);
    }
}

