/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.service.commands;

import com.intellij.docker.agent.compose.beans.DockerComposeConfigurationBuilder;
import com.intellij.docker.agent.compose.cli.DockerComposeUpCliBuilder;
import com.intellij.docker.agent.util.DockerComposeUtilsKt;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ServiceCmdExecUtils;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.target.PtyOptions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposeServiceUpCmd
extends AbstractServiceCmd<ComposeServiceUpCmd> {
    @Nullable
    private List<String> myServiceNames;
    @Nullable
    private PtyOptions myPtyOptions;
    private boolean myNoDeps;

    public ComposeServiceUpCmd(@NotNull RemoteDockerRuntime dockerRuntime2) {
        if (dockerRuntime2 == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(0);
        }
        super(dockerRuntime2);
        this.myNoDeps = false;
    }

    @Override
    @NotNull
    public KillableColoredProcessHandler execute() throws IOException, ExecutionException {
        KillableColoredProcessHandler killableColoredProcessHandler = DockerComposeCliUtil.run(this.createBuilder(), this.getDockerRuntime(), ProgressManager.getInstance().getProgressIndicator());
        if (killableColoredProcessHandler == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(1);
        }
        return killableColoredProcessHandler;
    }

    @Override
    @NotNull
    public GeneralCommandLine buildCommandLine() throws IOException {
        GeneralCommandLine generalCommandLine = DockerComposeCliUtil.buildCommandLine(this.createBuilder());
        if (generalCommandLine == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(2);
        }
        return generalCommandLine;
    }

    @NotNull
    private DockerComposeUpCliBuilder createBuilder() throws IOException {
        if (ContainerUtil.isEmpty(this.getConfigurationPaths())) {
            throw new IllegalArgumentException(DockerBundle.message("ComposeServiceUpCmd.error.path.required", new Object[0]));
        }
        if (StringUtil.isEmpty((String)this.getServiceName())) {
            throw new IllegalArgumentException(DockerBundle.message("ComposeServiceUpCmd.error.service.required", new Object[0]));
        }
        List<Path> paths = DockerComposeUtilsKt.findDockerComposeConfigurationFiles(this.getConfigurationPaths());
        Set<String> namedVolumes = ServiceCmdExecUtils.collectNamedVolumes(this.getVolumesBinding());
        DockerComposeConfigurationBuilder<?, ?, ?> configurationBuilder = ServiceCmdExecUtils.createConfigurationBuilder(paths, namedVolumes, this.getDockerRuntime().getAccount());
        if (!ArrayUtil.isEmpty((Object[])this.getVolumesFrom())) {
            ServiceCmdExecUtils.assertVolumesFromOptionSupported(configurationBuilder);
        }
        Object serviceBuilder = configurationBuilder.addService(this.getServiceName());
        String[] entrypoint2 = this.getEntrypoint();
        if (entrypoint2 != null) {
            serviceBuilder.withEntrypoint(entrypoint2);
        }
        serviceBuilder.withCommand(DockerComposeUtilsKt.escapeDollarSigns(this.getCommand())).withWorkingDir(this.getWorkingDir()).withEnvironment(DockerComposeUtilsKt.escapeDollarSigns(this.getEnvironment())).withVolumesFrom(this.getVolumesFrom()).withBindVolumes(this.getVolumesBinding()).withPorts(this.getPorts()).withUser(this.getUser()).withExtraHosts(this.getExtraHosts()).withRestartPolicy(this.getRestartPolicy()).withStdinOpen(true);
        ServiceCmdExecUtils.setupSharedVolume(configurationBuilder, serviceBuilder, this, paths, this.getVolumesBinding());
        Object override = configurationBuilder.build();
        File tempFile = ServiceCmdExecUtils.writeDockerComposeOverrideYml(override);
        List list2 = ContainerUtil.append(paths, (Object[])new Path[]{tempFile.toPath()});
        DockerComposeUpCliBuilder builder = (DockerComposeUpCliBuilder)((DockerComposeUpCliBuilder)((DockerComposeUpCliBuilder)((DockerComposeUpCliBuilder)DockerComposeCliUtil.buildUpCommand(this.getDockerRuntime().getAccount()).withEnvironment(this.getEnvs())).withFiles(list2)).withSubcommandOptions(this.getSubcommandOptions())).withServices(this.getEffectiveServices()).withDetached(this.isDetached()).withNoDeps(this.myNoDeps).withPtyOptions(DockerComposeCliUtil.toDockerComposePtyOptions(this.myPtyOptions)).withProjectName(this.getProjectName());
        if (this.getSubcommandOptions() == null && !this.isDetached()) {
            builder.withExitCodeFrom(this.getServiceName());
        }
        DockerComposeUpCliBuilder dockerComposeUpCliBuilder = builder;
        if (dockerComposeUpCliBuilder == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(3);
        }
        return dockerComposeUpCliBuilder;
    }

    private String @NotNull [] getEffectiveServices() {
        List<String> serviceNames = this.getServiceNames();
        if (serviceNames == null) {
            String[] stringArray = new String[]{this.getServiceName()};
            if (stringArray == null) {
                ComposeServiceUpCmd.$$$reportNull$$$0(4);
            }
            return stringArray;
        }
        String[] stringArray = ArrayUtilRt.toStringArray(serviceNames);
        if (stringArray == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @Override
    @NotNull
    protected ComposeServiceUpCmd getThis() {
        ComposeServiceUpCmd composeServiceUpCmd = this;
        if (composeServiceUpCmd == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(6);
        }
        return composeServiceUpCmd;
    }

    @Nullable
    public List<String> getServiceNames() {
        return this.myServiceNames;
    }

    @NotNull
    public ComposeServiceUpCmd withServiceNames(@Nullable List<String> serviceNames) {
        this.myServiceNames = serviceNames;
        ComposeServiceUpCmd composeServiceUpCmd = this.getThis();
        if (composeServiceUpCmd == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(7);
        }
        return composeServiceUpCmd;
    }

    @NotNull
    public ComposeServiceUpCmd withPtyOptions(@Nullable PtyOptions ptyOptions) {
        this.myPtyOptions = ptyOptions;
        ComposeServiceUpCmd composeServiceUpCmd = this;
        if (composeServiceUpCmd == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(8);
        }
        return composeServiceUpCmd;
    }

    @NotNull
    public ComposeServiceUpCmd withNoDeps(boolean isNoDeps) {
        this.myNoDeps = isNoDeps;
        ComposeServiceUpCmd composeServiceUpCmd = this;
        if (composeServiceUpCmd == null) {
            ComposeServiceUpCmd.$$$reportNull$$$0(9);
        }
        return composeServiceUpCmd;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/service/commands/ComposeServiceUpCmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/service/commands/ComposeServiceUpCmd";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommandLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveServices";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getThis";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withServiceNames";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withPtyOptions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withNoDeps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

