/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.parse;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerComposeConfigurationParserUtil {
    static final Pattern VERSION_PATTERN = Pattern.compile("(?<major>\\d+)(\\.\\d+)?");

    @Nullable
    public static String getMajorVersion(@NotNull String version2) {
        Matcher matcher;
        if (version2 == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(0);
        }
        return (matcher = VERSION_PATTERN.matcher(version2)).matches() ? matcher.group("major") : null;
    }

    public static void saveDockerComposeFiles(@NotNull List<String> dockerComposeFilePaths) {
        if (dockerComposeFilePaths == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(1);
        }
        DockerComposeConfigurationParserUtil.saveDockerComposeFiles(dockerComposeFilePaths, ModalityState.defaultModalityState());
    }

    public static void saveDockerComposeFiles(@NotNull List<String> dockerComposeFilePaths, @NotNull ModalityState modalityState) {
        if (dockerComposeFilePaths == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(2);
        }
        if (modalityState == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            FileDocumentManager documentManager = FileDocumentManager.getInstance();
            List documents = (List)ReadAction.compute(() -> DockerComposeConfigurationParserUtil.getUnsavedDocuments(documentManager, dockerComposeFilePaths));
            if (!documents.isEmpty()) {
                WriteAction.runAndWait(() -> DockerComposeConfigurationParserUtil.saveDocuments(documentManager, documents));
            }
        }, modalityState);
    }

    @RequiresReadLock
    @NotNull
    static List<Document> getUnsavedDocuments(@NotNull FileDocumentManager documentManager, @NotNull List<String> filePaths) {
        if (documentManager == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(4);
        }
        if (filePaths == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.softAssertReadAccess();
        ArrayList<Document> list2 = new ArrayList<Document>();
        LocalFileSystem fs = LocalFileSystem.getInstance();
        for (String path : filePaths) {
            Document document;
            VirtualFile file2 = fs.findFileByPath(path);
            if (file2 == null || (document = documentManager.getDocument(file2)) == null || !documentManager.isDocumentUnsaved(document)) continue;
            list2.add(document);
        }
        ArrayList<Document> arrayList = list2;
        if (arrayList == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @RequiresWriteLock
    static void saveDocuments(@NotNull FileDocumentManager documentManager, @NotNull List<Document> documents) {
        if (documentManager == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(7);
        }
        if (documents == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(8);
        }
        ThreadingAssertions.assertWriteAccess();
        for (Document document : documents) {
            documentManager.saveDocument(document);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeFilePaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/configuration/beans/parse/DockerComposeConfigurationParserUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/configuration/beans/parse/DockerComposeConfigurationParserUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedDocuments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMajorVersion";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveDockerComposeFiles";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUnsavedDocuments";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveDocuments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

