/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.core.LocalDirectorySSLConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.core.util.CertificateUtils;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/impl/DockerClientExtImpl;", "Lcom/intellij/docker/agent/DockerAgentContext$DockerClientExt;", "config", "Lcom/github/dockerjava/core/DockerClientConfig;", "httpClient", "Lcom/github/dockerjava/transport/DockerHttpClient;", "(Lcom/github/dockerjava/core/DockerClientConfig;Lcom/github/dockerjava/transport/DockerHttpClient;)V", "myDockerClient", "Lcom/github/dockerjava/api/DockerClient;", "myObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "close", "", "getDockerClient", "getObjectMapper", "Companion", "intellij.clouds.docker.agent"})
public final class DockerClientExtImpl
implements DockerAgentContext.DockerClientExt {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectMapper myObjectMapper;
    @NotNull
    private final DockerClient myDockerClient;

    public DockerClientExtImpl(@NotNull DockerClientConfig config2, @Nullable DockerHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        ObjectMapper objectMapper = config2.getObjectMapper().copy();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"copy(...)");
        this.myObjectMapper = objectMapper;
        DockerHttpClient dockerHttpClient = httpClient;
        if (dockerHttpClient == null) {
            dockerHttpClient = DockerClientExtImpl.Companion.createApacheHttpClient(config2);
        }
        DockerClient dockerClient = DockerClientImpl.getInstance(config2, dockerHttpClient);
        Intrinsics.checkNotNullExpressionValue((Object)dockerClient, (String)"getInstance(...)");
        this.myDockerClient = dockerClient;
    }

    @Override
    @NotNull
    public ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = this.myObjectMapper.copy();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"copy(...)");
        return objectMapper;
    }

    @Override
    @NotNull
    public DockerClient getDockerClient() {
        return this.myDockerClient;
    }

    @Override
    public void close() throws IOException {
        this.myDockerClient.close();
    }

    @JvmStatic
    @NotNull
    public static final DefaultDockerClientConfig buildClientConfig(@NotNull DockerAgentConfig $this$buildClientConfig, @NotNull RemoteApiVersion remoteApiVersion) throws ApiTaskException {
        return Companion.buildClientConfig($this$buildClientConfig, remoteApiVersion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002J\f\u0010\u000b\u001a\u00020\f*\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/agent/impl/DockerClientExtImpl$Companion;", "", "()V", "buildClientConfig", "Lcom/github/dockerjava/core/DefaultDockerClientConfig;", "Lcom/intellij/docker/agent/DockerAgentConfig;", "remoteApiVersion", "Lcom/github/dockerjava/core/RemoteApiVersion;", "createApacheHttpClient", "Lcom/github/dockerjava/transport/DockerHttpClient;", "Lcom/github/dockerjava/core/DockerClientConfig;", "validateConfig", "", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        private final DockerHttpClient createApacheHttpClient(DockerClientConfig $this$createApacheHttpClient) {
            ApacheDockerHttpClient apacheDockerHttpClient = new ApacheDockerHttpClient.Builder().dockerHost($this$createApacheHttpClient.getDockerHost()).sslConfig($this$createApacheHttpClient.getSSLConfig()).connectionTimeout(Duration.ofSeconds(10L)).build();
            Intrinsics.checkNotNullExpressionValue((Object)apacheDockerHttpClient, (String)"build(...)");
            return apacheDockerHttpClient;
        }

        @JvmStatic
        @NotNull
        public final DefaultDockerClientConfig buildClientConfig(@NotNull DockerAgentConfig $this$buildClientConfig, @NotNull RemoteApiVersion remoteApiVersion) throws ApiTaskException {
            DefaultDockerClientConfig defaultDockerClientConfig;
            DefaultDockerClientConfig.Builder builder;
            Intrinsics.checkNotNullParameter((Object)$this$buildClientConfig, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)remoteApiVersion, (String)"remoteApiVersion");
            try {
                builder = DefaultDockerClientConfig.createDefaultConfigBuilder();
                Intrinsics.checkNotNull((Object)builder);
            }
            catch (NullPointerException e) {
                builder = new DefaultDockerClientConfig.Builder();
            }
            catch (IllegalArgumentException e) {
                builder = new DefaultDockerClientConfig.Builder();
            }
            DefaultDockerClientConfig.Builder builder2 = builder;
            String host = DockerAgentConfig.Companion.getDockerHost($this$buildClientConfig);
            if (URI.create(host).getScheme() == null) {
                throw new ApiTaskException(DockerAgentBundle.Companion.message("DockerAgentImpl.docker.scheme.is.not.specified", new Object[0]));
            }
            DefaultDockerClientConfig it = defaultDockerClientConfig = builder2.withDockerHost(host).withDockerTlsVerify(DockerAgentConfig.Companion.isTlsVerifyEnabled($this$buildClientConfig)).withDockerCertPath($this$buildClientConfig.getCertificatesPath()).withApiVersion(remoteApiVersion).build();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Companion.validateConfig(it);
            DefaultDockerClientConfig defaultDockerClientConfig2 = defaultDockerClientConfig;
            Intrinsics.checkNotNullExpressionValue((Object)defaultDockerClientConfig2, (String)"also(...)");
            return defaultDockerClientConfig2;
        }

        private final void validateConfig(DockerClientConfig $this$validateConfig) throws ApiTaskException {
            URI uRI = $this$validateConfig.getDockerHost();
            if (uRI == null) {
                throw new ApiTaskException(DockerAgentBundle.Companion.message("DockerAgentImpl.docker.host.is.not.specified", new Object[0]));
            }
            URI targetUri = uRI;
            if (Intrinsics.areEqual((Object)"tcp", (Object)targetUri.getScheme()) && $this$validateConfig.getSSLConfig() instanceof LocalDirectorySSLConfig) {
                SSLConfig sSLConfig = $this$validateConfig.getSSLConfig();
                Intrinsics.checkNotNull((Object)sSLConfig, (String)"null cannot be cast to non-null type com.github.dockerjava.core.LocalDirectorySSLConfig");
                LocalDirectorySSLConfig sslConfigImpl = (LocalDirectorySSLConfig)sSLConfig;
                Object[] objectArray = sslConfigImpl.getDockerCertPath();
                if (objectArray == null) {
                    throw new ApiTaskException(DockerAgentBundle.Companion.message("DockerAgentImpl.certificates.path.is.not.specified", new Object[0]));
                }
                Object[] certificatesPath = objectArray;
                if (!CertificateUtils.verifyCertificatesExist((String)certificatesPath)) {
                    objectArray = new Object[]{certificatesPath};
                    throw new ApiTaskException(DockerAgentBundle.Companion.message("DockerAgentImpl.cant.locate.certificate.files", objectArray));
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

