/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.compose.beans;

import com.intellij.docker.agent.compose.beans.AccessMode;
import com.intellij.docker.agent.compose.beans.DefinedDockerComposePort;
import com.intellij.docker.agent.compose.beans.DockerComposeCommand;
import com.intellij.docker.agent.compose.beans.DockerComposeEnvFile;
import com.intellij.docker.agent.compose.beans.DockerComposePort;
import com.intellij.docker.agent.compose.beans.DockerComposePortVariant;
import com.intellij.docker.agent.compose.beans.DockerComposeServiceBase;
import com.intellij.docker.agent.compose.beans.DockerComposeServiceBuilder;
import com.intellij.docker.agent.compose.beans.ExtraHost;
import com.intellij.docker.agent.compose.beans.RestartPolicy;
import com.intellij.docker.agent.compose.beans.ServiceVolume;
import com.intellij.docker.agent.compose.beans.ServiceVolumeShortSyntax;
import com.intellij.docker.agent.compose.beans.v2.DependsOn;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.util.DockerComposeUtilsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerComposeServiceBuilderBase<T extends DockerComposeServiceBuilderBase<T, R>, R extends DockerComposeServiceBase>
implements DockerComposeServiceBuilder<T, R> {
    private String myImage;
    private List<String> myLinks;
    private DependsOn myDependsOn;
    private String myWorkingDir;
    private DockerComposeCommand myEntrypoint;
    private DockerComposeCommand myCommand;
    private Map<String, String> myEnvironment;
    private String myNetworkMode;
    private Boolean myInit;
    private Boolean myPrivileged;
    private DockerComposeEnvFile myEnvFile;
    private String myUser;
    private RestartPolicy myRestartPolicy;
    private Boolean myStdinOpen;
    private List<DockerComposePortVariant> myPorts;
    private List<ServiceVolume> myVolumes;
    private List<String> myCapAdd;
    private List<String> mySecurityOpt;
    @Nullable
    private List<ExtraHost> myExtraHosts;

    @NotNull
    public T withSecurityOpt(String ... values) {
        if (values == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(0);
        }
        this.mySecurityOpt = List.of(values);
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(1);
        }
        return t;
    }

    @Override
    @NotNull
    public T withExtraHosts(@Nullable List<ExtraHost> values) {
        this.myExtraHosts = values == null ? null : List.copyOf(values);
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(2);
        }
        return t;
    }

    @NotNull
    public T withCapAdd(String ... values) {
        if (values == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(3);
        }
        this.myCapAdd = List.of(values);
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(4);
        }
        return t;
    }

    @NotNull
    public T withImage(@NotNull String val) {
        if (val == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(5);
        }
        this.myImage = val;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(6);
        }
        return t;
    }

    @NotNull
    public T withLinks(@NotNull List<String> val) {
        if (val == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(7);
        }
        this.myLinks = val;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(8);
        }
        return t;
    }

    @NotNull
    public T withInit(boolean init2) {
        this.myInit = init2;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(9);
        }
        return t;
    }

    @NotNull
    public T withPrivileged(boolean privileged2) {
        this.myPrivileged = privileged2;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(10);
        }
        return t;
    }

    @NotNull
    public T withDependsOn(@Nullable DependsOn dependsOn) {
        this.myDependsOn = dependsOn;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(11);
        }
        return t;
    }

    @Override
    @NotNull
    public T withDependsOn(@Nullable List<String> val) {
        this.myDependsOn = val != null ? new DependsOn(val) : null;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(12);
        }
        return t;
    }

    @Override
    @NotNull
    public T withWorkingDir(@Nullable String workingDir2) {
        this.myWorkingDir = workingDir2;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(13);
        }
        return t;
    }

    @Override
    @NotNull
    public T withEntrypoint(String ... command) {
        this.myEntrypoint = command != null ? new DockerComposeCommand(Arrays.asList(command)) : null;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(14);
        }
        return t;
    }

    @Override
    @NotNull
    public T withEntrypointLine(@Nullable String command) {
        this.myEntrypoint = command != null ? new DockerComposeCommand(command) : null;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(15);
        }
        return t;
    }

    @Override
    @NotNull
    public T withCommand(String ... command) {
        this.myCommand = command != null ? new DockerComposeCommand(Arrays.asList(command)) : null;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(16);
        }
        return t;
    }

    @Override
    @NotNull
    public T withCommandLine(@Nullable String command) {
        this.myCommand = command != null ? new DockerComposeCommand(command) : null;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(17);
        }
        return t;
    }

    @Override
    @NotNull
    public T withEnvironment(@Nullable Map<String, String> environment) {
        this.myEnvironment = environment;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(18);
        }
        return t;
    }

    @Override
    @NotNull
    public T withUser(@Nullable String user2) {
        this.myUser = user2;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(19);
        }
        return t;
    }

    @Override
    @NotNull
    public T withRestartPolicy(@Nullable RestartPolicy restartPolicy) {
        this.myRestartPolicy = restartPolicy;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(20);
        }
        return t;
    }

    @Override
    @NotNull
    public T withNetworkMode(@Nullable String networkMode) {
        this.myNetworkMode = networkMode;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(21);
        }
        return t;
    }

    @NotNull
    public T withEnvFiles(String ... envFiles) {
        this.myEnvFile = envFiles != null ? new DockerComposeEnvFile(Arrays.stream(envFiles).map(DockerComposeEnvFile.Record::fromString).toList()) : null;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(22);
        }
        return t;
    }

    @NotNull
    public T withEnvFiles(DockerComposeEnvFile.Record ... envFiles) {
        this.myEnvFile = envFiles != null ? new DockerComposeEnvFile(List.of(envFiles)) : null;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(23);
        }
        return t;
    }

    @Override
    @NotNull
    public T withStdinOpen(@Nullable Boolean stdinOpen) {
        this.myStdinOpen = stdinOpen;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(24);
        }
        return t;
    }

    @Override
    @NotNull
    public T withPorts(@Nullable List<DockerComposePort> ports) {
        this.myPorts = ports != null ? ports.stream().map(DefinedDockerComposePort::new).collect(Collectors.toList()) : null;
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(25);
        }
        return t;
    }

    @NotNull
    public T withPorts(String ... ports) {
        this.myPorts = ports.length == 0 ? null : Arrays.stream(ports).map(DockerComposePortVariant::fromString).collect(Collectors.toList());
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(26);
        }
        return t;
    }

    @Override
    @NotNull
    public T withBindVolumes(ServiceVolume @Nullable [] volumeBindings2) {
        this.myVolumes = volumeBindings2 == null ? Collections.emptyList() : Arrays.asList(volumeBindings2);
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(27);
        }
        return t;
    }

    @Override
    @NotNull
    public T withBindVolumes(DockerVolumeBinding @Nullable [] volumeBindings2) {
        List<Object> volumeBindingsList = volumeBindings2 == null ? Collections.emptyList() : Arrays.asList(volumeBindings2);
        this.myVolumes = volumeBindingsList.stream().map(volume2 -> {
            StringBuilder stringBuilder = new StringBuilder();
            String hostPath = volume2.getHostPath();
            if (hostPath != null && !hostPath.isEmpty()) {
                stringBuilder.append(DockerComposeUtilsKt.escapeDollarSigns(volume2.getHostPath())).append(":");
            }
            stringBuilder.append(DockerComposeUtilsKt.escapeDollarSigns(volume2.getContainerPath()));
            if (hostPath != null && !hostPath.isEmpty() && !volume2.isReadOnly()) {
                stringBuilder.append(":").append(AccessMode.RW.getCode());
            }
            return ServiceVolumeShortSyntax.parse(stringBuilder.toString());
        }).collect(Collectors.toList());
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(28);
        }
        return t;
    }

    @NotNull
    public T addVolume(@NotNull ServiceVolume volume2) {
        if (volume2 == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(29);
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<ServiceVolume>();
        }
        this.myVolumes.add(volume2);
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(30);
        }
        return t;
    }

    @NotNull
    public T addVolume(@NotNull String containerPath) {
        if (containerPath == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(31);
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<ServiceVolume>();
        }
        this.myVolumes.add(ServiceVolumeShortSyntax.fromParts(containerPath));
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(32);
        }
        return t;
    }

    @NotNull
    public T addVolume(@NotNull String hostPath, @NotNull String containerPath) {
        if (hostPath == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(33);
        }
        if (containerPath == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(34);
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<ServiceVolume>();
        }
        this.myVolumes.add(ServiceVolumeShortSyntax.fromParts(hostPath, containerPath));
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(35);
        }
        return t;
    }

    @NotNull
    public T addVolume(@NotNull String hostPath, @NotNull String containerPath, @NotNull AccessMode accessMode) {
        if (hostPath == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(36);
        }
        if (containerPath == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(37);
        }
        if (accessMode == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(38);
        }
        if (this.myVolumes == null) {
            this.myVolumes = new ArrayList<ServiceVolume>();
        }
        this.myVolumes.add(ServiceVolumeShortSyntax.fromParts(hostPath, containerPath, accessMode));
        T t = this.getThis();
        if (t == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(39);
        }
        return t;
    }

    @Override
    @NotNull
    public final R build() {
        R serviceBean = this.createServiceBean();
        ((DockerComposeServiceBase)serviceBean).setImage(this.myImage);
        ((DockerComposeServiceBase)serviceBean).setLinks(this.myLinks);
        ((DockerComposeServiceBase)serviceBean).setDependsOn(this.myDependsOn);
        ((DockerComposeServiceBase)serviceBean).setWorkingDir(this.myWorkingDir);
        ((DockerComposeServiceBase)serviceBean).setEntrypoint(this.myEntrypoint);
        ((DockerComposeServiceBase)serviceBean).setCommand(this.myCommand);
        ((DockerComposeServiceBase)serviceBean).setEnvironment(this.myEnvironment);
        ((DockerComposeServiceBase)serviceBean).setNetworkMode(this.myNetworkMode);
        ((DockerComposeServiceBase)serviceBean).setEnvFile(this.myEnvFile);
        ((DockerComposeServiceBase)serviceBean).setUser(this.myUser);
        ((DockerComposeServiceBase)serviceBean).setCapAdd(this.myCapAdd);
        ((DockerComposeServiceBase)serviceBean).setExtraHosts(this.myExtraHosts);
        ((DockerComposeServiceBase)serviceBean).setSecurityOpt(this.mySecurityOpt);
        ((DockerComposeServiceBase)serviceBean).setRestart(this.myRestartPolicy != null ? this.myRestartPolicy.toString() : null);
        ((DockerComposeServiceBase)serviceBean).setStdinOpen(this.myStdinOpen);
        ((DockerComposeServiceBase)serviceBean).setPrivileged(this.myPrivileged);
        ((DockerComposeServiceBase)serviceBean).setInit(this.myInit);
        ((DockerComposeServiceBase)serviceBean).setPorts(this.myPorts);
        ((DockerComposeServiceBase)serviceBean).setVolumes(this.myVolumes);
        R r = this.tuneServiceBean(serviceBean);
        if (r == null) {
            DockerComposeServiceBuilderBase.$$$reportNull$$$0(40);
        }
        return r;
    }

    @NotNull
    protected abstract R createServiceBean();

    @NotNull
    protected abstract R tuneServiceBean(@NotNull R var1);

    @NotNull
    protected abstract T getThis();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30, 32, 35, 39, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/agent/compose/beans/DockerComposeServiceBuilderBase";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "val";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volume";
                break;
            }
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerPath";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPath";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/agent/compose/beans/DockerComposeServiceBuilderBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withSecurityOpt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withExtraHosts";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withCapAdd";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withImage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withLinks";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withInit";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withPrivileged";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "withDependsOn";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withWorkingDir";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "withEntrypoint";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "withEntrypointLine";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "withCommand";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "withCommandLine";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "withEnvironment";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "withUser";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "withRestartPolicy";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "withNetworkMode";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "withEnvFiles";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "withStdinOpen";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "withPorts";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "withBindVolumes";
                break;
            }
            case 30: 
            case 32: 
            case 35: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "addVolume";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withSecurityOpt";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 39: 
            case 40: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withCapAdd";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withImage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withLinks";
                break;
            }
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addVolume";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30, 32, 35, 39, 40 -> new IllegalStateException(string);
        };
    }
}

