/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.cli.model;

import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.cli.model.NormalizedCommandLine;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;
import org.apache.commons.cli.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRunCliBuilder {
    private final List<String> myOptions;
    private String myCommand;
    private final String myImageSpec;
    private boolean myHasExplicitName;
    private NormalizedCommandLine myCustomRunOptions;

    public DockerRunCliBuilder(@NotNull String imageSpec) {
        if (imageSpec == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(0);
        }
        this.myOptions = new LinkedList<String>();
        this.myImageSpec = imageSpec;
    }

    public void setContainerTag(@NotNull String containerName2) {
        if (containerName2 == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(1);
        }
        if (StringsKt.isBlank((CharSequence)containerName2)) {
            return;
        }
        this.myHasExplicitName = true;
        this.myOptions.add("--name " + containerName2);
    }

    public void setPullImage(@NotNull DockerAgentDeploymentConfig.PullImage pullImage2) {
        if (pullImage2 == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(2);
        }
        this.myOptions.add("--pull " + pullImage2.name().toLowerCase(Locale.ROOT));
    }

    public void setEntryPoint(@NotNull String entrypoint2) {
        if (entrypoint2 == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(3);
        }
        if (StringsKt.isBlank((CharSequence)entrypoint2)) {
            return;
        }
        this.myOptions.add("--entrypoint " + entrypoint2);
    }

    public void setCommand(@NotNull String command) {
        if (command == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(4);
        }
        this.myCommand = command;
    }

    public void setPublishAllPorts() {
        this.myOptions.add("-P");
    }

    public void setAttachToContainer() {
        this.myOptions.add("-a");
    }

    public void addPublishedPorts(@NotNull List<DockerPortBindingImpl> ports) {
        if (ports == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(5);
        }
        if (ports.isEmpty()) {
            return;
        }
        String oneLineForAll = ports.stream().map(DockerPortBindingImpl::toCommandLineString).map(spec -> "-p " + spec).collect(Collectors.joining(" "));
        this.myOptions.add(oneLineForAll);
    }

    public void addVolume(@NotNull DockerVolumeBindingImpl spec) {
        if (spec == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(6);
        }
        this.myOptions.add("-v " + spec.toCommandLineString());
    }

    public void addEnvVar(@NotNull String name2, @Nullable String value) {
        if (name2 == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(7);
        }
        if (value == null) {
            value = System.getenv(name2);
        }
        if (value == null) {
            this.myOptions.add("-e " + name2);
        } else {
            this.myOptions.add("--env " + name2 + "=" + value);
        }
    }

    public void setCustomRunOptions(@NotNull NormalizedCommandLine runOptions) {
        if (runOptions == null) {
            DockerRunCliBuilder.$$$reportNull$$$0(8);
        }
        this.myCustomRunOptions = runOptions;
    }

    public List<String> buildPreviewLines(boolean hasCommandBefore) {
        LinkedList<String> result2 = new LinkedList<String>();
        result2.add((hasCommandBefore ? "&& " : "") + "docker run");
        result2.addAll(this.myOptions);
        if (this.myCustomRunOptions != null) {
            Predicate<Option> duplicateNameFilter = this.myHasExplicitName ? option -> !"name".equals(option.getLongOpt()) : option -> true;
            result2.addAll(this.myCustomRunOptions.groupByOptions(duplicateNameFilter));
        }
        result2.add(this.myImageSpec + (String)(this.myCommand == null ? "" : " " + this.myCommand));
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSpec";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pullImage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entrypoint";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ports";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runOptions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/agent/cli/model/DockerRunCliBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setContainerTag";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setPullImage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setEntryPoint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setCommand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addPublishedPorts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addVolume";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addEnvVar";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setCustomRunOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

