/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action.networks;

import com.github.dockerjava.api.model.Network;
import com.intellij.docker.action.networks.ConnectNetworkDialogKt;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerContainerRuntime;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.ui.components.ComboBoxWithAutoCompletion;
import com.intellij.docker.ui.components.LookupElement;
import com.intellij.docker.ui.fragmentedDialog.FragmentedDialog;
import com.intellij.docker.ui.fragmentedDialog.optionBuilders.FragmentedDialogCommandlineBuilder;
import com.intellij.docker.ui.fragmentedDialog.optionBuilders.FragmentedDialogStaticOptionBuilder;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.dsl.builder.UtilsKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0001\"\u0010\u0010\u0000\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"CONNECT_COMMAND", "", "showConnectNetworkDialogAndGetResult", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "network", "Lcom/github/dockerjava/api/model/Network;", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nConnectNetworkDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectNetworkDialog.kt\ncom/intellij/docker/action/networks/ConnectNetworkDialogKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1194#2,2:75\n1222#2,4:77\n1#3:81\n*S KotlinDebug\n*F\n+ 1 ConnectNetworkDialog.kt\ncom/intellij/docker/action/networks/ConnectNetworkDialogKt\n*L\n27#1:75,2\n27#1:77,4\n*E\n"})
public final class ConnectNetworkDialogKt {
    @NlsSafe
    @NotNull
    private static final String CONNECT_COMMAND = "docker network connect";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresEdt
    @Nullable
    public static final String showConnectNetworkDialogAndGetResult(@NotNull Project project, @NotNull DockerRuntimeContext context, @NotNull Network network2) {
        Comparable comparable;
        ComboBoxWithAutoCompletion<String> $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)network2, (String)"network");
        Iterable $this$associateBy$iv = context.getRuntimesManager().getContainers().values();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Object object = $this$associateByTo$iv$iv.iterator();
        while (object.hasNext()) {
            Object element$iv$iv = object.next();
            DockerApplicationRuntime dockerApplicationRuntime = (DockerApplicationRuntime)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl2 = false;
            String string = dockerApplicationRuntime.getContainerName();
            map2.put(string != null ? StringsKt.drop((String)string, (int)1) : null, element$iv$iv);
        }
        Map containers2 = destination$iv$iv;
        List containerNames = CollectionsKt.filterNotNull((Iterable)containers2.keySet());
        Set<String> alreadyUsedContainerIds = network2.getContainers().keySet();
        ComboBoxWithAutoCompletion<String> $this$showConnectNetworkDialogAndGetResult_u24lambda_u242 = $this$associateByTo$iv$iv = new ComboBoxWithAutoCompletion<String>(new CollectionComboBoxModel(containerNames), project, DockerBundle.message("ConnectNetworkDialog.specify.container", new Object[0]), (Function1)new Function1<String, LookupElement>((Map<String, DockerApplicationRuntime>)containers2){
            final /* synthetic */ Map<String, DockerApplicationRuntime> $containers;
            {
                this.$containers = $containers;
                super(1);
            }

            @NotNull
            public final LookupElement invoke(String it) {
                Intrinsics.checkNotNull((Object)it);
                Object object = this.$containers.get(it);
                return new LookupElement(it, object != null && (object = ((DockerRuntimeBase)object).getStatus()) != null ? object.getIcon() : null, null, null, 12, null);
            }
        });
        boolean bl = false;
        $this$showConnectNetworkDialogAndGetResult_u24lambda_u242.setRenderer((ListCellRenderer)UtilsKt.listCellRenderer((Function2)((Function2)new Function2<SimpleListCellRenderer<String>, String, Unit>((Map<String, DockerApplicationRuntime>)containers2){
            final /* synthetic */ Map<String, DockerApplicationRuntime> $containers;
            {
                this.$containers = $containers;
                super(2);
            }

            public final void invoke(@NotNull SimpleListCellRenderer<String> $this$listCellRenderer, String it) {
                Intrinsics.checkNotNullParameter($this$listCellRenderer, (String)"$this$listCellRenderer");
                Object object = this.$containers.get(it);
                $this$listCellRenderer.setIcon(object != null && (object = ((DockerRuntimeBase)object).getStatus()) != null ? object.getIcon() : null);
                Intrinsics.checkNotNull((Object)it);
                $this$listCellRenderer.setText(DockerUiUtilsKt.asNlsSafe(it));
            }
        })));
        object = containerNames;
        CharSequence charSequence = "#";
        ComboBoxWithAutoCompletion<String> comboBoxWithAutoCompletion = $this$showConnectNetworkDialogAndGetResult_u24lambda_u242;
        Iterator bl2 = object.iterator();
        if (!bl2.hasNext()) {
            comparable = null;
        } else {
            String it = (String)bl2.next();
            boolean bl3 = false;
            Comparable comparable2 = Integer.valueOf(it.length());
            while (bl2.hasNext()) {
                String it2 = (String)bl2.next();
                $i$a$-maxOfOrNull-ConnectNetworkDialogKt$showConnectNetworkDialogAndGetResult$containersComboBox$2$2 = false;
                Comparable comparable3 = Integer.valueOf(it2.length());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Comparable comparable4 = comparable;
        Integer n = (Integer)comparable4;
        comboBoxWithAutoCompletion.setPrototypeDisplayValue(StringsKt.repeat((CharSequence)charSequence, (int)(n != null ? n : 0)));
        ComboBoxWithAutoCompletion<String> containersComboBox2 = $this$associateByTo$iv$iv;
        String string = DockerBundle.message("ConnectNetworkDialog.title", new Object[0]);
        String string2 = DockerBundle.message("ConnectNetworkDialog.popup.title", new Object[0]);
        object = DockerBundle.message("ConnectNetworkDialog.ok.button.text", new Object[0]);
        charSequence = new Ref((Object)"");
        Intrinsics.checkNotNull((Object)string);
        FragmentedDialog.Commandline dialog2 = new FragmentedDialog.Commandline(project, string, CONNECT_COMMAND, charSequence, null, (Function1)new Function1<Ref<String>, String>(network2){
            final /* synthetic */ Network $network;
            {
                this.$network = $network;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull Ref<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return "docker network connect " + this.$network.getName() + " " + it.get();
            }
        }, string2, (String)object, null, "org.jetbrains.docker.engine/reference/commandline/network_connect/", (Function1)new Function1<FragmentedDialogCommandlineBuilder<Ref<String>>, Unit>(containersComboBox2, network2, (Map<String, DockerApplicationRuntime>)containers2, alreadyUsedContainerIds){
            final /* synthetic */ ComboBoxWithAutoCompletion<String> $containersComboBox;
            final /* synthetic */ Network $network;
            final /* synthetic */ Map<String, DockerApplicationRuntime> $containers;
            final /* synthetic */ Set<String> $alreadyUsedContainerIds;
            {
                this.$containersComboBox = $containersComboBox;
                this.$network = $network;
                this.$containers = $containers;
                this.$alreadyUsedContainerIds = $alreadyUsedContainerIds;
                super(1);
            }

            public final void invoke(@NotNull FragmentedDialogCommandlineBuilder<Ref<String>> $this$$receiver) {
                Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                ComboBox comboBox2 = this.$containersComboBox;
                String string = this.$network.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                FragmentedDialogCommandlineBuilder.staticComboBoxWithLabel$default($this$$receiver, comboBox2, string, false, (Function1)new Function1<FragmentedDialogStaticOptionBuilder<FragmentedDialogCommandlineBuilder.ComponentWithLabel<ComboBoxWithAutoCompletion<String>>, Ref<String>>, Unit>(this.$containers, this.$alreadyUsedContainerIds, this.$network){
                    final /* synthetic */ Map<String, DockerApplicationRuntime> $containers;
                    final /* synthetic */ Set<String> $alreadyUsedContainerIds;
                    final /* synthetic */ Network $network;
                    {
                        this.$containers = $containers;
                        this.$alreadyUsedContainerIds = $alreadyUsedContainerIds;
                        this.$network = $network;
                        super(1);
                    }

                    public final void invoke(@NotNull FragmentedDialogStaticOptionBuilder<FragmentedDialogCommandlineBuilder.ComponentWithLabel<ComboBoxWithAutoCompletion<String>>, Ref<String>> $this$staticComboBoxWithLabel) {
                        Intrinsics.checkNotNullParameter($this$staticComboBoxWithLabel, (String)"$this$staticComboBoxWithLabel");
                        $this$staticComboBoxWithLabel.setApply((Function2<FragmentedDialogCommandlineBuilder.ComponentWithLabel<ComboBoxWithAutoCompletion<String>>, Ref<String>, Unit>)((Function2)showConnectNetworkDialogAndGetResult.dialog.1.INSTANCE));
                        $this$staticComboBoxWithLabel.setValidation((Function2<FragmentedDialogCommandlineBuilder.ComponentWithLabel<ComboBoxWithAutoCompletion<String>>, Ref<String>, ValidationInfo>)((Function2)new Function2<FragmentedDialogCommandlineBuilder.ComponentWithLabel<ComboBoxWithAutoCompletion<String>>, Ref<String>, ValidationInfo>(this.$containers, this.$alreadyUsedContainerIds, this.$network){
                            final /* synthetic */ Map<String, DockerApplicationRuntime> $containers;
                            final /* synthetic */ Set<String> $alreadyUsedContainerIds;
                            final /* synthetic */ Network $network;
                            {
                                this.$containers = $containers;
                                this.$alreadyUsedContainerIds = $alreadyUsedContainerIds;
                                this.$network = $network;
                                super(2);
                            }

                            @Nullable
                            public final ValidationInfo invoke(@NotNull FragmentedDialogCommandlineBuilder.ComponentWithLabel<ComboBoxWithAutoCompletion<String>> componentWithLabel, @NotNull Ref<String> s) {
                                ValidationInfo validationInfo;
                                Intrinsics.checkNotNullParameter(componentWithLabel, (String)"<anonymous parameter 0>");
                                Intrinsics.checkNotNullParameter(s, (String)"s");
                                Object object = s.get();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                                if (StringsKt.isBlank((CharSequence)((CharSequence)object))) {
                                    validationInfo = new ValidationInfo(DockerBundle.message("ConnectNetworkDialog.validation.empty.container.name", new Object[0]));
                                } else if (this.$containers.get(s.get()) == null) {
                                    validationInfo = new ValidationInfo(DockerBundle.message("ConnectNetworkDialog.validation.container.not.exist", new Object[0]));
                                } else {
                                    DockerApplicationRuntime dockerApplicationRuntime = this.$containers.get(s.get());
                                    boolean bl = dockerApplicationRuntime != null ? !dockerApplicationRuntime.isRunning() : false;
                                    if (bl) {
                                        validationInfo = new ValidationInfo(DockerBundle.message("ConnectNetworkDialog.validation.container.not.running", new Object[0]));
                                    } else {
                                        DockerApplicationRuntime dockerApplicationRuntime2 = this.$containers.get(s.get());
                                        Intrinsics.checkNotNull((Object)dockerApplicationRuntime2);
                                        if (this.$alreadyUsedContainerIds.contains(dockerApplicationRuntime2.getId())) {
                                            Object[] objectArray = new Object[]{s.get(), this.$network.getName()};
                                            ValidationInfo validationInfo2 = new ValidationInfo(DockerBundle.message("ConnectNetworkDialog.validation.endpoint.already.exists", objectArray));
                                            validationInfo = validationInfo2;
                                        } else {
                                            validationInfo = null;
                                        }
                                    }
                                }
                                return validationInfo;
                            }
                        }));
                    }
                }, 4, null);
            }
        }, 272, null);
        Ref ref = (Ref)dialog2.showAndGet();
        Object object2 = ref;
        if (ref == null) return null;
        String string3 = (String)object2.get();
        object2 = string3;
        if (string3 == null) return null;
        Object object3 = object2;
        boolean bl4 = false;
        DockerApplicationRuntime dockerApplicationRuntime = (DockerApplicationRuntime)containers2.get(object3);
        object2 = dockerApplicationRuntime;
        if (dockerApplicationRuntime == null) return null;
        String string4 = ((DockerContainerRuntime)object2).getId();
        return string4;
    }
}

