/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="DockerSettings", category=SettingsCategory.TOOLS, exportable=true, storages={@Storage(value="docker.xml", roamingType=RoamingType.DISABLED, deprecated=true), @Storage(value="docker-tools.xml", roamingType=RoamingType.DISABLED)})
public class DockerSettings
implements PersistentStateComponent<State> {
    @ApiStatus.Internal
    public static final String DEFAULT_DOCKER_EXECUTABLE_ON_MAC_OS_X = "/usr/local/bin/docker";
    private static final String DEFAULT_DOCKER_COMPOSE_EXECUTABLE_ON_MAC_OS_X = "/usr/local/bin/docker-compose";
    private String myDockerComposePath;
    private String myDockerPath;
    @Deprecated(forRemoval=true)
    private boolean myUseComposeV2;

    @NotNull
    public static DockerSettings getInstance() {
        DockerSettings dockerSettings = (DockerSettings)ApplicationManager.getApplication().getService(DockerSettings.class);
        if (dockerSettings == null) {
            DockerSettings.$$$reportNull$$$0(0);
        }
        return dockerSettings;
    }

    @Nullable
    public State getState() {
        State state = new State();
        state.setUseComposeV2(this.myUseComposeV2);
        state.setDockerComposePath(this.myDockerComposePath);
        state.setDockerPath(this.myDockerPath);
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            DockerSettings.$$$reportNull$$$0(1);
        }
        this.setDockerComposePath(state.getDockerComposePath());
        this.setDockerPath(state.getDockerPath());
        this.myUseComposeV2 = state.isUseComposeV2();
    }

    @NotNull
    @ApiStatus.Internal
    public String getDockerComposePath() {
        if (this.myUseComposeV2) {
            this.myDockerComposePath = this.getDockerPath();
            this.myUseComposeV2 = false;
        }
        if (this.myDockerComposePath == null) {
            this.myDockerComposePath = this.getDockerPath();
        }
        String string = this.myDockerComposePath;
        if (string == null) {
            DockerSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDockerPath() {
        if (this.myDockerPath == null) {
            this.myDockerPath = SystemInfo.isMac ? DEFAULT_DOCKER_EXECUTABLE_ON_MAC_OS_X : DockerSettings.tryToFindInPath(DockerSettings.defaultDockerExecutable());
        }
        String string = this.myDockerPath;
        if (string == null) {
            DockerSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setDockerComposePath(String dockerComposePath) {
        this.myDockerComposePath = dockerComposePath;
    }

    public void setDockerPath(String dockerPath) {
        this.myDockerPath = dockerPath;
    }

    private static String defaultDockerComposeExecutable() {
        return SystemInfo.isWindows ? "docker-compose.exe" : "docker-compose";
    }

    @ApiStatus.Internal
    public static String defaultDockerExecutable() {
        return SystemInfo.isWindows ? "docker.exe" : "docker";
    }

    @ApiStatus.Internal
    public static String tryToFindInPath(@NotNull String baseName) {
        File foundInPath;
        if (baseName == null) {
            DockerSettings.$$$reportNull$$$0(4);
        }
        return (foundInPath = PathEnvironmentVariableUtil.findInPath((String)baseName)) != null ? foundInPath.getAbsolutePath() : baseName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/DockerSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/DockerSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerComposePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryToFindInPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4 -> new IllegalArgumentException(string);
        };
    }

    static class State {
        private String myDockerComposePath;
        private String myDockerPath;
        private boolean myUseComposeV2;

        State() {
        }

        @Deprecated(forRemoval=true)
        public boolean isUseComposeV2() {
            return this.myUseComposeV2;
        }

        @Deprecated(forRemoval=true)
        public void setUseComposeV2(boolean useComposeV2) {
            this.myUseComposeV2 = useComposeV2;
        }

        public String getDockerPath() {
            return this.myDockerPath;
        }

        public void setDockerPath(String dockerPath) {
            this.myDockerPath = dockerPath;
        }

        public void setDockerComposePath(String dockerComposePath) {
            this.myDockerComposePath = dockerComposePath;
        }

        public String getDockerComposePath() {
            return this.myDockerComposePath;
        }
    }
}

