/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerRuntimesManager;
import com.intellij.docker.runtimes.DockerServerRuntime;
import com.intellij.docker.view.DockerMainServiceViewContributor;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u00a2\u0006\u0002\b\u0011J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u001b\u0010\u0014\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u00a2\u0006\u0002\b\u0015R&\u0010\u0005\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/docker/DockerServerRuntimesManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myConnections", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/docker/runtimes/DockerServerRuntime;", "myMessageBus", "Lcom/intellij/util/messages/MessageBusConnection;", "myServerRuntimes", "disconnect", "", "server", "disconnect$intellij_clouds_docker", "dispose", "getOrCreateConnection", "getServerRuntime", "getServerRuntime$intellij_clouds_docker", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerServerRuntimesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerServerRuntimesManager.kt\ncom/intellij/docker/DockerServerRuntimesManager\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,89:1\n72#2,2:90\n1#3:92\n13#4:93\n*S KotlinDebug\n*F\n+ 1 DockerServerRuntimesManager.kt\ncom/intellij/docker/DockerServerRuntimesManager\n*L\n56#1:90,2\n56#1:92\n75#1:93\n*E\n"})
public final class DockerServerRuntimesManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MessageBusConnection myMessageBus;
    @NotNull
    private final ConcurrentHashMap<RemoteServer<DockerCloudConfiguration>, DockerServerRuntime> myServerRuntimes;
    @NotNull
    private final ConcurrentHashMap<RemoteServer<DockerCloudConfiguration>, CompletableFuture<DockerServerRuntime>> myConnections;
    @NotNull
    private static final Logger log;

    private DockerServerRuntimesManager(Project project) {
        this.project = project;
        this.myMessageBus = this.project.getMessageBus().connect((Disposable)this);
        this.myServerRuntimes = new ConcurrentHashMap();
        this.myConnections = new ConcurrentHashMap();
        Topic topic = RemoteServerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        this.myMessageBus.subscribe(topic, (Object)new RemoteServerListener(){

            public void serverAdded(@NotNull RemoteServer<?> server) {
                Intrinsics.checkNotNullParameter(server, (String)"server");
                if (server.getConfiguration() instanceof DockerCloudConfiguration) {
                    MessageBus messageBus = project.getMessageBus();
                    Topic topic = ServiceEventListener.TOPIC;
                    Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                    ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(ServiceEventListener.ServiceEvent.createResetEvent(DockerMainServiceViewContributor.class));
                }
            }

            public void serverRemoved(@NotNull RemoteServer<?> server) {
                Intrinsics.checkNotNullParameter(server, (String)"server");
                if (server.getConfiguration() instanceof DockerCloudConfiguration) {
                    CompletableFuture completableFuture = (CompletableFuture)TypeIntrinsics.asMutableMap((Object)myConnections).remove(server);
                    if (completableFuture != null) {
                        completableFuture.cancel(true);
                    }
                    DockerServerRuntime dockerServerRuntime = (DockerServerRuntime)TypeIntrinsics.asMutableMap((Object)myServerRuntimes).remove(server);
                    if (dockerServerRuntime != null) {
                        Disposable p0 = (Disposable)dockerServerRuntime;
                        boolean bl = false;
                        Disposer.dispose((Disposable)p0);
                    }
                    MessageBus messageBus = project.getMessageBus();
                    Topic topic = ServiceEventListener.TOPIC;
                    Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
                    ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(ServiceEventListener.ServiceEvent.createResetEvent(DockerMainServiceViewContributor.class));
                }
            }
        });
    }

    @NotNull
    public final DockerServerRuntime getServerRuntime$intellij_clouds_docker(@NotNull RemoteServer<DockerCloudConfiguration> server) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        DockerServerRuntime dockerServerRuntime = this.myServerRuntimes.computeIfAbsent(server, arg_0 -> DockerServerRuntimesManager.getServerRuntime$lambda$0((Function1)new Function1<RemoteServer<DockerCloudConfiguration>, DockerServerRuntime>(this){
            final /* synthetic */ DockerServerRuntimesManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final DockerServerRuntime invoke(@NotNull RemoteServer<DockerCloudConfiguration> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                DockerServerRuntime dockerServerRuntime = new DockerServerRuntime(it, DockerServerRuntimesManager.access$getProject$p(this.this$0));
                DockerServerRuntimesManager dockerServerRuntimesManager = this.this$0;
                DockerServerRuntime serverRuntime = dockerServerRuntime;
                boolean bl = false;
                Disposer.register((Disposable)dockerServerRuntimesManager, (Disposable)((Disposable)serverRuntime));
                return dockerServerRuntime;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dockerServerRuntime, (String)"computeIfAbsent(...)");
        return dockerServerRuntime;
    }

    @NotNull
    public final CompletableFuture<DockerServerRuntime> getOrCreateConnection(@NotNull RemoteServer<DockerCloudConfiguration> server) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        ConcurrentMap $this$getOrPut$iv = this.myConnections;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(server);
        if (object == null) {
            boolean bl = false;
            CompletableFuture<DockerServerRuntime> result2 = this.getServerRuntime$intellij_clouds_docker(server).connectIfNeeded$intellij_clouds_docker();
            result2.exceptionally(arg_0 -> DockerServerRuntimesManager.getOrCreateConnection$lambda$2$lambda$1(this, server, arg_0));
            CompletableFuture<DockerServerRuntime> default$iv = result2;
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(server, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (CompletableFuture)object;
    }

    public final void disconnect$intellij_clouds_docker(@NotNull RemoteServer<DockerCloudConfiguration> server) {
        block1: {
            Intrinsics.checkNotNullParameter(server, (String)"server");
            CompletableFuture<DockerServerRuntime> completableFuture = this.myConnections.remove(server);
            if (completableFuture != null) {
                completableFuture.cancel(true);
            }
            DockerServerRuntime dockerServerRuntime = this.myServerRuntimes.get(server);
            if (dockerServerRuntime == null) break block1;
            dockerServerRuntime.disconnect$intellij_clouds_docker();
        }
    }

    public void dispose() {
        this.myConnections.clear();
    }

    private static final DockerServerRuntime getServerRuntime$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DockerServerRuntime)$tmp0.invoke(p0);
    }

    private static final DockerServerRuntime getOrCreateConnection$lambda$2$lambda$1(DockerServerRuntimesManager this$0, RemoteServer $server, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$server, (String)"$server");
        log.warn(it);
        this$0.myConnections.remove($server);
        Intrinsics.checkNotNull((Object)it);
        throw it;
    }

    @JvmStatic
    @NotNull
    public static final DockerServerRuntimesManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static final List<DockerRuntimesManager> getConnectedManagers(@NotNull Project project) {
        return Companion.getConnectedManagers(project);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(DockerServerRuntimesManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/DockerServerRuntimesManager$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getConnectedManagers", "", "Lcom/intellij/docker/DockerRuntimesManager;", "project", "Lcom/intellij/openapi/project/Project;", "getInstance", "Lcom/intellij/docker/DockerServerRuntimesManager;", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerServerRuntimesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerServerRuntimesManager.kt\ncom/intellij/docker/DockerServerRuntimesManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n31#2,2:90\n766#3:92\n857#3,2:93\n1549#3:95\n1620#3,3:96\n*S KotlinDebug\n*F\n+ 1 DockerServerRuntimesManager.kt\ncom/intellij/docker/DockerServerRuntimesManager$Companion\n*L\n78#1:90,2\n82#1:92\n82#1:93,2\n82#1:95\n82#1:96,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DockerServerRuntimesManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DockerServerRuntimesManager> serviceClass$iv = DockerServerRuntimesManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DockerServerRuntimesManager)object;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<DockerRuntimesManager> getConnectedManagers(@NotNull Project project) {
            void $this$mapTo$iv$iv;
            DockerServerRuntime p0;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Collection collection = this.getInstance(project).myServerRuntimes.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                p0 = (DockerServerRuntime)element$iv$iv;
                boolean bl = false;
                if (!p0.isConnected()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                p0 = (DockerServerRuntime)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getContext$intellij_clouds_docker().getRuntimesManager());
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

