/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.devcontainers.cli;

import com.intellij.clouds.docker.devcontainers.cli.BuildDevcontainerCommand;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/clouds/docker/devcontainers/cli/Main;", "", "()V", "EXIT_STATUS_USAGE_ERROR", "", "OPTION_CONFIG", "", "OPTION_CONFIG_LONG", "USAGE_HEADER", "USAGE_SYNTAX", "USAGE_SYNTAX_PREFIX", "main", "", "args", "", "([Ljava/lang/String;)V", "printUsages", "options", "Lorg/apache/commons/cli/Options;", "outputStream", "Ljava/io/OutputStream;", "intellij.clouds.docker.devcontainers.cli"})
public final class Main {
    @NotNull
    public static final Main INSTANCE = new Main();
    @NotNull
    private static final String USAGE_SYNTAX_PREFIX = "Usage: ";
    @NotNull
    private static final String USAGE_SYNTAX = "devc [OPTIONS] SOURCE";
    @NotNull
    private static final String USAGE_HEADER = "\nCreate Dev Container from local sources\n\nOptions:";
    @NotNull
    private static final String OPTION_CONFIG = "c";
    @NotNull
    private static final String OPTION_CONFIG_LONG = "config";
    private static final int EXIT_STATUS_USAGE_ERROR = 64;

    private Main() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Option optionConfig = Option.builder().option(OPTION_CONFIG).longOpt(OPTION_CONFIG_LONG).hasArg(true).desc("Explicitly define path to a devcontainer.json. The path is either absolute or relative to the source argument.").optionalArg(true).build();
        Options options2 = new Options().addOption(optionConfig);
        Intrinsics.checkNotNullExpressionValue((Object)options2, (String)"addOption(...)");
        Options options3 = options2;
        DefaultParser commandLineParser = new DefaultParser();
        try {
            CommandLine commandLine = commandLineParser.parse(options3, args);
            String[] stringArray = commandLine.getArgs();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getArgs(...)");
            String string = (String)ArraysKt.firstOrNull((Object[])stringArray);
            if (string == null) {
                throw new ParseException("Path to directory is missing");
            }
            String path = string;
            new BuildDevcontainerCommand(path, commandLine.getOptionValue(OPTION_CONFIG_LONG)).run();
        }
        catch (ParseException e) {
            PrintStream printStream = System.err;
            Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"err");
            INSTANCE.printUsages(options3, printStream);
            System.exit(64);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void printUsages(Options options2, OutputStream outputStream) {
        HelpFormatter.Builder builder;
        HelpFormatter.Builder $this$printUsages_u24lambda_u240 = builder = HelpFormatter.builder();
        boolean bl = false;
        $this$printUsages_u24lambda_u240.setPrintWriter(new PrintWriter(outputStream));
        HelpFormatter.Builder $this$printUsages_u24lambda_u241 = builder = builder.get();
        boolean bl2 = false;
        $this$printUsages_u24lambda_u241.setSyntaxPrefix(USAGE_SYNTAX_PREFIX);
        builder.printHelp(USAGE_SYNTAX, USAGE_HEADER, options2, null);
    }
}

