/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.util;

import com.github.dockerjava.api.exception.DockerClientException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class FilePathUtil {
    private FilePathUtil() {
    }

    public static String relativize(File baseDir, File file2) {
        try {
            baseDir = baseDir.getCanonicalFile();
            file2 = file2.getCanonicalFile();
            return baseDir.toURI().relativize(file2.toURI()).getPath();
        }
        catch (IOException e) {
            throw new DockerClientException(e.getMessage(), e);
        }
    }

    public static String relativize(Path baseDir, Path file2) {
        String path = baseDir.toUri().relativize(file2.toUri()).getPath();
        if (!"/".equals(baseDir.getFileSystem().getSeparator())) {
            return path.replace(baseDir.getFileSystem().getSeparator(), "/");
        }
        return path;
    }
}

