/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.SaveImagesCmd;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SaveImagesCmdImpl
extends AbstrDockerCmd<SaveImagesCmd, InputStream>
implements SaveImagesCmd {
    private final ImmutableList.Builder<SaveImagesCmd.TaggedImage> taggedImages = ImmutableList.builder();

    public SaveImagesCmdImpl(SaveImagesCmd.Exec exec2) {
        super(exec2);
    }

    @Override
    public SaveImagesCmd withImage(@Nonnull String name2, @Nonnull String tag2) {
        this.taggedImages.add((Object)new TaggedImageImpl(name2, tag2));
        return this;
    }

    @Override
    public List<SaveImagesCmd.TaggedImage> getImages() {
        return this.taggedImages.build();
    }

    @Override
    public InputStream exec() throws NotFoundException {
        return (InputStream)super.exec();
    }

    private static class TaggedImageImpl
    implements SaveImagesCmd.TaggedImage {
        private final String name;
        private final String tag;

        private TaggedImageImpl(String name2, String tag2) {
            this.name = Objects.requireNonNull(name2, "image name was not specified");
            this.tag = Objects.requireNonNull(tag2, "image tag was not specified");
        }

        @Override
        public String asString() {
            return this.name + ":" + this.tag;
        }

        public String toString() {
            return this.asString();
        }
    }
}

