/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.types.DasSimpleTypeClass;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeClass;
import com.intellij.database.types.DasTypeFacade;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlTableType
extends SqlType
implements DasTableType {
    public static final DasTypeClass TYPE_CLASS = new DasSimpleTypeClass("<table>");

    @Nullable
    public abstract String getTypeName();

    @NotNull
    public abstract List<DasObject> getMethods();

    @Nullable
    public abstract PsiElement getTypeElement();

    @Nullable
    public abstract PsiElement getImmediateTypeElement();

    public abstract boolean isColumnQuoted(int var1);

    @NotNull
    public abstract PsiElement getColumnElement(int var1);

    @Nullable
    public abstract PsiElement getSourceColumnElement(int var1);

    @Nullable
    public abstract PsiElement getImmediateSourceColumnElement(int var1);

    @Nullable
    public abstract PsiElement getColumnQualifier(int var1);

    @Nullable
    public abstract String getColumnTypeAlias(int var1);

    public abstract boolean isColumnTypeAliasQuoted(int var1);

    public abstract SqlTableType join(SqlTableType var1);

    public abstract SqlTableType add(SqlTableType var1);

    public abstract SqlTableType subtract(PsiElement var1);

    public abstract SqlTableType subtract(int var1);

    public abstract SqlTableType alias(String var1, PsiElement var2, @NotNull List<? extends SqlNameElement> var3);

    public abstract SqlTableType aliasByDefs(String var1, PsiElement var2, @NotNull List<? extends SqlDefinition> var3);

    public abstract SqlTableType flattenedAlias(String var1, PsiElement var2, SqlElement var3);

    public String getColumnDisplayName(int i) {
        String name = this.getColumnName(i);
        DasType type = this.getColumnDasType(i);
        String typeText = type != DasTypeFacade.getInstance().getUnknown() ? ":" + type.getDescription() : "";
        return name + typeText;
    }

    @NotNull
    public DasTypeClass getTypeClass() {
        DasTypeClass dasTypeClass = TYPE_CLASS;
        if (dasTypeClass == null) {
            SqlTableType.$$$reportNull$$$0(0);
        }
        return dasTypeClass;
    }

    @NotNull
    public abstract DataType toDataType();

    @NotNull
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtil.notNullize((String)this.getTypeName())).append("(");
        boolean first = true;
        int len = this.getColumnCount();
        for (int i = 0; i < len; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.getColumnDisplayName(i));
        }
        sb.append(")");
        String string = sb.toString();
        if (string == null) {
            SqlTableType.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sql/psi/SqlTableType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

