/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.xaml.preview.ui.container;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.impl.FailedEditorBuilder;
import com.intellij.openapi.fileEditor.impl.FailedEditorPaneKt;
import com.intellij.openapi.fileEditor.impl.MultilineWrapMode;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.ui.components.JBLoadingPanel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rider.model.NotSupportedState;
import com.jetbrains.rider.model.PreviewAction;
import com.jetbrains.rider.model.PreviewHighlightingRect;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.xaml.core.XamlEditorsManager;
import com.jetbrains.rider.xaml.preview.XamlPreviewBundle;
import com.jetbrains.rider.xaml.preview.previewEditor.WpfPreviewEditor;
import com.jetbrains.rider.xaml.preview.states.InvalidTransitionException;
import com.jetbrains.rider.xaml.preview.ui.ImagePreview;
import com.jetbrains.rider.xaml.preview.ui.container.ImagePreviewLoadingContainer;
import com.jetbrains.rider.xaml.preview.ui.container.states.ContainerTransitionParams;
import com.jetbrains.rider.xaml.preview.ui.container.states.InitialState;
import com.jetbrains.rider.xaml.preview.ui.container.states.PreviewContainerStateBase;
import com.jetbrains.rider.xaml.splitEditor.XamlSplitEditor;
import com.jetbrains.rider.xaml.splitEditor.XamlSplitEditorSplitLayout;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018J$\u0010\u0019\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020\u0011J\u001e\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001bH\u0002J\u0010\u0010&\u001a\u00020\u00112\b\b\u0001\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\u00112\b\b\u0001\u0010\"\u001a\u00020#J\b\u0010*\u001a\u00020\u0011H\u0016J\u000e\u0010+\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#J\u0006\u0010,\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/xaml/preview/ui/container/ImagePreviewLoadingContainer;", "Lcom/intellij/ui/components/JBLoadingPanel;", "wpfPreviewEditor", "Lcom/jetbrains/rider/xaml/preview/previewEditor/WpfPreviewEditor;", "imagePreview", "Lcom/jetbrains/rider/xaml/preview/ui/ImagePreview;", "(Lcom/jetbrains/rider/xaml/preview/previewEditor/WpfPreviewEditor;Lcom/jetbrains/rider/xaml/preview/ui/ImagePreview;)V", "getImagePreview", "()Lcom/jetbrains/rider/xaml/preview/ui/ImagePreview;", "previewContainerState", "Lcom/jetbrains/rider/xaml/preview/ui/container/states/PreviewContainerStateBase;", "state", "getState", "()Lcom/jetbrains/rider/xaml/preview/ui/container/states/PreviewContainerStateBase;", "getWpfPreviewEditor", "()Lcom/jetbrains/rider/xaml/preview/previewEditor/WpfPreviewEditor;", "changeState", "", "params", "Lcom/jetbrains/rider/xaml/preview/ui/container/states/ContainerTransitionParams;", "clear", "clearImagePreview", "drawRect", "rect", "Lcom/jetbrains/rider/model/PreviewHighlightingRect;", "showImage", "image", "", "", "width", "", "height", "showPreviewImageComponent", "showUnavailableComponent", "message", "", "actions", "Lcom/jetbrains/rider/model/PreviewAction;", "showUnavailableComponentWithAction", "notSupportedState", "Lcom/jetbrains/rider/model/NotSupportedState;", "showUnavailableComponentWithPlainMessage", "startLoading", "startLoadingWithMessage", "update", "intellij.rider.plugins.xaml.preview"})
public final class ImagePreviewLoadingContainer
extends JBLoadingPanel {
    @NotNull
    private final WpfPreviewEditor wpfPreviewEditor;
    @NotNull
    private final ImagePreview imagePreview;
    @NotNull
    private PreviewContainerStateBase previewContainerState;

    public ImagePreviewLoadingContainer(@NotNull WpfPreviewEditor wpfPreviewEditor, @NotNull ImagePreview imagePreview) {
        Intrinsics.checkNotNullParameter((Object)((Object)wpfPreviewEditor), (String)"wpfPreviewEditor");
        Intrinsics.checkNotNullParameter((Object)imagePreview, (String)"imagePreview");
        super((LayoutManager)new BorderLayout(), (Disposable)wpfPreviewEditor, 0, 4, null);
        this.wpfPreviewEditor = wpfPreviewEditor;
        this.imagePreview = imagePreview;
        this.setLoadingText(XamlPreviewBundle.Companion.message("initializing.wpf.preview", new Object[0]));
        this.previewContainerState = new InitialState(this);
    }

    @NotNull
    public final WpfPreviewEditor getWpfPreviewEditor() {
        return this.wpfPreviewEditor;
    }

    @NotNull
    public final ImagePreview getImagePreview() {
        return this.imagePreview;
    }

    @NotNull
    public final PreviewContainerStateBase getState() {
        return this.previewContainerState;
    }

    public final void changeState(@NotNull ContainerTransitionParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        try {
            PreviewContainerStateBase newState;
            this.previewContainerState = newState = this.previewContainerState.changeState(params);
        }
        catch (InvalidTransitionException invalidTransitionException) {
            // empty catch block
        }
    }

    public final void startLoadingWithMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.setLoadingText(message);
        this.startLoading();
    }

    public void startLoading() {
        super.startLoading();
        this.clear();
        this.update();
    }

    private final void clear() {
        this.getContentPanel().removeAll();
    }

    public final void update() {
        this.getContentPanel().revalidate();
        this.getContentPanel().repaint();
    }

    public final void showPreviewImageComponent() {
        super.stopLoading();
        this.clear();
        this.getContentPanel().add(this.imagePreview.getView());
        this.update();
    }

    public final void showImage(@NotNull List<Byte> image, double width, double height) {
        Intrinsics.checkNotNullParameter(image, (String)"image");
        this.stopLoading();
        this.imagePreview.showImage(image, width, height);
        this.update();
    }

    public final void clearImagePreview() {
        this.imagePreview.clear();
        this.update();
    }

    public final void drawRect(@NotNull PreviewHighlightingRect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.imagePreview.drawRect(rect);
        this.update();
    }

    public final void showUnavailableComponentWithAction(@NotNull NotSupportedState notSupportedState) {
        Intrinsics.checkNotNullParameter((Object)notSupportedState, (String)"notSupportedState");
        this.showUnavailableComponent(notSupportedState.getMessage(), notSupportedState.getActions());
    }

    private final void showUnavailableComponent(String message, List<? extends PreviewAction> actions) {
        super.stopLoading();
        this.clear();
        this.getContentPanel().add(FailedEditorPaneKt.failedEditorPane((String)message, (boolean)false, (MultilineWrapMode)MultilineWrapMode.Wrap, (Function1)((Function1)new Function1<FailedEditorBuilder, Unit>(actions, this){
            final /* synthetic */ List<PreviewAction> $actions;
            final /* synthetic */ ImagePreviewLoadingContainer this$0;
            {
                this.$actions = $actions;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull FailedEditorBuilder $this$failedEditorPane) {
                Intrinsics.checkNotNullParameter((Object)$this$failedEditorPane, (String)"$this$failedEditorPane");
                block4: for (PreviewAction action : this.$actions) {
                    Pair pair;
                    switch (showUnavailableComponent.WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
                        case 1: {
                            pair = new Pair((Object)XamlPreviewBundle.Companion.message("actions.preview.closePreview", new Object[0]), (Object)new Function0<Unit>(this.this$0){
                                final /* synthetic */ ImagePreviewLoadingContainer this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    block1: {
                                        TextControlId editorId = this.this$0.getWpfPreviewEditor().getParent().getId();
                                        XamlEditorsManager manager = XamlEditorsManager.Companion.getInstance(this.this$0.getWpfPreviewEditor().getProject());
                                        TextControlId textControlId = editorId;
                                        Set xamlPreviewSplitEditor = manager.getEditorsForPreview((RdDocumentId)(textControlId != null ? textControlId.getDocumentId() : null));
                                        Object object = xamlPreviewSplitEditor;
                                        if (object == null || (object = object.iterator()) == null) break block1;
                                        Object $this$forEach$iv = object;
                                        boolean $i$f$forEach = false;
                                        Object object2 = $this$forEach$iv;
                                        while (object2.hasNext()) {
                                            E element$iv = object2.next();
                                            XamlSplitEditor it = (XamlSplitEditor)element$iv;
                                            boolean bl = false;
                                            it.triggerLayoutChange(XamlSplitEditorSplitLayout.EDITOR_ONLY, true);
                                        }
                                    }
                                }
                            });
                            break;
                        }
                        case 2: {
                            pair = new Pair((Object)XamlPreviewBundle.Companion.message("actions.preview.openWpfPreviewSettings", new Object[0]), (Object)new Function0<Unit>(this.this$0){
                                final /* synthetic */ ImagePreviewLoadingContainer this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    ShowSettingsUtil.getInstance().showSettingsDialog(this.this$0.getWpfPreviewEditor().getProject(), RiderSettingsBundle.Companion.message("XamlPreviewOptionsPage.configurable.name.xaml.preview", new Object[0]));
                                }
                            });
                            break;
                        }
                        default: {
                            continue block4;
                        }
                    }
                    Pair actionData2 = pair;
                    $this$failedEditorPane.link((String)actionData2.getFirst(), (Function0)actionData2.getSecond());
                }
            }
        })));
        this.update();
    }

    public final void showUnavailableComponentWithPlainMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.showUnavailableComponent(message, new ArrayList());
    }
}

