/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.xaml.preview.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.model.PreviewHighlightingRect;
import com.jetbrains.rider.ui.components.base.Viewable;
import com.jetbrains.rider.xaml.preview.ui.ZoomPanel;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.images.editor.ImageZoomModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\u0002H\u0016J\u0006\u0010$\u001a\u00020\u0019J\u0018\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J$\u0010%\u001a\u00020\u00192\f\u0010&\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/xaml/preview/ui/ImagePreview;", "Lcom/jetbrains/rider/ui/components/base/Viewable;", "Ljavax/swing/JComponent;", "fileName", "", "project", "Lcom/intellij/openapi/project/Project;", "mouseListener", "Ljava/awt/event/MouseListener;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Ljava/awt/event/MouseListener;)V", "getFileName", "()Ljava/lang/String;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "rectangle", "Ljava/awt/Rectangle;", "getRectangle", "()Ljava/awt/Rectangle;", "root", "Lcom/jetbrains/rider/xaml/preview/ui/ZoomPanel;", "getRoot", "()Lcom/jetbrains/rider/xaml/preview/ui/ZoomPanel;", "clear", "", "createRGBImage", "Ljava/awt/image/BufferedImage;", "bytes", "", "drawRect", "rect", "Lcom/jetbrains/rider/model/PreviewHighlightingRect;", "getImageZoomModel", "Lorg/intellij/images/editor/ImageZoomModel;", "getView", "scrollToHighlightingRectIfNeeded", "showImage", "image", "Ljava/awt/Image;", "sourceSize", "Ljava/awt/Dimension;", "", "", "width", "", "height", "intellij.rider.plugins.xaml.preview"})
@SourceDebugExtension(value={"SMAP\nImagePreview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImagePreview.kt\ncom/jetbrains/rider/xaml/preview/ui/ImagePreview\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,67:1\n13#2:68\n13#3:69\n*S KotlinDebug\n*F\n+ 1 ImagePreview.kt\ncom/jetbrains/rider/xaml/preview/ui/ImagePreview\n*L\n22#1:68\n22#1:69\n*E\n"})
public final class ImagePreview
implements Viewable<JComponent> {
    @NotNull
    private final String fileName;
    @NotNull
    private final Project project;
    @NotNull
    private final ZoomPanel root;
    @NotNull
    private final Logger logger;

    public ImagePreview(@NotNull String fileName, @NotNull Project project, @NotNull MouseListener mouseListener) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mouseListener, (String)"mouseListener");
        this.fileName = fileName;
        this.project = project;
        this.root = new ZoomPanel(mouseListener);
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ImagePreview.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ZoomPanel getRoot() {
        return this.root;
    }

    @Nullable
    public final Rectangle getRectangle() {
        return this.root.getRectangle();
    }

    @NotNull
    public JComponent getView() {
        return this.root.getView();
    }

    @NotNull
    public final ImageZoomModel getImageZoomModel() {
        return this.root.getImagePanel();
    }

    public final void scrollToHighlightingRectIfNeeded() {
        this.root.scrollToHighlightingRectIfNeeded();
    }

    public final void showImage(@NotNull List<Byte> image, double width, double height) {
        block2: {
            Intrinsics.checkNotNullParameter(image, (String)"image");
            try {
                Dimension sourceSize = new Dimension((int)width, (int)height);
                BufferedImage bufferedImage = this.createRGBImage(CollectionsKt.toByteArray((Collection)image));
                this.showImage(bufferedImage, sourceSize);
            }
            catch (Exception e) {
                String string = e.getMessage();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                this.logger.error((Throwable)e);
            }
        }
    }

    public final void clear() {
        this.root.clear();
    }

    public final void drawRect(@NotNull PreviewHighlightingRect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.root.drawRect(rect);
    }

    private final void showImage(Image image, Dimension sourceSize) {
        this.root.showImage(image, sourceSize);
    }

    private final BufferedImage createRGBImage(byte[] bytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(...)");
        return bufferedImage;
    }
}

