/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.xaml.preview.toolWindows;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.xaml.preview.toolWindows.WpfPreviewLog;
import com.jetbrains.rider.xaml.preview.toolWindows.WpfPreviewLogPanel;
import com.jetbrains.rider.xaml.preview.toolWindows.WpfPreviewLogTabsManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fR\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/xaml/preview/toolWindows/WpfPreviewLogTabsManager;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;)V", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "Lorg/jetbrains/annotations/NotNull;", "openedTabs", "Ljava/util/HashMap;", "", "Lcom/jetbrains/rider/xaml/preview/toolWindows/WpfPreviewLogTabsManager$OpenedTabInfo;", "Lkotlin/collections/HashMap;", "closeTab", "", "id", "createContent", "Lcom/intellij/ui/content/Content;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/rider/xaml/preview/toolWindows/WpfPreviewLog;", "getOrCreateLogTabContent", "openStacktraceTab", "updateTabLogTextIfOpened", "newText", "OpenedTabInfo", "intellij.rider.plugins.xaml.preview"})
public final class WpfPreviewLogTabsManager
extends LifetimedService {
    @NotNull
    private final Project project;
    @NotNull
    private final ToolWindow toolWindow;
    @NotNull
    private final HashMap<String, OpenedTabInfo> openedTabs;
    @NotNull
    private final ContentManager contentManager;

    public WpfPreviewLogTabsManager(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.project = project;
        this.toolWindow = toolWindow;
        this.openedTabs = new HashMap();
        ContentManager contentManager = this.toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        this.contentManager = contentManager;
    }

    public final void openStacktraceTab(@NotNull WpfPreviewLog model, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Content content = this.getOrCreateLogTabContent(model, lifetime);
        this.toolWindow.activate(WpfPreviewLogTabsManager::openStacktraceTab$lambda$0);
        this.contentManager.setSelectedContent(content);
    }

    public final void updateTabLogTextIfOpened(@NotNull String id, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        OpenedTabInfo openedTabInfo = this.openedTabs.get(id);
        if (openedTabInfo != null) {
            JComponent jComponent = openedTabInfo.getContent().getComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.jetbrains.rider.xaml.preview.toolWindows.WpfPreviewLogPanel");
            WpfPreviewLogPanel wpfPreviewLogPanel = (WpfPreviewLogPanel)((Object)jComponent);
            WpfPreviewLog oldModel = wpfPreviewLogPanel.getModel();
            wpfPreviewLogPanel.setModel(new WpfPreviewLog(id, oldModel.getSessionName(), newText));
        }
    }

    public final void closeTab(@NotNull String id) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            OpenedTabInfo openedTabInfo = this.openedTabs.get(id);
            if (openedTabInfo == null || (openedTabInfo = openedTabInfo.getLifetimeDefinition()) == null) break block0;
            LifetimeDefinition.terminate$default((LifetimeDefinition)openedTabInfo, (boolean)false, (int)1, null);
        }
    }

    private final Content getOrCreateLogTabContent(WpfPreviewLog model, Lifetime lifetime) {
        OpenedTabInfo info = this.openedTabs.get(model.getId());
        if (info == null || this.contentManager.getIndexOfContent(info.getContent()) < 0) {
            LifetimeDefinition tabLifetimeDefinition = lifetime.createNested();
            Content content = this.createContent((Lifetime)tabLifetimeDefinition, this.project, model);
            OpenedTabInfo newInfo = new OpenedTabInfo(content, tabLifetimeDefinition);
            CollectionExKt.addUnique((Map)this.openedTabs, (Lifetime)tabLifetimeDefinition.getLifetime(), (Object)model.getId(), (Object)newInfo);
            ContentManagerListener listener2 = new ContentManagerListener(content, tabLifetimeDefinition){
                final /* synthetic */ Content $content;
                final /* synthetic */ LifetimeDefinition $tabLifetimeDefinition;
                {
                    this.$content = $content;
                    this.$tabLifetimeDefinition = $tabLifetimeDefinition;
                }

                public void contentRemoved(@NotNull ContentManagerEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (event.getContent() == this.$content) {
                        LifetimeDefinition.terminate$default((LifetimeDefinition)this.$tabLifetimeDefinition, (boolean)false, (int)1, null);
                    }
                }
            };
            tabLifetimeDefinition.bracket((Function0)new Function0<Unit>(this, listener2){
                final /* synthetic */ WpfPreviewLogTabsManager this$0;
                final /* synthetic */ getOrCreateLogTabContent.listener.1 $listener;
                {
                    this.this$0 = $receiver;
                    this.$listener = $listener;
                    super(0);
                }

                public final void invoke() {
                    WpfPreviewLogTabsManager.access$getContentManager$p(this.this$0).addContentManagerListener((ContentManagerListener)this.$listener);
                }
            }, (Function0)new Function0<Unit>(this, listener2, newInfo){
                final /* synthetic */ WpfPreviewLogTabsManager this$0;
                final /* synthetic */ getOrCreateLogTabContent.listener.1 $listener;
                final /* synthetic */ OpenedTabInfo $newInfo;
                {
                    this.this$0 = $receiver;
                    this.$listener = $listener;
                    this.$newInfo = $newInfo;
                    super(0);
                }

                public final void invoke() {
                    WpfPreviewLogTabsManager.access$getContentManager$p(this.this$0).removeContentManagerListener((ContentManagerListener)this.$listener);
                    WpfPreviewLogTabsManager.access$getContentManager$p(this.this$0).removeContent(this.$newInfo.getContent(), true);
                }
            });
            return newInfo.getContent();
        }
        return info.getContent();
    }

    private final Content createContent(Lifetime lifetime, Project project, WpfPreviewLog model) {
        WpfPreviewLogPanel pane = new WpfPreviewLogPanel(model, lifetime, project);
        Content content = this.contentManager.getFactory().createContent((JComponent)((Object)pane), model.getSessionName(), false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        this.contentManager.addContent(content2);
        return content2;
    }

    private static final void openStacktraceTab$lambda$0() {
    }

    public static final /* synthetic */ ContentManager access$getContentManager$p(WpfPreviewLogTabsManager $this) {
        return $this.contentManager;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/xaml/preview/toolWindows/WpfPreviewLogTabsManager$OpenedTabInfo;", "", "content", "Lcom/intellij/ui/content/Content;", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "(Lcom/intellij/ui/content/Content;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "getContent", "()Lcom/intellij/ui/content/Content;", "getLifetimeDefinition", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rider.plugins.xaml.preview"})
    public static final class OpenedTabInfo {
        @NotNull
        private final Content content;
        @NotNull
        private final LifetimeDefinition lifetimeDefinition;

        public OpenedTabInfo(@NotNull Content content, @NotNull LifetimeDefinition lifetimeDefinition) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"lifetimeDefinition");
            this.content = content;
            this.lifetimeDefinition = lifetimeDefinition;
        }

        @NotNull
        public final Content getContent() {
            return this.content;
        }

        @NotNull
        public final LifetimeDefinition getLifetimeDefinition() {
            return this.lifetimeDefinition;
        }

        @NotNull
        public final Content component1() {
            return this.content;
        }

        @NotNull
        public final LifetimeDefinition component2() {
            return this.lifetimeDefinition;
        }

        @NotNull
        public final OpenedTabInfo copy(@NotNull Content content, @NotNull LifetimeDefinition lifetimeDefinition) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"lifetimeDefinition");
            return new OpenedTabInfo(content, lifetimeDefinition);
        }

        public static /* synthetic */ OpenedTabInfo copy$default(OpenedTabInfo openedTabInfo, Content content, LifetimeDefinition lifetimeDefinition, int n, Object object) {
            if ((n & 1) != 0) {
                content = openedTabInfo.content;
            }
            if ((n & 2) != 0) {
                lifetimeDefinition = openedTabInfo.lifetimeDefinition;
            }
            return openedTabInfo.copy(content, lifetimeDefinition);
        }

        @NotNull
        public String toString() {
            return "OpenedTabInfo(content=" + this.content + ", lifetimeDefinition=" + this.lifetimeDefinition + ")";
        }

        public int hashCode() {
            int result = this.content.hashCode();
            result = result * 31 + this.lifetimeDefinition.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OpenedTabInfo)) {
                return false;
            }
            OpenedTabInfo openedTabInfo = (OpenedTabInfo)other;
            if (!Intrinsics.areEqual((Object)this.content, (Object)openedTabInfo.content)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lifetimeDefinition, (Object)openedTabInfo.lifetimeDefinition);
        }
    }
}

