/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.xaml.preview.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.xaml.core.XamlPreviewEditor;
import com.jetbrains.rider.xaml.preview.actions.updateContexts.ClickableUpdateContext;
import com.jetbrains.rider.xaml.preview.actions.updateContexts.ErrorUpdateContext;
import com.jetbrains.rider.xaml.preview.actions.updateContexts.NotSupportedUpdateContext;
import com.jetbrains.rider.xaml.preview.actions.updateContexts.ProcessingUpdateContext;
import com.jetbrains.rider.xaml.preview.actions.updateContexts.SuccessUpdateContext;
import com.jetbrains.rider.xaml.preview.actions.updateContexts.SuccessWithErrorsUpdateContext;
import com.jetbrains.rider.xaml.preview.actions.updateContexts.UpdateContext;
import com.jetbrains.rider.xaml.preview.actions.updateContexts.UpdateContextKt;
import com.jetbrains.rider.xaml.preview.previewEditor.WpfPreviewEditor;
import com.jetbrains.rider.xaml.preview.toolWindows.WpfPreviewLogToolWindowController;
import com.jetbrains.rider.xaml.splitEditor.XamlSplitEditor;
import com.jetbrains.rider.xaml.splitEditor.editorActions.XamlSplitEditorActionsUtils;
import icons.ReSharperIcons;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/xaml/preview/actions/PreviewStatusAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "myUpdateContext", "Lcom/jetbrains/rider/xaml/preview/actions/updateContexts/UpdateContext;", "updateContext", "getUpdateContext", "()Lcom/jetbrains/rider/xaml/preview/actions/updateContexts/UpdateContext;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "setNewUpdateContext", "update", "intellij.rider.plugins.xaml.preview"})
@SourceDebugExtension(value={"SMAP\nPreviewStatusAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewStatusAction.kt\ncom/jetbrains/rider/xaml/preview/actions/PreviewStatusAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,76:1\n31#2,2:77\n31#2,2:79\n31#2,2:81\n31#2,2:83\n*S KotlinDebug\n*F\n+ 1 PreviewStatusAction.kt\ncom/jetbrains/rider/xaml/preview/actions/PreviewStatusAction\n*L\n45#1:77,2\n51#1:79,2\n57#1:81,2\n68#1:83,2\n*E\n"})
public final class PreviewStatusAction
extends DumbAwareAction {
    @Nullable
    private UpdateContext myUpdateContext;

    @Nullable
    public final UpdateContext getUpdateContext() {
        return this.myUpdateContext;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        UpdateContext updateContext = this.myUpdateContext;
        if (updateContext instanceof ClickableUpdateContext) {
            ((ClickableUpdateContext)((Object)updateContext)).executeClick();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        XamlSplitEditor xamlSplitEditor = XamlSplitEditorActionsUtils.INSTANCE.getSplitEditorFromEvent(e);
        XamlPreviewEditor xamlPreviewEditor = xamlSplitEditor != null ? xamlSplitEditor.getPreviewEditor() : null;
        WpfPreviewEditor wpfPreviewEditor = xamlPreviewEditor instanceof WpfPreviewEditor ? (WpfPreviewEditor)xamlPreviewEditor : null;
        if (wpfPreviewEditor == null) {
            return;
        }
        WpfPreviewEditor wpfPreviewEditor2 = wpfPreviewEditor;
        UpdateContext updateContext = this.myUpdateContext;
        if (updateContext == null) {
            return;
        }
        UpdateContext updateContext2 = updateContext;
        String toolTip = updateContext2.getToolTip();
        while (((CharSequence)toolTip).length() > 0 && (StringsKt.endsWith$default((String)toolTip, (String)".", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)toolTip, (String)" ", (boolean)false, (int)2, null))) {
            Intrinsics.checkNotNullExpressionValue((Object)toolTip.substring(0, toolTip.length() - 2), (String)"substring(...)");
        }
        e.getPresentation().setText(toolTip);
        String sessionId = UpdateContextKt.getSessionIdAndName(wpfPreviewEditor2).component1();
        UpdateContext updateContext3 = updateContext2;
        if (updateContext3 instanceof SuccessWithErrorsUpdateContext) {
            e.getPresentation().setIcon(AllIcons.General.Warning);
            e.getPresentation().setEnabled(true);
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<WpfPreviewLogToolWindowController> serviceClass$iv = WpfPreviewLogToolWindowController.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((WpfPreviewLogToolWindowController)object).updateTabModelIfOpened(sessionId, ((SuccessWithErrorsUpdateContext)updateContext2).getErrorMessage());
        } else if (updateContext3 instanceof ErrorUpdateContext) {
            e.getPresentation().setIcon(AllIcons.General.Error);
            e.getPresentation().setEnabled(true);
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<WpfPreviewLogToolWindowController> serviceClass$iv = WpfPreviewLogToolWindowController.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((WpfPreviewLogToolWindowController)object).updateTabModelIfOpened(sessionId, ((ErrorUpdateContext)updateContext2).getErrorMessage());
        } else if (updateContext3 instanceof NotSupportedUpdateContext) {
            e.getPresentation().setIcon(AllIcons.General.Information);
            e.getPresentation().setEnabled(true);
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<WpfPreviewLogToolWindowController> serviceClass$iv = WpfPreviewLogToolWindowController.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((WpfPreviewLogToolWindowController)object).updateTabModelIfOpened(sessionId, ((NotSupportedUpdateContext)updateContext2).getNotSupportedMessage());
        } else if (updateContext3 instanceof ProcessingUpdateContext) {
            e.getPresentation().setIcon(ReSharperIcons.Common.Refresh);
            e.getPresentation().setEnabled(false);
        } else if (updateContext3 instanceof SuccessUpdateContext) {
            e.getPresentation().setIcon(ReSharperIcons.Common.Success);
            e.getPresentation().setEnabled(true);
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<WpfPreviewLogToolWindowController> serviceClass$iv = WpfPreviewLogToolWindowController.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((WpfPreviewLogToolWindowController)object).updateTabModelIfOpened(sessionId, new SuccessUpdateContext().getToolTip());
        }
    }

    public final void setNewUpdateContext(@NotNull UpdateContext updateContext) {
        Intrinsics.checkNotNullParameter((Object)updateContext, (String)"updateContext");
        this.myUpdateContext = updateContext;
    }
}

