/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.xaml.preview.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.xaml.preview.actions.ImagePreviewActionBase;
import com.jetbrains.rider.xaml.preview.actions.PreviewActionsUtils;
import com.jetbrains.rider.xaml.preview.fus.WpfPreviewFusLogger;
import com.jetbrains.rider.xaml.splitEditor.XamlSplitEditor;
import com.jetbrains.rider.xaml.splitEditor.editorActions.XamlSplitEditorActionsUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.editor.ImageZoomModel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/xaml/preview/actions/ActualSizeAction;", "Lcom/jetbrains/rider/xaml/preview/actions/ImagePreviewActionBase;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.rider.plugins.xaml.preview"})
public final class ActualSizeAction
extends ImagePreviewActionBase {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        XamlSplitEditor editor = XamlSplitEditorActionsUtils.INSTANCE.getSplitEditorFromEvent(e);
        ImageZoomModel zoomModel = PreviewActionsUtils.INSTANCE.getImageZoomModel(e);
        if (editor != null && zoomModel != null) {
            zoomModel.setZoomFactor(1.0);
            zoomModel.setZoomLevelChanged(true);
            Project project = e.getProject();
            String string = editor.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            WpfPreviewFusLogger.INSTANCE.logActualSizeEvent$intellij_rider_plugins_xaml_preview(project, string);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        XamlSplitEditor splitXamlEditor = XamlSplitEditorActionsUtils.INSTANCE.getSplitEditorFromEvent(e);
        if (this.checkIfShouldBeDisabled(splitXamlEditor)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        ImageZoomModel zoomModel = PreviewActionsUtils.INSTANCE.getImageZoomModel(e);
        if (zoomModel != null && splitXamlEditor != null) {
            e.getPresentation().setEnabled(!(zoomModel.getZoomFactor() == 1.0));
        }
    }
}

