/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.endpoints;

import com.intellij.json.psi.JsonProperty;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsDocumentationProvider;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.ExternalEndpointsFilter;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.SearchScopeEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerCoreIcons;
import com.intellij.swagger.core.SwaggerUiUtilsKt;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.documentation.SwDocumentationUtilsKt;
import com.intellij.swagger.core.model.api.SwEndpoint;
import com.intellij.swagger.core.model.api.SwHttpOperation;
import com.intellij.swagger.core.model.api.SwModelBase;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.remote.RemoteSpecificationModel;
import com.intellij.swagger.core.model.specification.SpecificationBasedModel;
import com.intellij.swagger.core.model.specification.SpecificationHttpOperation;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.providers.resolve.SwUrlTargetUtilsKt;
import com.intellij.swagger.endpoints.SwEndpointDocumentationRequest;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.MicroservicesIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\u0004:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u001c2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001c2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0018\u0010-\u001a\u00020,2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u001a\u0010.\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010/\u001a\u00020,H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00061"}, d2={"Lcom/intellij/swagger/endpoints/SwEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsUrlTargetProvider;", "Lcom/intellij/swagger/core/model/api/SwModelBase;", "Lcom/intellij/swagger/core/model/api/SwEndpoint;", "Lcom/intellij/microservices/endpoints/EndpointsDocumentationProvider;", "Lcom/intellij/swagger/endpoints/SwEndpointDocumentationRequest;", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "group", "endpoint", "getElementPreviewText", "", "psiElement", "getEndpointDocumentation", "Ljavax/swing/JComponent;", "request", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getEndpointGroups", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getEndpoints", "getLocationString", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "isDeprecated", "", "isValidEndpoint", "prepareDocumentationRequest", "shouldShowOpenApiPanel", "DisposablePanel", "intellij.swagger.endpoints"})
@SourceDebugExtension(value={"SMAP\nSwEndpointsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwEndpointsProvider.kt\ncom/intellij/swagger/endpoints/SwEndpointsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1#2:138\n14#3:139\n1549#4:140\n1620#4,3:141\n*S KotlinDebug\n*F\n+ 1 SwEndpointsProvider.kt\ncom/intellij/swagger/endpoints/SwEndpointsProvider\n*L\n70#1:139\n114#1:140\n114#1:141,3\n*E\n"})
public final class SwEndpointsProvider
implements EndpointsUrlTargetProvider<SwModelBase, SwEndpoint>,
EndpointsDocumentationProvider<SwModelBase, SwEndpoint, SwEndpointDocumentationRequest> {
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("OpenAPI", SwaggerBundle.message("openapi.specification", new Object[0]), MicroservicesIcons.Oas.Openapi);

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.API_DEFINITION_TYPE;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return EndpointsProvider.Status.AVAILABLE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull SwModelBase group2, @NotNull SwEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.getSourcePsi();
    }

    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull SwModelBase group2, @NotNull SwEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint instanceof SwHttpOperation ? (Iterable)SwUrlTargetUtilsKt.computeEndpointTargets(CollectionsKt.listOf((Object)endpoint), group2.isRemote()) : (Iterable)CollectionsKt.emptyList();
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull SwModelBase group2, @NotNull SwEndpoint endpoint) {
        TextAttributesKey textAttributesKey;
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        TextAttributesKey textAttributesKey2 = textAttributesKey = CodeInsightColors.DEPRECATED_ATTRIBUTES;
        Icon icon = SwaggerCoreIcons.Endpoint;
        String string = this.getLocationString(group2);
        String string2 = endpoint.getHttpMethod().getValue();
        String string3 = endpoint.getUrl();
        boolean bl = false;
        boolean bl2 = this.isDeprecated(endpoint);
        TextAttributesKey textAttributesKey3 = bl2 ? textAttributesKey : null;
        Icon icon2 = icon;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        return (ItemPresentation)new HttpMethodPresentation(string6, string5, string4, icon2, textAttributesKey3);
    }

    private final boolean isDeprecated(SwEndpoint endpoint) {
        SwModelElement swModelElement;
        SwEndpoint $this$asSafely$iv = endpoint;
        boolean $i$f$asSafely = false;
        SwEndpoint swEndpoint = $this$asSafely$iv;
        if (!(swEndpoint instanceof SpecificationHttpOperation)) {
            swEndpoint = null;
        }
        return (swModelElement = (SpecificationHttpOperation)swEndpoint) != null && (swModelElement = ((SpecificationHttpOperation)swModelElement).isDeprecated()) != null ? (Boolean)swModelElement.getValue() : false;
    }

    private final String getLocationString(SwModelBase group2) {
        String presentablePath;
        if (group2.isRemote() && group2 instanceof SwSpecificationFile && (presentablePath = SwaggerUtilsKt.suggestRemoteSpecificationUrl((SwSpecificationFile)group2)) != null) {
            return presentablePath;
        }
        PsiElement psiElement = group2.getSourcePsi();
        PsiNamedElement psiNamedElement = psiElement instanceof PsiNamedElement ? (PsiNamedElement)psiElement : null;
        String string = psiNamedElement != null ? psiNamedElement.getName() : null;
        if (string == null) {
            string = SwaggerBundle.message("unknown.specification", new Object[0]);
        }
        return string;
    }

    @Nullable
    public SwEndpointDocumentationRequest prepareDocumentationRequest(@NotNull SwModelBase group2, @NotNull SwEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        PsiElement psiElement = endpoint.getSourcePsi();
        Intrinsics.checkNotNull((Object)psiElement);
        PsiElement psiElement2 = psiElement;
        Project project = psiElement2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        LanguageFileType fileType = FileTypeManager.getInstance().findFileTypeByLanguage(psiElement2.getLanguage());
        if (fileType == null) {
            return null;
        }
        String string = fileType.getDefaultExtension();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDefaultExtension(...)");
        String ext = string;
        LightVirtualFile virtualFile2 = new LightVirtualFile("openapi-endpoint-preview." + ext, (FileType)fileType, (CharSequence)this.getElementPreviewText(psiElement2));
        PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile((VirtualFile)virtualFile2);
        Intrinsics.checkNotNull((Object)psiFile2);
        PsiFile psiFile3 = psiFile2;
        Document document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile3);
        Intrinsics.checkNotNull((Object)document2);
        Document document3 = document2;
        return new SwEndpointDocumentationRequest(project2, (VirtualFile)virtualFile2, document3);
    }

    @NotNull
    public JComponent getEndpointDocumentation(@NotNull SwEndpointDocumentationRequest request, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        EditorEx editor = SwaggerUiUtilsKt.createOpenApiPreviewEditor(request.getProject(), request.getFile(), request.getDocument());
        return (JComponent)((Object)new DisposablePanel(parentDisposable, (Editor)editor));
    }

    private final String getElementPreviewText(PsiElement psiElement) {
        String string;
        PsiElement psiElement2 = psiElement;
        if (psiElement2 instanceof YAMLKeyValue) {
            string = SwDocumentationUtilsKt.yamlDocumentationFragment$default((YAMLKeyValue)psiElement, false, 2, null);
        } else if (psiElement2 instanceof JsonProperty) {
            string = SwDocumentationUtilsKt.jsonDocumentationFragment$default((JsonProperty)psiElement, false, 2, null);
        } else {
            String string2 = psiElement.getText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        }
        return string;
    }

    public boolean isValidEndpoint(@NotNull SwModelBase group2, @NotNull SwEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return SwaggerUtilsKt.isElementValid(endpoint);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<SwModelBase> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (filter instanceof ExternalEndpointsFilter) {
            void $this$mapTo$iv$iv;
            RemoteSpecificationModel remoteModel = RemoteSpecificationModel.Companion.getInstance(project);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
            Iterable $this$map$iv = remoteModel.getBaseModelElements(globalSearchScope);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SwSpecificationFile swSpecificationFile = (SwSpecificationFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.substitute(project));
            }
            return (List)destination$iv$iv;
        }
        SearchScopeEndpointsFilter searchScopeEndpointsFilter = filter instanceof SearchScopeEndpointsFilter ? (SearchScopeEndpointsFilter)filter : null;
        if (searchScopeEndpointsFilter == null || (searchScopeEndpointsFilter = searchScopeEndpointsFilter.getContentSearchScope()) == null) {
            return CollectionsKt.emptyList();
        }
        SearchScopeEndpointsFilter searchScope = searchScopeEndpointsFilter;
        return SpecificationBasedModel.INSTANCE.getBaseModelElements((GlobalSearchScope)searchScope);
    }

    @NotNull
    public Iterable<SwEndpoint> getEndpoints(@NotNull SwModelBase group2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        return group2.getEndpoints();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SwaggerUtilsKt.getYamlJsonModificationTracker(project);
    }

    public boolean shouldShowOpenApiPanel() {
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/swagger/endpoints/SwEndpointsProvider$DisposablePanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "parent", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "dispose", "", "intellij.swagger.endpoints"})
    private static final class DisposablePanel
    extends BorderLayoutPanel
    implements Disposable {
        @NotNull
        private final Editor editor;

        public DisposablePanel(@NotNull Disposable parent, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            Disposer.register((Disposable)parent, (Disposable)this);
            this.addToCenter(this.editor.getComponent());
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        public void dispose() {
            EditorFactory.getInstance().releaseEditor(this.editor);
        }
    }
}

