/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.visualEditing.templates;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.swagger.core.visualEditing.SwGenerationRelativePosition;
import com.intellij.swagger.core.visualEditing.templates.SwLanguageAwareTemplateAdapter;
import com.intellij.swagger.core.visualEditing.templates.SwTemplateInsertionStrategy;
import com.intellij.swagger.core.visualEditing.templates.SwVisualEditingTemplatesKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003R\u00020\u00000\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0006\u001a\u00060\u0003R\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\n\u0010\r\u001a\u00060\u0003R\u00020\u0000H\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0002H\u0002J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/swagger/core/visualEditing/templates/SwJsonTemplateLanguageAdapter;", "Lcom/intellij/swagger/core/visualEditing/templates/SwLanguageAwareTemplateAdapter;", "Lcom/intellij/json/psi/JsonProperty;", "Lcom/intellij/swagger/core/visualEditing/templates/SwJsonTemplateLanguageAdapter$JsonStrategy;", "element", "(Lcom/intellij/json/psi/JsonProperty;)V", "chooseInsertionStrategy", "relativePosition", "Lcom/intellij/swagger/core/visualEditing/SwGenerationRelativePosition;", "chooseNodeToInsertTo", "formatTemplateText", "", "templateText", "insertionStrategy", "needsArrayBracketsAround", "", "nodeToInsertTo", "needsCommaAfter", "needsCurlyBracesAround", "offsetAfterKeyValueAndBrackets", "", "offsetAfterPreviousKeyValue", "(Lcom/intellij/json/psi/JsonProperty;)Ljava/lang/Integer;", "offsetAfterPreviousSiblingOrParent", "JsonStrategy", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwJsonTemplateLanguageAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwJsonTemplateLanguageAdapter.kt\ncom/intellij/swagger/core/visualEditing/templates/SwJsonTemplateLanguageAdapter\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,94:1\n14#2:95\n14#2:96\n66#3,2:97\n67#3:99\n*S KotlinDebug\n*F\n+ 1 SwJsonTemplateLanguageAdapter.kt\ncom/intellij/swagger/core/visualEditing/templates/SwJsonTemplateLanguageAdapter\n*L\n32#1:95\n33#1:96\n50#1:97,2\n89#1:99\n*E\n"})
public final class SwJsonTemplateLanguageAdapter
extends SwLanguageAwareTemplateAdapter<JsonProperty, JsonStrategy> {
    public SwJsonTemplateLanguageAdapter(@NotNull JsonProperty element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element, null);
    }

    @Override
    @NotNull
    protected JsonStrategy chooseInsertionStrategy(@NotNull SwGenerationRelativePosition relativePosition) {
        Intrinsics.checkNotNullParameter((Object)((Object)relativePosition), (String)"relativePosition");
        JsonProperty nodeToInsertTo = this.chooseNodeToInsertTo(relativePosition);
        boolean needsCommaAfter = this.needsCommaAfter(relativePosition, nodeToInsertTo);
        boolean needsArrayBracketsAround = this.needsArrayBracketsAround(relativePosition, nodeToInsertTo);
        boolean needsCurlyBracesAround = this.needsCurlyBracesAround(relativePosition, nodeToInsertTo);
        int templateInsertionOffset = this.offsetAfterPreviousSiblingOrParent(relativePosition, nodeToInsertTo);
        return new JsonStrategy(needsCommaAfter, needsArrayBracketsAround, needsCurlyBracesAround, templateInsertionOffset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needsCommaAfter(SwGenerationRelativePosition relativePosition, JsonProperty nodeToInsertTo) {
        Collection collection;
        boolean $i$f$asSafely;
        JsonValue $this$asSafely$iv;
        if (relativePosition == SwGenerationRelativePosition.PREVIOUS_SIBLING) return true;
        if (relativePosition == SwGenerationRelativePosition.SIMPLE_CHILD) {
            $this$asSafely$iv = nodeToInsertTo.getValue();
            $i$f$asSafely = false;
            JsonValue jsonValue = $this$asSafely$iv;
            if (!(jsonValue instanceof JsonObject)) {
                jsonValue = null;
            }
            JsonObject jsonObject = (JsonObject)jsonValue;
            collection = jsonObject != null ? jsonObject.getPropertyList() : null;
            if (collection != null) {
                if (!collection.isEmpty()) return true;
            }
            boolean bl = true;
            if (!bl) return true;
        }
        if (relativePosition != SwGenerationRelativePosition.COLLECTION_CHILD) return false;
        $this$asSafely$iv = nodeToInsertTo.getValue();
        $i$f$asSafely = false;
        JsonValue jsonValue = $this$asSafely$iv;
        if (!(jsonValue instanceof JsonArray)) {
            jsonValue = null;
        }
        JsonArray jsonArray = (JsonArray)jsonValue;
        collection = jsonArray != null ? jsonArray.getValueList() : null;
        if (collection == null) return false;
        if (!collection.isEmpty()) return true;
        return false;
    }

    private final boolean needsArrayBracketsAround(SwGenerationRelativePosition relativePosition, JsonProperty nodeToInsertTo) {
        return relativePosition == SwGenerationRelativePosition.COLLECTION_CHILD && !(nodeToInsertTo.getValue() instanceof JsonArray);
    }

    private final boolean needsCurlyBracesAround(SwGenerationRelativePosition relativePosition, JsonProperty nodeToInsertTo) {
        return relativePosition == SwGenerationRelativePosition.SIMPLE_CHILD && !(nodeToInsertTo.getValue() instanceof JsonObject) || relativePosition == SwGenerationRelativePosition.COLLECTION_CHILD;
    }

    /*
     * Unable to fully structure code
     */
    private final int offsetAfterPreviousSiblingOrParent(SwGenerationRelativePosition relativePosition, JsonProperty nodeToInsertTo) {
        if (relativePosition != SwGenerationRelativePosition.PREVIOUS_SIBLING) ** GOTO lbl-1000
        $this$parentOfType_u24default$iv = this.getHighlightedElement();
        withSelf$iv = false;
        $i$f$parentOfType = false;
        v0 = (JsonObject)PsiTreeUtil.getParentOfType($this$parentOfType_u24default$iv, JsonObject.class, (boolean)true);
        v1 = v0 != null ? v0.getPropertyList() : null;
        if (v1 == null) {
            v1 = CollectionsKt.emptyList();
        }
        if (v1.size() > 1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = isInsertBeforeExistingSibling = false;
        }
        if (isInsertBeforeExistingSibling) {
            v3 = this.offsetAfterPreviousKeyValue((JsonProperty)this.getHighlightedElement());
            v4 = v3 != null ? v3.intValue() : this.offsetAfterKeyValueAndBrackets(nodeToInsertTo);
        } else {
            v4 = this.offsetAfterKeyValueAndBrackets(nodeToInsertTo);
        }
        return v4;
    }

    private final Integer offsetAfterPreviousKeyValue(JsonProperty element) {
        PsiElement psiElement = PsiTreeUtil.findSiblingBackward((PsiElement)((PsiElement)element), (IElementType)JsonElementTypes.PROPERTY, (boolean)true, null);
        return psiElement != null ? Integer.valueOf(PsiTreeUtilKt.getEndOffset((PsiElement)psiElement) + 1) : null;
    }

    private final int offsetAfterKeyValueAndBrackets(JsonProperty element) {
        int n;
        JsonValue propertyValueOrNull = element.getValue();
        if (propertyValueOrNull instanceof JsonArray) {
            n = PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)propertyValueOrNull)) + 1;
        } else if (propertyValueOrNull instanceof JsonObject) {
            n = PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)propertyValueOrNull)) + 1;
        } else {
            JsonValue jsonValue = element.getNameElement();
            Intrinsics.checkNotNullExpressionValue((Object)jsonValue, (String)"getNameElement(...)");
            n = PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)jsonValue)) + 1;
        }
        return n;
    }

    @Override
    @NotNull
    protected String formatTemplateText(@NotNull String templateText, @NotNull JsonStrategy insertionStrategy) {
        String string;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)templateText, (String)"templateText");
        Intrinsics.checkNotNullParameter((Object)insertionStrategy, (String)"insertionStrategy");
        StringBuilder $this$formatTemplateText_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (insertionStrategy.getAddArrayBrackets()) {
            $this$formatTemplateText_u24lambda_u240.append("[");
        }
        String templateTextAsJsonObject = SwVisualEditingTemplatesKt.addTemplateVariableMarkers(templateText);
        if (!insertionStrategy.getAddCurlyBraces()) {
            char[] cArray = new char[]{'{', '}'};
            string = StringsKt.trim((String)templateTextAsJsonObject, (char[])cArray);
        } else {
            string = templateTextAsJsonObject;
        }
        String effectiveTemplateText = string;
        $this$formatTemplateText_u24lambda_u240.append(effectiveTemplateText);
        if (insertionStrategy.getAddCommaAfter()) {
            $this$formatTemplateText_u24lambda_u240.append(",\n");
        }
        if (insertionStrategy.getAddArrayBrackets()) {
            $this$formatTemplateText_u24lambda_u240.append("]");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final JsonProperty chooseNodeToInsertTo(SwGenerationRelativePosition relativePosition) {
        return switch (WhenMappings.$EnumSwitchMapping$0[relativePosition.ordinal()]) {
            case 1 -> {
                void $this$parentOfType$iv;
                Object var2_2 = this.getHighlightedElement();
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                PsiElement v0 = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, JsonProperty.class, (boolean)true);
                Intrinsics.checkNotNull((Object)v0);
                yield (JsonProperty)v0;
            }
            case 2, 3 -> (JsonProperty)this.getHighlightedElement();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/swagger/core/visualEditing/templates/SwJsonTemplateLanguageAdapter$JsonStrategy;", "Lcom/intellij/swagger/core/visualEditing/templates/SwTemplateInsertionStrategy;", "addCommaAfter", "", "addArrayBrackets", "addCurlyBraces", "templateStartOffset", "", "(Lcom/intellij/swagger/core/visualEditing/templates/SwJsonTemplateLanguageAdapter;ZZZI)V", "getAddArrayBrackets", "()Z", "getAddCommaAfter", "getAddCurlyBraces", "intellij.swagger.core"})
    public final class JsonStrategy
    extends SwTemplateInsertionStrategy {
        private final boolean addCommaAfter;
        private final boolean addArrayBrackets;
        private final boolean addCurlyBraces;

        public JsonStrategy(boolean addCommaAfter, boolean addArrayBrackets, boolean addCurlyBraces, int templateStartOffset) {
            super(templateStartOffset, true, null);
            this.addCommaAfter = addCommaAfter;
            this.addArrayBrackets = addArrayBrackets;
            this.addCurlyBraces = addCurlyBraces;
        }

        public final boolean getAddCommaAfter() {
            return this.addCommaAfter;
        }

        public final boolean getAddArrayBrackets() {
            return this.addArrayBrackets;
        }

        public final boolean getAddCurlyBraces() {
            return this.addCurlyBraces;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SwGenerationRelativePosition.values().length];
            try {
                nArray[SwGenerationRelativePosition.PREVIOUS_SIBLING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwGenerationRelativePosition.SIMPLE_CHILD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwGenerationRelativePosition.COLLECTION_CHILD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

