/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.visualEditing.mouseProcessing;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.swagger.core.ui.SwaggerUIEditorProviderKt;
import com.intellij.swagger.core.visualEditing.SwVisualEditingActionsService;
import com.intellij.swagger.core.visualEditing.mouseProcessing.SwEditorMouseListenerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/swagger/core/visualEditing/mouseProcessing/SwEditorMouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "()V", "mouseMoved", "", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.swagger.core"})
public final class SwEditorMouseListener
implements EditorMouseMotionListener {
    @NotNull
    public static final SwEditorMouseListener INSTANCE = new SwEditorMouseListener();

    private SwEditorMouseListener() {
    }

    public void mouseMoved(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor = SwEditorMouseListenerKt.access$getMainEditorOrNull(event);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        Project project = editor2.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (!SwaggerUIEditorProviderKt.isSwaggerEditor(editor2)) {
            return;
        }
        int zeroBasedLineNumber = EditorUtil.yToLogicalLineNoCustomRenderers((Editor)editor2, (int)event.getMouseEvent().getY());
        if (zeroBasedLineNumber == -1) {
            return;
        }
        SwVisualEditingActionsService.Companion.getInstance(project2).mouseOverEditorLine(editor2, zeroBasedLineNumber);
    }
}

