/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui.rest.resource;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.ErrorType;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerResource;
import com.intellij.swagger.core.SwaggerResult;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.ui.rest.resource.SwPreviewResourceProviderKt;
import com.intellij.swagger.core.ui.rest.resource.SwaggerResourceProviderKt;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0002\u001a,\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0000\u001a,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0000\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\tH\u0002\u001a\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\b2\u0006\u0010\u0016\u001a\u00020\t2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0000\u001a\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\bH\u0000\" \u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001a"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logger$delegate", "Lkotlin/Lazy;", "findEffectiveLibraryPath", "Lcom/intellij/swagger/core/SwaggerResult;", "", "bundledLibraryPath", "getAllowedResourceFromLibrary", "Lcom/intellij/openapi/vfs/VirtualFile;", "allowList", "", "effectiveLibraryPath", "resourcePath", "getAllowedResourceFromLibraryWithUnknownVersion", "guessContentTypeByFileName", "fileName", "unknownResourceRequested", "Lcom/intellij/swagger/core/SwaggerResource;", "resourceIdentifier", "internalMessage", "wrapVirtualFileResult", "resourceFile", "intellij.swagger.core"})
public final class SwPreviewResourceProviderKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);

    @NotNull
    public static final SwaggerResult<SwaggerResource> unknownResourceRequested(@NotNull String resourceIdentifier, @Nullable String internalMessage) {
        Intrinsics.checkNotNullParameter((Object)resourceIdentifier, (String)"resourceIdentifier");
        Object[] objectArray = new Object[]{resourceIdentifier};
        String userVisibleErrorText = SwaggerBundle.message("preview.error.unknown.path", objectArray);
        String string = internalMessage;
        if (string == null) {
            string = userVisibleErrorText;
        }
        return SwaggerResult.Companion.failure(ErrorType.DOES_NOT_EXIST, userVisibleErrorText, string);
    }

    public static /* synthetic */ SwaggerResult unknownResourceRequested$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return SwPreviewResourceProviderKt.unknownResourceRequested(string, string2);
    }

    @NotNull
    public static final SwaggerResult<SwaggerResource> wrapVirtualFileResult(@NotNull SwaggerResult<VirtualFile> resourceFile) {
        SwaggerResult swaggerResult;
        Intrinsics.checkNotNullParameter(resourceFile, (String)"resourceFile");
        if (resourceFile.isFailure()) {
            return SwaggerResult.Companion.failure(resourceFile.getFailureOrThrow());
        }
        VirtualFile $this$wrapVirtualFileResult_u24lambda_u240 = resourceFile.getSuccessOrThrow();
        boolean bl = false;
        String string = $this$wrapVirtualFileResult_u24lambda_u240.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String contentType = SwPreviewResourceProviderKt.guessContentTypeByFileName(string);
        if (contentType == null) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)$this$wrapVirtualFileResult_u24lambda_u240.getName(), (String)"getName(...)");
            swaggerResult = SwaggerResult.Companion.failure$default(SwaggerResult.Companion, ErrorType.UNKNOWN, SwaggerBundle.message("preview.error.unknown.content.type", objectArray), null, 4, null);
        } else {
            $this$wrapVirtualFileResult_u24lambda_u240.setCharset(Charsets.UTF_8);
            byte[] byArray = $this$wrapVirtualFileResult_u24lambda_u240.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            swaggerResult = SwaggerResult.Companion.success(new SwaggerResource(byArray, contentType));
        }
        return swaggerResult;
    }

    @NotNull
    public static final SwaggerResult<VirtualFile> getAllowedResourceFromLibraryWithUnknownVersion(@NotNull Collection<String> allowList, @NotNull String bundledLibraryPath, @NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter(allowList, (String)"allowList");
        Intrinsics.checkNotNullParameter((Object)bundledLibraryPath, (String)"bundledLibraryPath");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        SwaggerResult<String> effectiveLibraryPath = SwPreviewResourceProviderKt.findEffectiveLibraryPath(bundledLibraryPath);
        return effectiveLibraryPath.isFailure() ? SwaggerResult.Companion.failure(effectiveLibraryPath.getFailureOrThrow()) : SwPreviewResourceProviderKt.getAllowedResourceFromLibrary(allowList, effectiveLibraryPath.getSuccessOrThrow(), resourcePath);
    }

    @NotNull
    public static final SwaggerResult<VirtualFile> getAllowedResourceFromLibrary(@NotNull Collection<String> allowList, @NotNull String effectiveLibraryPath, @NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter(allowList, (String)"allowList");
        Intrinsics.checkNotNullParameter((Object)effectiveLibraryPath, (String)"effectiveLibraryPath");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        if (!allowList.contains(resourcePath)) {
            Object[] objectArray = new Object[]{resourcePath};
            return SwaggerResult.Companion.failure(ErrorType.NOT_ALLOWED, SwaggerBundle.message("preview.error.resource.unknown.text", objectArray), "Resource is not in allow list: " + resourcePath);
        }
        return SwaggerResourceProviderKt.getVirtualFileResult(effectiveLibraryPath + "/" + resourcePath);
    }

    private static final SwaggerResult<String> findEffectiveLibraryPath(String bundledLibraryPath) {
        String libVersion;
        VirtualFile virtualFile2 = SwaggerUtilsKt.getBundledResource(bundledLibraryPath);
        String string = virtualFile2 != null && (virtualFile2 = virtualFile2.getChildren()) != null && (virtualFile2 = (VirtualFile)ArraysKt.singleOrNull((Object[])virtualFile2)) != null ? virtualFile2.getName() : (libVersion = null);
        if (libVersion == null) {
            Object[] objectArray = new Object[]{bundledLibraryPath};
            return SwaggerResult.Companion.failure(ErrorType.DOES_NOT_EXIST, SwaggerBundle.message("preview.error.resource.unknown.text", objectArray), "Library version is not found for resource: " + bundledLibraryPath);
        }
        return SwaggerResult.Companion.success(bundledLibraryPath + "/" + libVersion);
    }

    private static final String guessContentTypeByFileName(String fileName) {
        String string;
        if (StringsKt.endsWith$default((String)fileName, (String)".js", (boolean)false, (int)2, null)) {
            string = "application/javascript";
        } else if (StringsKt.endsWith$default((String)fileName, (String)".css", (boolean)false, (int)2, null)) {
            string = "text/css";
        } else if (StringsKt.endsWith$default((String)fileName, (String)".json", (boolean)false, (int)2, null)) {
            string = "application/json";
        } else if (StringsKt.endsWith$default((String)fileName, (String)".png", (boolean)false, (int)2, null)) {
            string = "image/png";
        } else if (StringsKt.endsWith$default((String)fileName, (String)".svg", (boolean)false, (int)2, null)) {
            string = "image/svg+xml";
        } else if (StringsKt.endsWith$default((String)fileName, (String)".yaml", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".yml", (boolean)false, (int)2, null)) {
            string = "application/yaml";
        } else {
            SwPreviewResourceProviderKt.getLogger().warn("Could not guess content type for: " + fileName);
            string = null;
        }
        return string;
    }

    private static final Logger getLogger() {
        Lazy lazy = logger$delegate;
        return (Logger)lazy.getValue();
    }
}

