/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui.rest.resource;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerFailure;
import com.intellij.swagger.core.SwaggerNavigableError;
import com.intellij.swagger.core.SwaggerResource;
import com.intellij.swagger.core.SwaggerResult;
import com.intellij.swagger.core.SwaggerValidationError;
import com.intellij.swagger.core.ui.rest.RequestHandlerHelperKt;
import com.intellij.swagger.core.ui.rest.SwSpecFileProviderKt;
import com.intellij.swagger.core.ui.rest.SwUrlBuilderKt;
import com.intellij.swagger.core.ui.rest.resource.ErrorHandlerKt;
import com.intellij.swagger.core.ui.rest.resource.SwPreviewResourceProvider;
import com.intellij.swagger.core.ui.rest.resource.SwaggerResourceProviderKt;
import com.intellij.util.ui.StartupUiUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0001\u001a \u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\b\u0010\u0016\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"ERROR_CSS", "", "ERROR_CSS_DARK", "ERROR_HTML_PAGE_URL_VARIABLE", "ERROR_LIST_VARIABLE", "ERROR_PAGE", "ERROR_SCRIPT", "NAVIGATE_TO_LINK", "PRESENTABLE_ERROR_TEXT_VARIABLE", "ROOT_CONTAINER_ID_VARIABLE", "VALIDATION_ERROR_TEMPLATE", "generateErrorView", "error", "Lcom/intellij/swagger/core/SwaggerFailure;", "generateNavigableLink", "name", "relativePath", "coordinates", "Lcom/intellij/openapi/util/text/LineColumn;", "generateValidationErrorView", "validationError", "Lcom/intellij/swagger/core/SwaggerValidationError;", "getCss", "getErrorHandlingScript", "Lcom/intellij/swagger/core/SwaggerResult;", "Lcom/intellij/swagger/core/SwaggerResource;", "resourceProvider", "Lcom/intellij/swagger/core/ui/rest/resource/SwPreviewResourceProvider;", "getErrorHtml", "getErrorHtmlTemplate", "intellij.swagger.core"})
public final class ErrorHandlerKt {
    @NotNull
    private static final String NAVIGATE_TO_LINK = "https://localhost/navigateToFile";
    @NotNull
    private static final String ERROR_PAGE = "htmlTemplates/error.html";
    @NotNull
    private static final String VALIDATION_ERROR_TEMPLATE = "htmlTemplates/validation-error.html";
    @NotNull
    private static final String ERROR_SCRIPT = "js/error.js";
    @NotNull
    private static final String ERROR_CSS = "css/error/error.css";
    @NotNull
    private static final String ERROR_CSS_DARK = "css/error/error-dark.css";
    @NotNull
    private static final String PRESENTABLE_ERROR_TEXT_VARIABLE = "{ERROR}";
    @NotNull
    private static final String ROOT_CONTAINER_ID_VARIABLE = "{CONTAINER_NAME}";
    @NotNull
    private static final String ERROR_HTML_PAGE_URL_VARIABLE = "{ERROR_HTML_PAGE_URL}";
    @NotNull
    private static final String ERROR_LIST_VARIABLE = "{ERROR_LIST}";

    @NotNull
    public static final SwaggerResult<SwaggerResource> getErrorHandlingScript(@NotNull SwPreviewResourceProvider resourceProvider) {
        Intrinsics.checkNotNullParameter((Object)resourceProvider, (String)"resourceProvider");
        SwaggerResult<String> script = SwaggerResourceProviderKt.getBundledResourceResult(ERROR_SCRIPT);
        if (script.isFailure()) {
            return SwaggerResult.Companion.failure(script.getFailureOrThrow());
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ROOT_CONTAINER_ID_VARIABLE, (Object)resourceProvider.getHtmlMainContainerId()), TuplesKt.to((Object)ERROR_HTML_PAGE_URL_VARIABLE, (Object)SwUrlBuilderKt.buildErrorHtmlPageAccessUrl(resourceProvider.getPreviewType()))};
        String scriptWithFulfilledValues = SwSpecFileProviderKt.inlineVariablesIntoTemplate(script.getSuccessOrThrow(), MapsKt.mapOf((Pair[])pairArray));
        byte[] byArray = scriptWithFulfilledValues.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return SwaggerResult.Companion.success(new SwaggerResource(byArray, "application/javascript"));
    }

    @NotNull
    public static final SwaggerResult<SwaggerResource> getErrorHtml(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        SwaggerResult<String> html = SwaggerResourceProviderKt.getBundledResourceResult(ERROR_PAGE);
        if (html.isFailure()) {
            return SwaggerResult.Companion.failure(html.getFailureOrThrow());
        }
        String errorHtml = SwSpecFileProviderKt.inlineVariablesIntoTemplate(html.getSuccessOrThrow(), MapsKt.mapOf((Pair)TuplesKt.to((Object)PRESENTABLE_ERROR_TEXT_VARIABLE, (Object)error)));
        byte[] byArray = RequestHandlerHelperKt.applyCss(errorHtml, ErrorHandlerKt.getCss()).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return SwaggerResult.Companion.success(new SwaggerResource(byArray, "text/html"));
    }

    @NlsSafe
    @NotNull
    public static final String generateErrorView(@NotNull SwaggerFailure error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (error.getSwaggerValidationErrors().isEmpty()) {
            return error.getMessage();
        }
        String errorList2 = CollectionsKt.joinToString$default((Iterable)error.getSwaggerValidationErrors(), (CharSequence)"\n", null, null, (int)0, null, (Function1)generateErrorView.errorList.1.INSTANCE, (int)30, null);
        String template = SwaggerResourceProviderKt.getBundledResourceStringOrEmpty(VALIDATION_ERROR_TEMPLATE);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PRESENTABLE_ERROR_TEXT_VARIABLE, (Object)error.getMessage()), TuplesKt.to((Object)ERROR_LIST_VARIABLE, (Object)errorList2)};
        return SwSpecFileProviderKt.inlineVariablesIntoTemplate(template, MapsKt.mapOf((Pair[])pairArray));
    }

    private static final String generateValidationErrorView(SwaggerValidationError validationError) {
        Object object;
        block3: {
            block2: {
                object = validationError.getInvalidSource();
                if (object == null) break block2;
                SwaggerNavigableError it = object;
                boolean bl = false;
                Object[] objectArray = new Object[]{ErrorHandlerKt.generateNavigableLink(it.getName(), it.getRelativeFilePath(), it.getCoordinates())};
                String text = SwaggerBundle.message("preview.error.validation.syntax.error", objectArray);
                String string = "<br>" + text;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        Object sourceInvalidReferenceText = object;
        String referenceLinks2 = CollectionsKt.joinToString$default((Iterable)validationError.getReferenceCoordinates(), (CharSequence)"<br>", null, null, (int)0, null, (Function1)((Function1)new Function1<LineColumn, CharSequence>(validationError){
            final /* synthetic */ SwaggerValidationError $validationError;
            {
                this.$validationError = $validationError;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull LineColumn coordinates) {
                Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
                return ErrorHandlerKt.access$generateNavigableLink(this.$validationError.getOriginalReferenceName(), this.$validationError.getOriginalRelativePath(), coordinates);
            }
        }), (int)30, null);
        return StringsKt.trimIndent((String)("\n    <div>\n    " + validationError.getErrorText() + "<br>\n    " + referenceLinks2 + "\n    " + (String)sourceInvalidReferenceText + "\n    </div>\n  "));
    }

    private static final String generateNavigableLink(String name2, String relativePath, LineColumn coordinates) {
        String linkText = name2 + ":" + (coordinates.line + 1) + ":" + (coordinates.column + 1);
        return "<a href=https://localhost/navigateToFile?path=" + relativePath + "&line=" + coordinates.line + "&column=" + coordinates.column + ">" + linkText + "</a>";
    }

    @NotNull
    public static final SwaggerResult<SwaggerResource> getErrorHtmlTemplate() {
        SwaggerResult<String> html = SwaggerResourceProviderKt.getBundledResourceResult(ERROR_PAGE);
        if (html.isFailure()) {
            return SwaggerResult.Companion.failure(html.getFailureOrThrow());
        }
        String errorHandlerHtml = html.getSuccessOrThrow();
        byte[] byArray = RequestHandlerHelperKt.applyCss(errorHandlerHtml, ErrorHandlerKt.getCss()).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return SwaggerResult.Companion.success(new SwaggerResource(byArray, "text/html"));
    }

    private static final String getCss() {
        String string;
        boolean isDarcula = StartupUiUtil.isUnderDarcula();
        String css = SwaggerResourceProviderKt.getBundledResourceStringOrEmpty(ERROR_CSS) + SwaggerResourceProviderKt.getScrollbarCss();
        if (isDarcula) {
            String darculaCss = SwaggerResourceProviderKt.getBundledResourceStringOrEmpty(ERROR_CSS_DARK);
            string = css + darculaCss;
        } else {
            string = css;
        }
        return string;
    }

    public static final /* synthetic */ String access$generateValidationErrorView(SwaggerValidationError validationError) {
        return ErrorHandlerKt.generateValidationErrorView(validationError);
    }

    public static final /* synthetic */ String access$generateNavigableLink(String name2, String relativePath, LineColumn coordinates) {
        return ErrorHandlerKt.generateNavigableLink(name2, relativePath, coordinates);
    }
}

