/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui.browser.strategy;

import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.ui.SwPreviewType;
import com.intellij.swagger.core.ui.browser.strategy.AsyncApiProviderStrategy;
import com.intellij.swagger.core.ui.browser.strategy.SwPreviewCustomization;
import com.intellij.swagger.core.ui.browser.strategy.SwPreviewProviderStrategy;
import com.intellij.swagger.core.ui.utils.AsyncapiJsUtilsKt;
import com.intellij.swagger.core.ui.utils.SwCommonJsUtilsKt;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefJSQuery;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/swagger/core/ui/browser/strategy/AsyncApiProviderStrategy;", "Lcom/intellij/swagger/core/ui/browser/strategy/SwPreviewProviderStrategy;", "()V", "installOn", "Lcom/intellij/swagger/core/ui/browser/strategy/SwPreviewCustomization;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "cefBrowser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "AsyncApiPreviewCustomization", "intellij.swagger.core"})
public final class AsyncApiProviderStrategy
implements SwPreviewProviderStrategy {
    @NotNull
    public static final AsyncApiProviderStrategy INSTANCE = new AsyncApiProviderStrategy();

    private AsyncApiProviderStrategy() {
    }

    @Override
    @NotNull
    public SwPreviewCustomization installOn(@NotNull TextEditor textEditor, @NotNull JBCefBrowser cefBrowser, @NotNull VirtualFile virtualFile2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
        Intrinsics.checkNotNullParameter((Object)cefBrowser, (String)"cefBrowser");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)cefBrowser));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
        JBCefJSQuery scrollQuery = jBCefJSQuery;
        CefLoadHandlerAdapter scrollHandler2 = SwCommonJsUtilsKt.setupCefLoadHandler(scrollQuery, cefBrowser, (Function2<? super JBCefJSQuery, ? super JBCefBrowser, Unit>)((Function2)installOn.scrollHandler.1.INSTANCE));
        Function1<String, JBCefJSQuery.Response> previewToEditorNavigationHandler = SwCommonJsUtilsKt.setupNavigationFromPreviewToEditor(scrollQuery, textEditor, project);
        CaretListener navigationEditorCaretListener = SwCommonJsUtilsKt.setupNavigationEditorCaretListener(cefBrowser, textEditor, project, AsyncapiJsUtilsKt::scrollToAsyncapiEndpoint, AsyncapiJsUtilsKt::scrollToAsyncapiModel);
        CefLifeSpanHandler urlBrowseHandler = SwCommonJsUtilsKt.setupBrowseUrlHandler(cefBrowser);
        return new AsyncApiPreviewCustomization(scrollQuery, (CefLoadHandler)scrollHandler2, previewToEditorNavigationHandler, navigationEditorCaretListener, urlBrowseHandler);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lcom/intellij/swagger/core/ui/browser/strategy/AsyncApiProviderStrategy$AsyncApiPreviewCustomization;", "Lcom/intellij/swagger/core/ui/browser/strategy/SwPreviewCustomization;", "myScrollQuery", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "myScrollHandler", "Lorg/cef/handler/CefLoadHandler;", "myPreviewToEditorNavigationHandler", "Lkotlin/Function1;", "", "Lcom/intellij/ui/jcef/JBCefJSQuery$Response;", "myEditorCaretListener", "Lcom/intellij/openapi/editor/event/CaretListener;", "urlBrowseHandler", "Lorg/cef/handler/CefLifeSpanHandler;", "(Lcom/intellij/ui/jcef/JBCefJSQuery;Lorg/cef/handler/CefLoadHandler;Lkotlin/jvm/functions/Function1;Lcom/intellij/openapi/editor/event/CaretListener;Lorg/cef/handler/CefLifeSpanHandler;)V", "getMyEditorCaretListener", "()Lcom/intellij/openapi/editor/event/CaretListener;", "getMyPreviewToEditorNavigationHandler", "()Lkotlin/jvm/functions/Function1;", "getMyScrollHandler", "()Lorg/cef/handler/CefLoadHandler;", "getMyScrollQuery", "()Lcom/intellij/ui/jcef/JBCefJSQuery;", "previewType", "Lcom/intellij/swagger/core/ui/SwPreviewType;", "getPreviewType", "()Lcom/intellij/swagger/core/ui/SwPreviewType;", "getUrlBrowseHandler", "()Lorg/cef/handler/CefLifeSpanHandler;", "removeFrom", "", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "cefBrowser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "intellij.swagger.core"})
    private static final class AsyncApiPreviewCustomization
    implements SwPreviewCustomization {
        @NotNull
        private final JBCefJSQuery myScrollQuery;
        @NotNull
        private final CefLoadHandler myScrollHandler;
        @NotNull
        private final Function1<String, JBCefJSQuery.Response> myPreviewToEditorNavigationHandler;
        @NotNull
        private final CaretListener myEditorCaretListener;
        @NotNull
        private final CefLifeSpanHandler urlBrowseHandler;
        @NotNull
        private final SwPreviewType previewType;

        public AsyncApiPreviewCustomization(@NotNull JBCefJSQuery myScrollQuery, @NotNull CefLoadHandler myScrollHandler, @NotNull Function1<? super String, ? extends JBCefJSQuery.Response> myPreviewToEditorNavigationHandler, @NotNull CaretListener myEditorCaretListener, @NotNull CefLifeSpanHandler urlBrowseHandler) {
            Intrinsics.checkNotNullParameter((Object)myScrollQuery, (String)"myScrollQuery");
            Intrinsics.checkNotNullParameter((Object)myScrollHandler, (String)"myScrollHandler");
            Intrinsics.checkNotNullParameter(myPreviewToEditorNavigationHandler, (String)"myPreviewToEditorNavigationHandler");
            Intrinsics.checkNotNullParameter((Object)myEditorCaretListener, (String)"myEditorCaretListener");
            Intrinsics.checkNotNullParameter((Object)urlBrowseHandler, (String)"urlBrowseHandler");
            this.myScrollQuery = myScrollQuery;
            this.myScrollHandler = myScrollHandler;
            this.myPreviewToEditorNavigationHandler = myPreviewToEditorNavigationHandler;
            this.myEditorCaretListener = myEditorCaretListener;
            this.urlBrowseHandler = urlBrowseHandler;
            this.previewType = SwPreviewType.ASYNCAPI;
        }

        @NotNull
        public final JBCefJSQuery getMyScrollQuery() {
            return this.myScrollQuery;
        }

        @NotNull
        public final CefLoadHandler getMyScrollHandler() {
            return this.myScrollHandler;
        }

        @NotNull
        public final Function1<String, JBCefJSQuery.Response> getMyPreviewToEditorNavigationHandler() {
            return this.myPreviewToEditorNavigationHandler;
        }

        @NotNull
        public final CaretListener getMyEditorCaretListener() {
            return this.myEditorCaretListener;
        }

        @NotNull
        public final CefLifeSpanHandler getUrlBrowseHandler() {
            return this.urlBrowseHandler;
        }

        @Override
        @NotNull
        public SwPreviewType getPreviewType() {
            return this.previewType;
        }

        @Override
        public void removeFrom(@NotNull TextEditor textEditor, @NotNull JBCefBrowser cefBrowser) {
            Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
            Intrinsics.checkNotNullParameter((Object)cefBrowser, (String)"cefBrowser");
            SwCommonJsUtilsKt.removeCefLoadHandler(cefBrowser, this.myScrollHandler);
            SwCommonJsUtilsKt.removeJsHandler(this.myScrollQuery, this.myPreviewToEditorNavigationHandler);
            SwCommonJsUtilsKt.removeEditorCaretListener(textEditor, this.myEditorCaretListener);
            SwCommonJsUtilsKt.removeCefLifeSpanHandler(cefBrowser, this.urlBrowseHandler);
        }
    }
}

