/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.settings.SwaggerSettings;
import com.intellij.swagger.core.settings.SwaggerSettingsState;
import com.intellij.swagger.core.ui.SwPreviewType;
import com.intellij.swagger.core.ui.SwaggerEditorWithPreview;
import com.intellij.swagger.core.ui.actions.SwEditorActionsUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/swagger/core/ui/actions/SwDynamicSwitchPreviewProviderAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getControversialPreviewType", "Lcom/intellij/swagger/core/ui/SwPreviewType;", "selectedPreviewType", "update", "updatePluginSettings", "newPreviewType", "project", "Lcom/intellij/openapi/project/Project;", "intellij.swagger.core"})
public final class SwDynamicSwitchPreviewProviderAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation $this$update_u24lambda_u240 = presentation = e.getPresentation();
        boolean bl = false;
        SwPreviewType selectedPreviewType = SwEditorActionsUtilsKt.getSelectedPreviewType(e);
        if (selectedPreviewType == null || selectedPreviewType == SwPreviewType.ASYNCAPI) {
            $this$update_u24lambda_u240.setEnabledAndVisible(false);
        } else {
            $this$update_u24lambda_u240.setEnabledAndVisible(SwEditorActionsUtilsKt.isSwaggerSplitEditorWithVisiblePreview(e) && Registry.is((String)"swagger.redoc.preview.enabled.key"));
            SwPreviewType controversialPreviewType = this.getControversialPreviewType(selectedPreviewType);
            Object[] objectArray = new Object[]{controversialPreviewType.getPresentableName()};
            $this$update_u24lambda_u240.setText(SwaggerBundle.message("ui.switch.to.0.preview.type", objectArray));
            $this$update_u24lambda_u240.setIcon(controversialPreviewType.getIcon());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        SwaggerEditorWithPreview swaggerEditorWithPreview = SwEditorActionsUtilsKt.getSwaggerSplitEditor(e);
        if (swaggerEditorWithPreview == null) {
            return;
        }
        SwaggerEditorWithPreview swaggerEditor = swaggerEditorWithPreview;
        SwPreviewType newPreviewType = this.getControversialPreviewType(swaggerEditor.getSelectedPreviewType());
        this.updatePluginSettings(newPreviewType, e.getProject());
        swaggerEditor.switchPreviewType(newPreviewType);
    }

    private final SwPreviewType getControversialPreviewType(SwPreviewType selectedPreviewType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[selectedPreviewType.ordinal()]) {
            case 1 -> SwPreviewType.REDOC;
            case 2 -> SwPreviewType.SWAGGER_UI;
            default -> selectedPreviewType;
        };
    }

    private final void updatePluginSettings(SwPreviewType newPreviewType, Project project) {
        if (newPreviewType == SwPreviewType.ASYNCAPI || project == null) {
            return;
        }
        ((SwaggerSettingsState)SwaggerSettings.Companion.getInstance(project).getState()).setDefaultPreviewType(newPreviewType);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SwPreviewType.values().length];
            try {
                nArray[SwPreviewType.SWAGGER_UI.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwPreviewType.REDOC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

