/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.swagger.core.SwSpecificationDetectionKt;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.model.specification.SwaggerFileHelper;
import com.intellij.swagger.core.settings.SwaggerSettings;
import com.intellij.swagger.core.settings.SwaggerSettingsState;
import com.intellij.swagger.core.ui.SwPreviewType;
import com.intellij.swagger.core.ui.SwaggerEditorWithPreview;
import com.intellij.swagger.core.ui.SwaggerUIEditorProviderKt;
import com.intellij.swagger.core.ui.browser.SwPreviewCefBrowser;
import com.intellij.swagger.core.ui.browser.strategy.AsyncApiProviderStrategy;
import com.intellij.swagger.core.ui.browser.strategy.RedocProviderStrategy;
import com.intellij.swagger.core.ui.browser.strategy.SwPreviewProviderStrategy;
import com.intellij.swagger.core.ui.browser.strategy.SwaggerUiProviderStrategy;
import com.intellij.ui.jcef.JBCefApp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/swagger/core/ui/SwaggerUIEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "acceptRequiresReadAction", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "createTextEditor", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "rememberItIsSwaggerEditor", "", "fileEditor", "intellij.swagger.core"})
final class SwaggerUIEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!SwaggerFileHelper.INSTANCE.isSuitableFileType$intellij_swagger_core(file2)) {
            return false;
        }
        Object object = ApplicationManager.getApplication().runReadAction(() -> SwaggerUIEditorProvider.accept$lambda$0(project, file2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        return (Boolean)object;
    }

    public boolean acceptRequiresReadAction() {
        return false;
    }

    @NotNull
    public String getEditorTypeId() {
        return "intellij.swagger.ui.editor.with.preview";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FileEditor generalEditor = this.createTextEditor(project, file2);
        PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(file2);
        if (!JBCefApp.isSupported() || !(generalEditor instanceof TextEditor) || psiFile2 == null) {
            return generalEditor;
        }
        SwSpecificationType specificationType2 = SwSpecificationDetectionKt.detectPrimarySpecificationType(file2, psiFile2);
        SwPreviewType lastSelectedPreviewType = ((SwaggerSettingsState)SwaggerSettings.Companion.getInstance(project).getState()).getDefaultPreviewType();
        if (specificationType2 instanceof SwSpecificationType.NONE) {
            return generalEditor;
        }
        SwPreviewProviderStrategy previewProvider = specificationType2 instanceof SwSpecificationType.ASYNCAPI_2_6 ? (SwPreviewProviderStrategy)AsyncApiProviderStrategy.INSTANCE : (lastSelectedPreviewType == SwPreviewType.REDOC && Registry.is((String)"swagger.redoc.preview.enabled.key") ? (SwPreviewProviderStrategy)RedocProviderStrategy.INSTANCE : (SwPreviewProviderStrategy)SwaggerUiProviderStrategy.INSTANCE);
        return (FileEditor)new SwaggerEditorWithPreview((TextEditor)generalEditor, new SwPreviewCefBrowser(file2, (TextEditor)generalEditor, project, previewProvider));
    }

    private final FileEditor createTextEditor(Project project, VirtualFile file2) {
        FileEditor editor = TextEditorProvider.Companion.getInstance().createEditor(project, file2);
        this.rememberItIsSwaggerEditor(editor);
        return editor;
    }

    private final void rememberItIsSwaggerEditor(FileEditor fileEditor) {
        if (fileEditor instanceof TextEditor) {
            ((TextEditor)fileEditor).getEditor().putUserData(SwaggerUIEditorProviderKt.access$getSWAGGER_EDITOR_KEY$p(), (Object)true);
        } else {
            fileEditor.putUserData(SwaggerUIEditorProviderKt.access$getSWAGGER_EDITOR_KEY$p(), (Object)true);
        }
    }

    private static final Boolean accept$lambda$0(Project $project, VirtualFile $file) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        PsiFile psiFile2 = PsiManager.getInstance((Project)$project).findFile($file);
        if (psiFile2 == null) {
            return false;
        }
        PsiFile psiFile3 = psiFile2;
        SwSpecificationType primarySpecificationType = SwSpecificationDetectionKt.detectPrimarySpecificationType($file, psiFile3);
        return !(primarySpecificationType instanceof SwSpecificationType.NONE);
    }
}

