/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.ErrorType;
import com.intellij.swagger.core.SwJacksonObjectMapperFactoryKt;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerFailure;
import com.intellij.swagger.core.SwaggerResult;
import com.intellij.swagger.core.SwaggerValidationError;
import com.intellij.swagger.core.model.SwObjectDefinitionUtilsKt;
import com.intellij.swagger.core.model.api.SwDefinition;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.providers.SwJsonSchemaPatchUtils;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import com.intellij.swagger.core.ui.NameMapping;
import com.intellij.swagger.core.ui.NameSuggester;
import com.intellij.swagger.core.ui.ReferenceData;
import com.intellij.swagger.core.ui.SpecificationData;
import com.intellij.swagger.core.ui.SpecificationReferenceValidationHelperKt;
import com.intellij.swagger.core.ui.SpecificationReferencesInlineHelper;
import com.intellij.swagger.core.ui.ValidationData;
import com.intellij.util.containers.FactoryMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u0000 T2\u00020\u0001:\u0001TB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J#\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0019H\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0019H\u0002J \u0010\u001e\u001a\u00020\t2\u0016\b\u0002\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0006H\u0002J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\"2\u0006\u0010#\u001a\u00020\u000fH\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010\u00072\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J:\u0010&\u001a\u0004\u0018\u00010\t2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+H\u0002J@\u0010,\u001a\u0004\u0018\u00010\t2\u0006\u0010-\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/2\u0006\u0010*\u001a\u00020+2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010'\u001a\u00020\u0003H\u0002J0\u00101\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/2\u0006\u00102\u001a\u00020\u00072\u000e\b\u0002\u00103\u001a\b\u0012\u0004\u0012\u00020\u000f04H\u0002J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u000fH\u0002J\u001b\u00108\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u00109\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b:J3\u0010;\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000b0<0\u00172\u0006\u00109\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b=J\u0018\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\u0010H\u0002J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\u00172\u0006\u00109\u001a\u00020\u0019H\u0002J\u001a\u0010D\u001a\u0004\u0018\u00010\t2\u0006\u0010E\u001a\u00020\u00072\u0006\u0010F\u001a\u00020GH\u0002J\u001a\u0010H\u001a\u0004\u0018\u00010\u00072\u0006\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\u000fH\u0002J\u001e\u0010K\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010<2\u0006\u0010L\u001a\u00020\u000fH\u0002J0\u0010M\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/2\u0006\u0010N\u001a\u0002062\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J(\u0010O\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010P\u001a\u00020\r2\u0006\u0010E\u001a\u00020\u0007H\u0002J \u0010Q\u001a\u00020\t2\u0006\u0010R\u001a\u00020\t2\u0006\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u00020\u0003H\u0002J\u0018\u0010S\u001a\u00020\t2\u0006\u0010R\u001a\u00020\t2\u0006\u0010.\u001a\u00020/H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RV\u0010\u0005\u001aJ\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t \b*#\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t0\u000b\u00a2\u0006\u0002\b\n0\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/intellij/swagger/core/ui/SpecificationReferencesInlineHelper;", "", "inlineDepthLimit", "", "(I)V", "jsonFilesCache", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lcom/fasterxml/jackson/databind/JsonNode;", "Lorg/jetbrains/annotations/NotNull;", "", "jsonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "unresolvedReferences", "", "Lcom/intellij/swagger/core/ui/ValidationData;", "yamlObjectMapper", "collectReferenceData", "Lcom/intellij/swagger/core/ui/ReferenceData;", "originalReferenceValue", "containingFile", "convertJsonToYaml", "Lcom/intellij/swagger/core/SwaggerResult;", "specificationText", "Lcom/intellij/psi/PsiFile;", "convertJsonToYaml$intellij_swagger_core", "convertToJsonIfNeeded", "rawFileText", "convertYamlToJson", "createJsonNode", "children", "escapeIllegalCharacters", "findAllReferences", "Lkotlin/sequences/Sequence;", "jsonSpecification", "findReferencedFile", "filePath", "getObjectDefinition", "depth", "refData", "rootReferenceName", "nameSuggester", "Lcom/intellij/swagger/core/ui/NameSuggester;", "inlineDefinitionsWithDepth", "jsonNode", "specificationType", "Lcom/intellij/swagger/core/SwSpecificationType;", "rootReference", "inlineExternalDefinitions", "topLevelSpecificationFile", "knownDefinitionNames", "", "isLocalReference", "", "referenceBody", "prepareSpecificationText", "psiFile", "prepareSpecificationText$intellij_swagger_core", "prepareSpecificationTextWithValidation", "Lkotlin/Pair;", "prepareSpecificationTextWithValidation$intellij_swagger_core", "putToUnresolved", "", "referenceName", "validationData", "readDataFromSpecification", "Lcom/intellij/swagger/core/ui/SpecificationData;", "readObjectDefinition", "file", "nameMapping", "Lcom/intellij/swagger/core/ui/NameMapping;", "resolveRelativeFilePath", "specification", "relativePath", "splitReference", "value", "substituteExternalReferences", "substituteLocalReferences", "suggestInlinedObjectPath", "suitableMapperFor", "wrapDefinitionIfNeeded", "definitionsNode", "wrapDefinitions", "Companion", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSpecificationReferencesInlineHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecificationReferencesInlineHelper.kt\ncom/intellij/swagger/core/ui/SpecificationReferencesInlineHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 SwTreeUtil.kt\ncom/intellij/swagger/core/traverser/SwTreeUtil\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,379:1\n23#2:380\n23#2:387\n13#2:397\n23#2:399\n23#2:400\n13#2:401\n35#3,2:381\n1549#4:383\n1620#4,3:384\n1789#4,2:395\n1791#4:398\n2281#5,7:388\n*S KotlinDebug\n*F\n+ 1 SpecificationReferencesInlineHelper.kt\ncom/intellij/swagger/core/ui/SpecificationReferencesInlineHelper\n*L\n87#1:380\n139#1:387\n224#1:397\n244#1:399\n255#1:400\n289#1:401\n94#1:381,2\n105#1:383\n105#1:384,3\n222#1:395,2\n222#1:398\n170#1:388,7\n*E\n"})
public final class SpecificationReferencesInlineHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int inlineDepthLimit;
    @NotNull
    private final Map<String, ValidationData> unresolvedReferences;
    @NotNull
    private final ObjectMapper jsonObjectMapper;
    @NotNull
    private final ObjectMapper yamlObjectMapper;
    @NotNull
    private final Map<VirtualFile, JsonNode> jsonFilesCache;
    private static final int MAXIMUM_INLINE_DEPTH = 10;
    @NotNull
    private static final Regex REFERENCE_PATTERN = new Regex("\"\\$ref\"\\s*:\\s*\"([^\"]*)\"");
    private static final int REFERENCE_BODY_GROUP_INDEX = 1;
    @NotNull
    private static final Regex REFERENCE_STRUCTURE_PATTERN = new Regex("(.*)#/(.*)");
    private static final int EXTERNAL_FILE_GROUP_INDEX = 1;
    private static final int DEFINITION_PATH_GROUP_INDEX = 2;

    public SpecificationReferencesInlineHelper(int inlineDepthLimit) {
        this.inlineDepthLimit = inlineDepthLimit;
        this.unresolvedReferences = new LinkedHashMap();
        this.jsonObjectMapper = SwJacksonObjectMapperFactoryKt.createJsonJacksonMapper();
        this.yamlObjectMapper = SwJacksonObjectMapperFactoryKt.createYamlJacksonMapper();
        Map map2 = FactoryMap.create(arg_0 -> SpecificationReferencesInlineHelper.jsonFilesCache$lambda$0((Function1)new Function1<VirtualFile, JsonNode>(this){
            final /* synthetic */ SpecificationReferencesInlineHelper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final JsonNode invoke(VirtualFile it) {
                JsonNode jsonNode;
                try {
                    Intrinsics.checkNotNull((Object)it);
                    jsonNode = SpecificationReferencesInlineHelper.access$suitableMapperFor(this.this$0, it).readTree(it.getInputStream());
                }
                catch (IOException exception) {
                    boolean $i$f$logger = false;
                    Logger logger2 = Logger.getInstance(SpecificationReferencesInlineHelper.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                    logger2.warn("Unable to parse external file with object definitions: " + it.getName(), (Throwable)exception);
                    jsonNode = null;
                }
                return jsonNode;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"create(...)");
        this.jsonFilesCache = map2;
    }

    public /* synthetic */ SpecificationReferencesInlineHelper(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    private final ObjectMapper suitableMapperFor(VirtualFile file2) {
        return file2.getFileType() instanceof JsonFileType ? this.jsonObjectMapper : this.yamlObjectMapper;
    }

    @NotNull
    public final SwaggerResult<Pair<String, Map<String, ValidationData>>> prepareSpecificationTextWithValidation$intellij_swagger_core(@NotNull PsiFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        SwaggerResult<String> specificationResult = this.prepareSpecificationText$intellij_swagger_core(psiFile2);
        if (specificationResult.isFailure()) {
            SwaggerFailure swaggerFailure = specificationResult.getSwaggerFailure();
            Intrinsics.checkNotNull((Object)swaggerFailure);
            return SwaggerResult.Companion.failure(swaggerFailure);
        }
        String string = specificationResult.getSuccess();
        Intrinsics.checkNotNull((Object)string);
        return SwaggerResult.Companion.success(TuplesKt.to((Object)string, this.unresolvedReferences));
    }

    @NotNull
    public final SwaggerResult<String> prepareSpecificationText$intellij_swagger_core(@NotNull PsiFile psiFile2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        ProgressManager.checkCanceled();
        Object object = ReadAction.nonBlocking(() -> SpecificationReferencesInlineHelper.prepareSpecificationText$lambda$1(this, psiFile2)).withDocumentsCommitted(psiFile2.getProject()).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
        SwaggerResult result2 = (SwaggerResult)object;
        if (result2.isFailure()) {
            return SwaggerResult.Companion.failure(result2.getFailureOrThrow());
        }
        SpecificationData specificationData = (SpecificationData)result2.getSuccessOrThrow();
        SwSpecificationType specificationType2 = specificationData.component1();
        Collection<String> ownDefinitionNames = specificationData.component2();
        String specificationText = specificationData.component3();
        SwaggerResult<String> specificationTextJson = this.convertToJsonIfNeeded(specificationText, psiFile2);
        if (specificationTextJson.isFailure()) {
            return SwaggerResult.Companion.failure(specificationTextJson.getFailureOrThrow());
        }
        String jsonText = specificationTextJson.getSuccessOrThrow();
        try {
            VirtualFile virtualFile2 = psiFile2.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
            string = this.inlineExternalDefinitions(jsonText, specificationType2, virtualFile2, ownDefinitionNames);
        }
        catch (IOException exception) {
            SpecificationReferencesInlineHelper $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Unable to inline external object definitions. Using raw specification.", (Throwable)exception);
            string = jsonText;
        }
        String specificationWithInlinedDefinitions = string;
        return SwaggerResult.Companion.success(this.escapeIllegalCharacters(specificationWithInlinedDefinitions));
    }

    /*
     * WARNING - void declaration
     */
    private final SwaggerResult<SpecificationData> readDataFromSpecification(PsiFile psiFile2) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] $this$iv = SwTreeUtil.INSTANCE;
        boolean withSelf$iv = true;
        boolean $i$f$getParentOfType22 = false;
        SwSpecificationFile specificationModel = $this$iv.getParentOfType((PsiElement)psiFile2, SwSpecificationFile.class, withSelf$iv);
        if (specificationModel == null) {
            $this$iv = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2.getName(), (String)"getName(...)");
            return SwaggerResult.Companion.failure$default(SwaggerResult.Companion, ErrorType.UNABLE_TO_CONVERT, SwaggerBundle.message("preview.error.unable.build.specification.model", $this$iv), null, 4, null);
        }
        $this$iv = specificationModel.getAllLocalObjectDefinitions();
        SwSpecificationType swSpecificationType = specificationModel.getSpecificationType();
        SwaggerResult.Companion companion = SwaggerResult.Companion;
        boolean $i$f$map = false;
        void $i$f$getParentOfType22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SwDefinition swDefinition = (SwDefinition)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName().getValue());
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        String string = psiFile2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        Collection collection3 = collection2;
        SwSpecificationType swSpecificationType2 = swSpecificationType;
        return companion.success(new SpecificationData(swSpecificationType2, collection3, string2));
    }

    private final String inlineExternalDefinitions(String specificationText, SwSpecificationType specificationType2, VirtualFile topLevelSpecificationFile, Collection<String> knownDefinitionNames) {
        JsonNode jsonSpecificationRoot = this.suitableMapperFor(topLevelSpecificationFile).readTree(specificationText);
        Intrinsics.checkNotNull((Object)jsonSpecificationRoot);
        JsonNode jsonNode = SpecificationReferencesInlineHelper.inlineDefinitionsWithDepth$default(this, jsonSpecificationRoot, topLevelSpecificationFile, specificationType2, new NameSuggester(knownDefinitionNames, topLevelSpecificationFile), null, 0, 48, null);
        if (jsonNode == null) {
            return specificationText;
        }
        JsonNode specificationTree = jsonNode;
        String string = this.jsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)specificationTree);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    static /* synthetic */ String inlineExternalDefinitions$default(SpecificationReferencesInlineHelper specificationReferencesInlineHelper, String string, SwSpecificationType swSpecificationType, VirtualFile virtualFile2, Collection collection, int n, Object object) {
        if ((n & 8) != 0) {
            collection = SetsKt.emptySet();
        }
        return specificationReferencesInlineHelper.inlineExternalDefinitions(string, swSpecificationType, virtualFile2, collection);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonNode inlineDefinitionsWithDepth(JsonNode jsonNode, VirtualFile containingFile, SwSpecificationType specificationType2, NameSuggester nameSuggester, String rootReference, int depth) {
        JsonNode jsonNode2;
        Object v2;
        void $this$reduceOrNull$iv;
        ProgressManager.checkCanceled();
        if (depth >= this.inlineDepthLimit) {
            SpecificationReferencesInlineHelper $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Inline depth limit was reached for: " + containingFile.getName());
            String string = rootReference;
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.unresolvedReferences.put(it, new ValidationData(SwaggerBundle.message("preview.error.validation.limit.reached", new Object[0]), containingFile, it));
            }
            return jsonNode;
        }
        String effectiveJsonAsString = this.jsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
        Intrinsics.checkNotNull((Object)effectiveJsonAsString);
        Sequence bl = SequencesKt.mapNotNull(this.findAllReferences(effectiveJsonAsString), (Function1)((Function1)new Function1<String, JsonNode>(this, containingFile, rootReference, depth, nameSuggester, specificationType2){
            final /* synthetic */ SpecificationReferencesInlineHelper this$0;
            final /* synthetic */ VirtualFile $containingFile;
            final /* synthetic */ String $rootReference;
            final /* synthetic */ int $depth;
            final /* synthetic */ NameSuggester $nameSuggester;
            final /* synthetic */ SwSpecificationType $specificationType;
            {
                this.this$0 = $receiver;
                this.$containingFile = $containingFile;
                this.$rootReference = $rootReference;
                this.$depth = $depth;
                this.$nameSuggester = $nameSuggester;
                this.$specificationType = $specificationType;
                super(1);
            }

            @Nullable
            public final JsonNode invoke(@NotNull String referenceName) {
                String rootReferenceValue;
                Intrinsics.checkNotNullParameter((Object)referenceName, (String)"referenceName");
                ReferenceData referenceData = SpecificationReferencesInlineHelper.access$collectReferenceData(this.this$0, referenceName, this.$containingFile);
                String string = this.$rootReference;
                if (string == null) {
                    string = rootReferenceValue = referenceName;
                }
                if (referenceData == null) {
                    if (!StringsKt.startsWith$default((String)referenceName, (String)"http", (boolean)false, (int)2, null)) {
                        SpecificationReferencesInlineHelper.access$putToUnresolved(this.this$0, rootReferenceValue, new ValidationData(SwaggerBundle.message("preview.error.validation.unknown.reference", new Object[0]), this.$containingFile, referenceName));
                    }
                    return null;
                }
                JsonNode jsonNode = SpecificationReferencesInlineHelper.access$getObjectDefinition(this.this$0, this.$depth, referenceData, referenceName, this.$containingFile, rootReferenceValue, this.$nameSuggester);
                if (jsonNode == null) {
                    return null;
                }
                JsonNode definition = jsonNode;
                return SpecificationReferencesInlineHelper.access$inlineDefinitionsWithDepth(this.this$0, definition, referenceData.getTargetFile(), this.$specificationType, this.$nameSuggester, rootReferenceValue, this.$depth + 1);
            }
        }));
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void patch;
                JsonNode jsonNode3 = (JsonNode)iterator$iv.next();
                JsonNode targetSchema = (JsonNode)accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = SwJsonSchemaPatchUtils.INSTANCE.mergeTrees(targetSchema, (JsonNode)patch, true);
            }
            v2 = accumulator$iv;
        }
        JsonNode allExternalDefinitions2 = v2;
        JsonNode targetJsonRootNode = this.jsonObjectMapper.readTree(this.substituteExternalReferences(effectiveJsonAsString, specificationType2, depth > 0, nameSuggester, containingFile));
        if (allExternalDefinitions2 == null) {
            jsonNode2 = targetJsonRootNode;
        } else {
            Intrinsics.checkNotNull((Object)targetJsonRootNode);
            jsonNode2 = SwJsonSchemaPatchUtils.INSTANCE.mergeTrees(targetJsonRootNode, this.wrapDefinitionIfNeeded(allExternalDefinitions2, specificationType2, depth), true);
        }
        return jsonNode2;
    }

    static /* synthetic */ JsonNode inlineDefinitionsWithDepth$default(SpecificationReferencesInlineHelper specificationReferencesInlineHelper, JsonNode jsonNode, VirtualFile virtualFile2, SwSpecificationType swSpecificationType, NameSuggester nameSuggester, String string, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            string = null;
        }
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        return specificationReferencesInlineHelper.inlineDefinitionsWithDepth(jsonNode, virtualFile2, swSpecificationType, nameSuggester, string, n);
    }

    private final JsonNode getObjectDefinition(int depth, ReferenceData refData, String originalReferenceValue, VirtualFile containingFile, String rootReferenceName, NameSuggester nameSuggester) {
        JsonNode definition;
        boolean isFromTopLevelSpecification = depth == 0 && Intrinsics.areEqual((Object)refData.getTargetFile(), (Object)containingFile);
        NameMapping nameMapping = nameSuggester.createNameMapping$intellij_swagger_core(refData);
        if (((CharSequence)nameMapping.getOriginalPath()).length() == 0 && Intrinsics.areEqual((Object)refData.getTargetFile(), (Object)containingFile)) {
            this.putToUnresolved(rootReferenceName, new ValidationData(SwaggerBundle.message("preview.error.validation.unknown.reference", new Object[0]), containingFile, originalReferenceValue));
        }
        if ((definition = this.readObjectDefinition(refData.getTargetFile(), nameMapping)) == null) {
            this.putToUnresolved(rootReferenceName, new ValidationData(SwaggerBundle.message("preview.error.validation.unknown.reference", new Object[0]), containingFile, originalReferenceValue));
            return null;
        }
        return isFromTopLevelSpecification ? null : definition;
    }

    private final void putToUnresolved(String referenceName, ValidationData validationData) {
        if (((CharSequence)referenceName).length() == 0) {
            return;
        }
        this.unresolvedReferences.put(referenceName, validationData);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonNode readObjectDefinition(VirtualFile file2, NameMapping nameMapping) {
        JsonNode jsonNode = this.jsonFilesCache.get(file2);
        if (jsonNode == null) {
            return null;
        }
        JsonNode node = jsonNode;
        if (((CharSequence)nameMapping.getOriginalPath()).length() == 0) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)nameMapping.getUniqueName(), (Object)node)};
            return this.createJsonNode(MapsKt.mutableMapOf((Pair[])pairArray));
        }
        Iterable $this$fold$iv = nameMapping.getOriginalPathSegments();
        boolean $i$f$fold = false;
        JsonNode accumulator$iv = node;
        for (Object element$iv : $this$fold$iv) {
            void pathSegment;
            JsonNode jsonNode2;
            String string = (String)element$iv;
            JsonNode currentNode = accumulator$iv;
            boolean bl = false;
            JsonNode jsonNode3 = jsonNode2 = currentNode.get(SwObjectDefinitionUtilsKt.unescapeSpecialSymbols((String)pathSegment));
            if (jsonNode3 == null) {
                SpecificationReferencesInlineHelper $this$readObjectDefinition_u24lambda_u246_u24lambda_u245 = this;
                boolean bl2 = false;
                boolean $i$f$logger = false;
                Logger logger2 = Logger.getInstance(SpecificationReferencesInlineHelper.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.debug("Unable to resolve node " + nameMapping.getOriginalName() + " inside file " + file2.getName());
                return null;
            }
            Intrinsics.checkNotNull((Object)jsonNode3);
            accumulator$iv = jsonNode2;
        }
        JsonNode foundDefinition = accumulator$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)SwObjectDefinitionUtilsKt.unescapeSpecialSymbols(nameMapping.getUniqueName()), (Object)foundDefinition)};
        return this.createJsonNode(MapsKt.mutableMapOf((Pair[])pairArray));
    }

    private final SwaggerResult<String> convertToJsonIfNeeded(String rawFileText, PsiFile containingFile) {
        return containingFile.getFileType() instanceof JsonFileType ? SwaggerResult.Companion.success(rawFileText) : this.convertYamlToJson(rawFileText, containingFile);
    }

    private final SwaggerResult<String> convertYamlToJson(String specificationText, PsiFile containingFile) {
        SwaggerResult<String> swaggerResult;
        try {
            Object yamlTree = this.yamlObjectMapper.readValue(specificationText, Object.class);
            String string = this.jsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(yamlTree);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            swaggerResult = SwaggerResult.Companion.success(string);
        }
        catch (JsonProcessingException exception) {
            SpecificationReferencesInlineHelper $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Unable to convert yaml specification to json format", (Throwable)exception);
            SwaggerValidationError validationError = SpecificationReferenceValidationHelperKt.generateValidationError(exception, containingFile);
            swaggerResult = SwaggerResult.Companion.failure(SpecificationReferenceValidationHelperKt.swaggerValidationFailure(containingFile, CollectionsKt.listOf((Object)validationError)));
        }
        return swaggerResult;
    }

    @NotNull
    public final SwaggerResult<String> convertJsonToYaml$intellij_swagger_core(@NotNull String specificationText, @NotNull PsiFile containingFile) {
        SwaggerResult<String> swaggerResult;
        Intrinsics.checkNotNullParameter((Object)specificationText, (String)"specificationText");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        try {
            JsonNode jsonTree = this.jsonObjectMapper.readTree(specificationText);
            String string = this.yamlObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonTree);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            swaggerResult = SwaggerResult.Companion.success(string);
        }
        catch (JsonProcessingException exception) {
            SpecificationReferencesInlineHelper $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Unable to convert json specification to yaml format", (Throwable)exception);
            SwaggerValidationError validationError = SpecificationReferenceValidationHelperKt.generateValidationError(exception, containingFile);
            swaggerResult = SwaggerResult.Companion.failure(SpecificationReferenceValidationHelperKt.swaggerValidationFailure(containingFile, CollectionsKt.listOf((Object)validationError)));
        }
        return swaggerResult;
    }

    private final Sequence<String> findAllReferences(String jsonSpecification) {
        return SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)REFERENCE_PATTERN, (CharSequence)jsonSpecification, (int)0, (int)2, null), (Function1)findAllReferences.1.INSTANCE));
    }

    private final ReferenceData collectReferenceData(String originalReferenceValue, VirtualFile containingFile) {
        Pair<String, String> pair = this.splitReference(originalReferenceValue);
        if (pair == null) {
            return null;
        }
        Pair<String, String> pair2 = pair;
        String filePath = (String)pair2.component1();
        String objectPath = (String)pair2.component2();
        VirtualFile virtualFile2 = this.findReferencedFile(filePath, containingFile);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile targetFile = virtualFile2;
        return new ReferenceData(targetFile, objectPath);
    }

    private final Pair<String, String> splitReference(String value) {
        MatchResult matchResult = REFERENCE_STRUCTURE_PATTERN.matchEntire((CharSequence)value);
        if (matchResult == null) {
            return TuplesKt.to((Object)value, (Object)"");
        }
        MatchResult matchEntire = matchResult;
        return matchEntire.getGroups().size() < 2 ? null : TuplesKt.to(matchEntire.getGroupValues().get(1), matchEntire.getGroupValues().get(2));
    }

    private final VirtualFile findReferencedFile(String filePath, VirtualFile containingFile) {
        VirtualFile targetFile;
        VirtualFile virtualFile2 = targetFile = ((CharSequence)filePath).length() > 0 ? this.resolveRelativeFilePath(containingFile, filePath) : containingFile;
        if (targetFile == null || targetFile.isDirectory()) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Unable to resolve external reference because specified file is not found: " + filePath);
            return null;
        }
        return targetFile;
    }

    private final VirtualFile resolveRelativeFilePath(VirtualFile specification, String relativePath) {
        VirtualFile virtualFile2 = specification.getParent();
        return virtualFile2 != null ? virtualFile2.findFileByRelativePath(relativePath) : null;
    }

    private final String substituteExternalReferences(String jsonSpecification, SwSpecificationType specificationType2, boolean substituteLocalReferences, NameSuggester nameSuggester, VirtualFile containingFile) {
        CharSequence charSequence = jsonSpecification;
        Regex regex = REFERENCE_PATTERN;
        Function1 function1 = (Function1)new Function1<MatchResult, CharSequence>(substituteLocalReferences, this, specificationType2, nameSuggester, containingFile){
            final /* synthetic */ boolean $substituteLocalReferences;
            final /* synthetic */ SpecificationReferencesInlineHelper this$0;
            final /* synthetic */ SwSpecificationType $specificationType;
            final /* synthetic */ NameSuggester $nameSuggester;
            final /* synthetic */ VirtualFile $containingFile;
            {
                this.$substituteLocalReferences = $substituteLocalReferences;
                this.this$0 = $receiver;
                this.$specificationType = $specificationType;
                this.$nameSuggester = $nameSuggester;
                this.$containingFile = $containingFile;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getGroups().size() < 1) {
                    return it.getValue();
                }
                String referenceBody = (String)it.getGroupValues().get(1);
                if (((CharSequence)referenceBody).length() == 0 || !this.$substituteLocalReferences && SpecificationReferencesInlineHelper.access$isLocalReference(this.this$0, referenceBody)) {
                    return it.getValue();
                }
                return SpecificationReferencesInlineHelper.access$suggestInlinedObjectPath(this.this$0, referenceBody, this.$specificationType, this.$nameSuggester, this.$containingFile);
            }
        };
        return regex.replace(charSequence, function1);
    }

    private final boolean isLocalReference(String referenceBody) {
        return StringsKt.startsWith$default((String)referenceBody, (String)"#/", (boolean)false, (int)2, null);
    }

    private final JsonNode wrapDefinitionIfNeeded(JsonNode definitionsNode, SwSpecificationType specificationType2, int depth) {
        return depth == 0 ? this.wrapDefinitions(definitionsNode, specificationType2) : definitionsNode;
    }

    private final JsonNode wrapDefinitions(JsonNode definitionsNode, SwSpecificationType specificationType2) {
        JsonNode jsonNode;
        SwSpecificationType swSpecificationType = specificationType2;
        if (swSpecificationType instanceof SwSpecificationType.Swagger2Family) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"definitions", (Object)definitionsNode)};
            jsonNode = this.createJsonNode(MapsKt.mutableMapOf((Pair[])pairArray));
        } else if (swSpecificationType instanceof SwSpecificationType.OpenAPI3Family ? true : swSpecificationType instanceof SwSpecificationType.AsyncAPIFamily) {
            Pair[] pairArray = new Pair[1];
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"schemas", (Object)definitionsNode)};
            pairArray[0] = TuplesKt.to((Object)"components", (Object)this.createJsonNode(MapsKt.mutableMapOf((Pair[])pairArray2)));
            jsonNode = this.createJsonNode(MapsKt.mutableMapOf((Pair[])pairArray));
        } else {
            throw new IllegalArgumentException("There is no object definitions storage template for specification type: " + specificationType2);
        }
        return jsonNode;
    }

    private final String suggestInlinedObjectPath(String referenceBody, SwSpecificationType specificationType2, NameSuggester nameSuggester, VirtualFile containingFile) {
        NameMapping nameMapping = nameSuggester.getNameForReference$intellij_swagger_core(this.collectReferenceData(referenceBody, containingFile));
        String uniqueName = nameMapping != null ? nameMapping.getUniqueName() : null;
        CharSequence charSequence = uniqueName;
        return charSequence == null || charSequence.length() == 0 ? "\"$ref\": \"" + referenceBody + "\"" : (specificationType2 instanceof SwSpecificationType.Swagger2Family ? "\"$ref\": \"#/definitions/" + uniqueName + "\"" : (specificationType2 instanceof SwSpecificationType.OpenAPI3Family || specificationType2 instanceof SwSpecificationType.AsyncAPIFamily ? "\"$ref\": \"#/components/schemas/" + uniqueName + "\"" : "\"$ref\": \"" + referenceBody + "\""));
    }

    private final JsonNode createJsonNode(Map<String, JsonNode> children) {
        return (JsonNode)new ObjectNode(this.jsonObjectMapper.getNodeFactory(), children);
    }

    static /* synthetic */ JsonNode createJsonNode$default(SpecificationReferencesInlineHelper specificationReferencesInlineHelper, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            map2 = new LinkedHashMap();
        }
        return specificationReferencesInlineHelper.createJsonNode(map2);
    }

    private final String escapeIllegalCharacters(String specificationText) {
        return StringsKt.replace$default((String)specificationText, (String)"</", (String)"<\\/", (boolean)false, (int)4, null);
    }

    private static final JsonNode jsonFilesCache$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JsonNode)$tmp0.invoke(p0);
    }

    private static final SwaggerResult prepareSpecificationText$lambda$1(SpecificationReferencesInlineHelper this$0, PsiFile $psiFile) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$psiFile, (String)"$psiFile");
        return this$0.readDataFromSpecification($psiFile);
    }

    public SpecificationReferencesInlineHelper() {
        this(0, 1, null);
    }

    public static final /* synthetic */ ReferenceData access$collectReferenceData(SpecificationReferencesInlineHelper $this, String originalReferenceValue, VirtualFile containingFile) {
        return $this.collectReferenceData(originalReferenceValue, containingFile);
    }

    public static final /* synthetic */ void access$putToUnresolved(SpecificationReferencesInlineHelper $this, String referenceName, ValidationData validationData) {
        $this.putToUnresolved(referenceName, validationData);
    }

    public static final /* synthetic */ JsonNode access$getObjectDefinition(SpecificationReferencesInlineHelper $this, int depth, ReferenceData refData, String originalReferenceValue, VirtualFile containingFile, String rootReferenceName, NameSuggester nameSuggester) {
        return $this.getObjectDefinition(depth, refData, originalReferenceValue, containingFile, rootReferenceName, nameSuggester);
    }

    public static final /* synthetic */ JsonNode access$inlineDefinitionsWithDepth(SpecificationReferencesInlineHelper $this, JsonNode jsonNode, VirtualFile containingFile, SwSpecificationType specificationType2, NameSuggester nameSuggester, String rootReference, int depth) {
        return $this.inlineDefinitionsWithDepth(jsonNode, containingFile, specificationType2, nameSuggester, rootReference, depth);
    }

    public static final /* synthetic */ boolean access$isLocalReference(SpecificationReferencesInlineHelper $this, String referenceBody) {
        return $this.isLocalReference(referenceBody);
    }

    public static final /* synthetic */ String access$suggestInlinedObjectPath(SpecificationReferencesInlineHelper $this, String referenceBody, SwSpecificationType specificationType2, NameSuggester nameSuggester, VirtualFile containingFile) {
        return $this.suggestInlinedObjectPath(referenceBody, specificationType2, nameSuggester, containingFile);
    }

    public static final /* synthetic */ ObjectMapper access$suitableMapperFor(SpecificationReferencesInlineHelper $this, VirtualFile file2) {
        return $this.suitableMapperFor(file2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/swagger/core/ui/SpecificationReferencesInlineHelper$Companion;", "", "()V", "DEFINITION_PATH_GROUP_INDEX", "", "EXTERNAL_FILE_GROUP_INDEX", "MAXIMUM_INLINE_DEPTH", "REFERENCE_BODY_GROUP_INDEX", "REFERENCE_PATTERN", "Lkotlin/text/Regex;", "REFERENCE_STRUCTURE_PATTERN", "intellij.swagger.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

