/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.traverser;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.swagger.core.meta.SwElementProvider;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.traverser.SpecificationTraverser;
import com.intellij.swagger.core.traverser.SpecificationTraverserFactory;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00040\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ0\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\n\b\u0000\u0010\u0004\u0018\u0001*\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0086\b\u00a2\u0006\u0002\u0010\rJ.\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\n\b\u0000\u0010\u0004\u0018\u0001*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0086\b\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\n\u001a\u00020\u000bJ?\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\"\u0010\u0013\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\t0\u0014\"\n\u0012\u0006\b\u0001\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/swagger/core/traverser/SwTreeUtil;", "", "()V", "getParentOfType", "Type", "Lcom/intellij/swagger/core/model/api/SwModelElement;", "psiElement", "Lcom/intellij/psi/PsiElement;", "elementClass", "Ljava/lang/Class;", "withSelf", "", "(Lcom/intellij/psi/PsiElement;Ljava/lang/Class;Z)Lcom/intellij/swagger/core/model/api/SwModelElement;", "(Lcom/intellij/psi/PsiElement;Z)Lcom/intellij/swagger/core/model/api/SwModelElement;", "swElement", "(Lcom/intellij/swagger/core/model/api/SwModelElement;Z)Lcom/intellij/swagger/core/model/api/SwModelElement;", "getParents", "Lkotlin/sequences/Sequence;", "getParentsOfTypes", "elementClasses", "", "(Lcom/intellij/psi/PsiElement;[Ljava/lang/Class;)Lkotlin/sequences/Sequence;", "intellij.swagger.core"})
public final class SwTreeUtil {
    @NotNull
    public static final SwTreeUtil INSTANCE = new SwTreeUtil();

    private SwTreeUtil() {
    }

    @NotNull
    public final Sequence<SwModelElement> getParents(@Nullable PsiElement psiElement, boolean withSelf) {
        if (psiElement == null) {
            return SequencesKt.emptySequence();
        }
        if (!psiElement.isValid()) {
            Logger.getInstance(SwTreeUtil.class).info("Invalid psiElement received during swagger model elements request.");
            return SequencesKt.emptySequence();
        }
        FileType fileType = psiElement.getContainingFile().getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        SpecificationTraverser specificationTraverser = SpecificationTraverserFactory.INSTANCE.getTraverserFor(fileType);
        if (specificationTraverser == null) {
            return SequencesKt.emptySequence();
        }
        SpecificationTraverser traverser = specificationTraverser;
        PsiElement startElement = withSelf ? psiElement : traverser.getParent(psiElement);
        return SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)startElement, (Function1)((Function1)new Function1<PsiElement, PsiElement>((Object)traverser){

            @Nullable
            public final PsiElement invoke(@Nullable PsiElement p0) {
                return ((SpecificationTraverser)this.receiver).getParent(p0);
            }
        })), (Function1)((Function1)new Function1<PsiElement, SwModelElement>((Object)SwElementProvider.INSTANCE){

            @Nullable
            public final SwModelElement invoke(@Nullable PsiElement p0) {
                return ((SwElementProvider)this.receiver).getModelElement(p0);
            }
        }));
    }

    public static /* synthetic */ Sequence getParents$default(SwTreeUtil swTreeUtil, PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return swTreeUtil.getParents(psiElement, bl);
    }

    @Nullable
    public final <Type extends SwModelElement> Type getParentOfType(@Nullable PsiElement psiElement, @NotNull Class<? extends Type> elementClass, boolean withSelf) {
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        return (Type)((SwModelElement)SequencesKt.firstOrNull((Sequence)SequencesKt.filterIsInstance(this.getParents(psiElement, withSelf), elementClass)));
    }

    public static /* synthetic */ SwModelElement getParentOfType$default(SwTreeUtil swTreeUtil, PsiElement psiElement, Class clazz, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return swTreeUtil.getParentOfType(psiElement, clazz, bl);
    }

    @NotNull
    public final Sequence<SwModelElement> getParentsOfTypes(@Nullable PsiElement psiElement, Class<? extends SwModelElement> ... elementClasses) {
        Intrinsics.checkNotNullParameter(elementClasses, (String)"elementClasses");
        return SequencesKt.filter(this.getParents(psiElement, true), (Function1)((Function1)new Function1<SwModelElement, Boolean>(elementClasses){
            final /* synthetic */ Class<? extends SwModelElement>[] $elementClasses;
            {
                this.$elementClasses = $elementClasses;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SwModelElement modelElement) {
                boolean bl;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)modelElement, (String)"modelElement");
                    Class<? extends SwModelElement>[] $this$any$iv = this.$elementClasses;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        Class<? extends SwModelElement> element$iv;
                        Class<? extends SwModelElement> it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!it.isAssignableFrom(modelElement.getClass())) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
        }));
    }

    public final /* synthetic */ <Type extends SwModelElement> Type getParentOfType(PsiElement psiElement, boolean withSelf) {
        boolean $i$f$getParentOfType = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"Type");
        return (Type)this.getParentOfType(psiElement, SwModelElement.class, withSelf);
    }

    public static /* synthetic */ SwModelElement getParentOfType$default(SwTreeUtil $this, PsiElement psiElement, boolean withSelf, int n, Object object) {
        if ((n & 2) != 0) {
            withSelf = true;
        }
        boolean $i$f$getParentOfType = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"Type");
        return $this.getParentOfType(psiElement, SwModelElement.class, withSelf);
    }

    public final /* synthetic */ <Type extends SwModelElement> Type getParentOfType(SwModelElement swElement, boolean withSelf) {
        Intrinsics.checkNotNullParameter((Object)swElement, (String)"swElement");
        boolean $i$f$getParentOfType = false;
        PsiElement psiElement = swElement.getSourcePsi();
        Intrinsics.reifiedOperationMarker((int)4, (String)"Type");
        return (Type)this.getParentOfType(psiElement, SwModelElement.class, withSelf);
    }

    public static /* synthetic */ SwModelElement getParentOfType$default(SwTreeUtil $this, SwModelElement swElement, boolean withSelf, int n, Object object) {
        if ((n & 2) != 0) {
            withSelf = false;
        }
        Intrinsics.checkNotNullParameter((Object)swElement, (String)"swElement");
        boolean $i$f$getParentOfType = false;
        PsiElement psiElement = swElement.getSourcePsi();
        Intrinsics.reifiedOperationMarker((int)4, (String)"Type");
        return $this.getParentOfType(psiElement, SwModelElement.class, withSelf);
    }
}

